/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestRollbackFromClient {
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static final int SLAVES = 3;
    private static final byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static final byte[] QUALIFIER_V2 = Bytes.toBytes((String)"testQualifierV2");
    private static final byte[] VALUE = Bytes.toBytes((String)"testValue");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().set("hbase.wal.provider", FailedDefaultWALProvider.class.getName());
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAppendRollback() throws IOException {
        Updater updateForEmptyTable = new Updater(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateData(Table table, byte[] family) {
                try {
                    Append append = new Append(ROW);
                    append.add(FAMILY, QUALIFIER, VALUE);
                    append.add(FAMILY, QUALIFIER_V2, VALUE);
                    FailedHLog.SHOULD_FAIL.set(true);
                    table.append(append);
                }
                catch (IOException iOException) {
                }
                finally {
                    FailedHLog.SHOULD_FAIL.set(false);
                }
                return 0;
            }
        };
        this.testRollback(updateForEmptyTable, 1, null);
        this.testRollback(updateForEmptyTable, 2, null);
        final Append preAppend = new Append(ROW);
        preAppend.add(FAMILY, QUALIFIER, VALUE);
        Cell initCell = (Cell)preAppend.getCellList(FAMILY).get(0);
        Updater updateForNonEmptyTable = new Updater(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateData(Table table, byte[] family) throws IOException {
                table.append(preAppend);
                try {
                    Append append = new Append(ROW);
                    append.add(FAMILY, QUALIFIER, VALUE);
                    append.add(FAMILY, QUALIFIER_V2, VALUE);
                    FailedHLog.SHOULD_FAIL.set(true);
                    table.append(append);
                    Assert.fail((String)"It should fail because the WAL sync is failed");
                }
                catch (IOException iOException) {
                }
                finally {
                    FailedHLog.SHOULD_FAIL.set(false);
                }
                return 1;
            }
        };
        this.testRollback(updateForNonEmptyTable, 1, initCell);
        this.testRollback(updateForNonEmptyTable, 2, initCell);
    }

    @Test
    public void testIncrementRollback() throws IOException {
        Updater updateForEmptyTable = new Updater(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateData(Table table, byte[] family) {
                try {
                    Increment inc = new Increment(ROW);
                    inc.addColumn(FAMILY, QUALIFIER, 1L);
                    inc.addColumn(FAMILY, QUALIFIER_V2, 2L);
                    FailedHLog.SHOULD_FAIL.set(true);
                    table.increment(inc);
                }
                catch (IOException iOException) {
                }
                finally {
                    FailedHLog.SHOULD_FAIL.set(false);
                }
                return 0;
            }
        };
        this.testRollback(updateForEmptyTable, 1, null);
        this.testRollback(updateForEmptyTable, 2, null);
        final Increment preIncrement = new Increment(ROW);
        preIncrement.addColumn(FAMILY, QUALIFIER, 1L);
        Cell initCell = (Cell)preIncrement.getCellList(FAMILY).get(0);
        Updater updateForNonEmptyTable = new Updater(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateData(Table table, byte[] family) throws IOException {
                table.increment(preIncrement);
                try {
                    Increment inc = new Increment(ROW);
                    inc.addColumn(FAMILY, QUALIFIER, 1L);
                    inc.addColumn(FAMILY, QUALIFIER_V2, 2L);
                    FailedHLog.SHOULD_FAIL.set(true);
                    table.increment(inc);
                    Assert.fail((String)"It should fail because the WAL sync is failed");
                }
                catch (IOException iOException) {
                }
                finally {
                    FailedHLog.SHOULD_FAIL.set(false);
                }
                return 1;
            }
        };
        this.testRollback(updateForNonEmptyTable, 1, initCell);
        this.testRollback(updateForNonEmptyTable, 2, initCell);
    }

    @Test
    public void testPutRollback() throws IOException {
        Updater updateForEmptyTable = new Updater(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateData(Table table, byte[] family) {
                try {
                    Put put = new Put(ROW);
                    put.addColumn(FAMILY, QUALIFIER, VALUE);
                    FailedHLog.SHOULD_FAIL.set(true);
                    table.put(put);
                    Assert.fail((String)"It should fail because the WAL sync is failed");
                }
                catch (IOException iOException) {
                }
                finally {
                    FailedHLog.SHOULD_FAIL.set(false);
                }
                return 0;
            }
        };
        this.testRollback(updateForEmptyTable, 1, null);
        this.testRollback(updateForEmptyTable, 2, null);
        final Put prePut = new Put(ROW);
        prePut.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)"aaaaaaaaaaaaaaaaaaaaaa"));
        Cell preCell = (Cell)prePut.getCellList(FAMILY).get(0);
        Updater updateForNonEmptyTable = new Updater(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateData(Table table, byte[] family) throws IOException {
                table.put(prePut);
                try {
                    Put put = new Put(ROW);
                    put.addColumn(FAMILY, QUALIFIER, VALUE);
                    FailedHLog.SHOULD_FAIL.set(true);
                    table.put(put);
                    Assert.fail((String)"It should fail because the WAL sync is failed");
                }
                catch (IOException iOException) {
                }
                finally {
                    FailedHLog.SHOULD_FAIL.set(false);
                }
                return 1;
            }
        };
        this.testRollback(updateForNonEmptyTable, 1, preCell);
        this.testRollback(updateForNonEmptyTable, 2, preCell);
    }

    private void testRollback(Updater updater, int versions, Cell initCell) throws IOException {
        List<Cell> cells;
        int expected;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor col = new HColumnDescriptor(FAMILY);
        col.setMaxVersions(versions);
        desc.addFamily(col);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table table = conn.getTable(tableName);){
            expected = updater.updateData(table, FAMILY);
            cells = TestRollbackFromClient.getAllCells(table);
        }
        TEST_UTIL.getHBaseAdmin().disableTable(tableName);
        TEST_UTIL.getHBaseAdmin().deleteTable(tableName);
        Assert.assertEquals((long)expected, (long)cells.size());
        if (initCell != null && cells.isEmpty()) {
            Cell cell = cells.get(0);
            Assert.assertTrue((String)"row isn't matched", (boolean)CellUtil.matchingRow((Cell)initCell, (Cell)cell));
            Assert.assertTrue((String)"column isn't matched", (boolean)CellUtil.matchingColumn((Cell)initCell, (Cell)cell));
            Assert.assertTrue((String)"qualifier isn't matched", (boolean)CellUtil.matchingQualifier((Cell)initCell, (Cell)cell));
            Assert.assertTrue((String)"value isn't matched", (boolean)CellUtil.matchingValue((Cell)initCell, (Cell)cell));
        }
    }

    private static List<Cell> getAllCells(Table table) throws IOException {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        try (ResultScanner scanner = table.getScanner(new Scan());){
            for (Result r : scanner) {
                cells.addAll(r.listCells());
            }
            ArrayList<Cell> arrayList = cells;
            return arrayList;
        }
    }

    public static class FailedHLog
    implements WAL {
        private static final AtomicBoolean SHOULD_FAIL = new AtomicBoolean(false);
        private final WAL delegation;

        FailedHLog(WAL delegation) {
            this.delegation = delegation;
        }

        public void registerWALActionsListener(WALActionsListener listener) {
            this.delegation.registerWALActionsListener(listener);
        }

        public boolean unregisterWALActionsListener(WALActionsListener listener) {
            return this.delegation.unregisterWALActionsListener(listener);
        }

        public byte[][] rollWriter() throws FailedLogCloseException, IOException {
            return this.delegation.rollWriter();
        }

        public byte[][] rollWriter(boolean force) throws FailedLogCloseException, IOException {
            return this.delegation.rollWriter(force);
        }

        public void shutdown() throws IOException {
            this.delegation.shutdown();
        }

        public void close() throws IOException {
            this.delegation.close();
        }

        public long append(HTableDescriptor htd, HRegionInfo info, WALKey key, WALEdit edits, boolean inMemstore) throws IOException {
            return this.delegation.append(htd, info, key, edits, inMemstore);
        }

        public void sync() throws IOException {
            this.delegation.sync();
        }

        public void sync(long txid) throws IOException {
            this.sync(txid, false);
        }

        public void sync(boolean forceSync) throws IOException {
            this.delegation.sync(forceSync);
        }

        public void sync(long txid, boolean forceSync) throws IOException {
            if (SHOULD_FAIL.get()) {
                throw new IOException("[TESTING] we need the failure!!!");
            }
            this.delegation.sync(txid, forceSync);
        }

        public Long startCacheFlush(byte[] encodedRegionName, Set<byte[]> families) {
            return this.delegation.startCacheFlush(encodedRegionName, families);
        }

        public void completeCacheFlush(byte[] encodedRegionName) {
            this.delegation.completeCacheFlush(encodedRegionName);
        }

        public void abortCacheFlush(byte[] encodedRegionName) {
            this.delegation.abortCacheFlush(encodedRegionName);
        }

        public WALCoprocessorHost getCoprocessorHost() {
            return this.delegation.getCoprocessorHost();
        }

        public long getEarliestMemstoreSeqNum(byte[] encodedRegionName) {
            return this.delegation.getEarliestMemstoreSeqNum(encodedRegionName);
        }

        public long getEarliestMemstoreSeqNum(byte[] encodedRegionName, byte[] familyName) {
            return this.delegation.getEarliestMemstoreSeqNum(encodedRegionName, familyName);
        }
    }

    public static class FailedDefaultWALProvider
    extends DefaultWALProvider {
        public WAL getWAL(byte[] identifier, byte[] namespace) throws IOException {
            WAL wal = super.getWAL(identifier, namespace);
            return new FailedHLog(wal);
        }
    }

    static interface Updater {
        public int updateData(Table var1, byte[] var2) throws IOException;
    }
}

