/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestCopyTable {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytes((String)"row1");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final String FAMILY_A_STRING = "a";
    private static final String FAMILY_B_STRING = "b";
    private static final byte[] FAMILY_A = Bytes.toBytes((String)"a");
    private static final byte[] FAMILY_B = Bytes.toBytes((String)"b");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.setJobWithoutMRCluster();
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyTableTest(boolean bulkload) throws Exception {
        TableName TABLENAME1 = TableName.valueOf((String)"testCopyTable1");
        TableName TABLENAME2 = TableName.valueOf((String)"testCopyTable2");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        try (HTable t1 = TEST_UTIL.createTable(TABLENAME1, FAMILY);
             HTable t2 = TEST_UTIL.createTable(TABLENAME2, FAMILY);){
            this.loadData((Table)t1, FAMILY, COLUMN1);
            CopyTable copy = new CopyTable(TEST_UTIL.getConfiguration());
            int code = bulkload ? ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + TABLENAME2.getNameAsString(), "--bulkload", TABLENAME1.getNameAsString()}) : ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + TABLENAME2.getNameAsString(), TABLENAME1.getNameAsString()});
            Assert.assertEquals((String)"copy job failed", (long)0L, (long)code);
            this.verifyRows((Table)t2, FAMILY, COLUMN1);
        }
        finally {
            TEST_UTIL.deleteTable(TABLENAME1);
            TEST_UTIL.deleteTable(TABLENAME2);
        }
    }

    @Test
    public void testCopyTable() throws Exception {
        this.doCopyTableTest(false);
    }

    @Test
    public void testCopyTableWithBulkload() throws Exception {
        this.doCopyTableTest(true);
    }

    @Test
    public void testStartStopRow() throws Exception {
        TableName TABLENAME1 = TableName.valueOf((String)"testStartStopRow1");
        TableName TABLENAME2 = TableName.valueOf((String)"testStartStopRow2");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        byte[] ROW0 = Bytes.toBytesBinary((String)"\\x01row0");
        byte[] ROW1 = Bytes.toBytesBinary((String)"\\x01row1");
        byte[] ROW2 = Bytes.toBytesBinary((String)"\\x01row2");
        HTable t1 = TEST_UTIL.createTable(TABLENAME1, FAMILY);
        HTable t2 = TEST_UTIL.createTable(TABLENAME2, FAMILY);
        Put p = new Put(ROW0);
        p.add(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        p = new Put(ROW1);
        p.add(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        p = new Put(ROW2);
        p.add(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        CopyTable copy = new CopyTable(TEST_UTIL.getConfiguration());
        Assert.assertEquals((long)0L, (long)copy.run(new String[]{"--new.name=" + TABLENAME2, "--startrow=\\x01row1", "--stoprow=\\x01row2", TABLENAME1.getNameAsString()}));
        Get g = new Get(ROW1);
        Result r = t2.get(g);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN1));
        g = new Get(ROW0);
        r = t2.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        g = new Get(ROW2);
        r = t2.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        t1.close();
        t2.close();
        TEST_UTIL.deleteTable(TABLENAME1);
        TEST_UTIL.deleteTable(TABLENAME2);
    }

    @Test
    public void testRenameFamily() throws Exception {
        String sourceTable = "sourceTable";
        String targetTable = "targetTable";
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        HTable t = TEST_UTIL.createTable(Bytes.toBytes((String)sourceTable), (byte[][])families);
        HTable t2 = TEST_UTIL.createTable(Bytes.toBytes((String)targetTable), (byte[][])families);
        Put p = new Put(ROW1);
        p.add(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data11"));
        p.add(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Data12"));
        p.add(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data13"));
        t.put(p);
        p = new Put(ROW2);
        p.add(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Dat21"));
        p.add(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data22"));
        p.add(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Data23"));
        t.put(p);
        long currentTime = System.currentTimeMillis();
        String[] args = new String[]{"--new.name=" + targetTable, "--families=a:b", "--all.cells", "--starttime=" + (currentTime - 100000L), "--endtime=" + (currentTime + 100000L), "--versions=1", sourceTable};
        Assert.assertNull((Object)t2.get(new Get(ROW1)).getRow());
        Assert.assertTrue((boolean)this.runCopy(args));
        Assert.assertNotNull((Object)t2.get(new Get(ROW1)).getRow());
        Result res = t2.get(new Get(ROW1));
        byte[] b1 = res.getValue(FAMILY_B, QUALIFIER);
        Assert.assertEquals((Object)"Data13", (Object)new String(b1));
        Assert.assertNotNull((Object)t2.get(new Get(ROW2)).getRow());
        res = t2.get(new Get(ROW2));
        b1 = res.getValue(FAMILY_A, QUALIFIER);
        Assert.assertNull((Object)b1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethod() throws Exception {
        String[] emptyArgs = new String[]{"-h"};
        PrintStream oldWriter = System.err;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(data);
        System.setErr(writer);
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        try {
            CopyTable.main((String[])emptyArgs);
            Assert.fail((String)"should be exit");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)1L, (long)newSecurityManager.getExitCode());
        }
        finally {
            System.setErr(oldWriter);
            System.setSecurityManager(SECURITY_MANAGER);
        }
        Assert.assertTrue((boolean)data.toString().contains("rs.class"));
        Assert.assertTrue((boolean)data.toString().contains("Usage:"));
    }

    private boolean runCopy(String[] args) throws Exception {
        CopyTable copy = new CopyTable(TEST_UTIL.getConfiguration());
        int code = ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])args);
        return code == 0;
    }

    private void loadData(Table t, byte[] family, byte[] column) throws IOException {
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put p = new Put(row);
            p.addColumn(family, column, row);
            t.put(p);
        }
    }

    private void verifyRows(Table t, byte[] family, byte[] column) throws IOException {
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Get g = new Get(row).addFamily(family);
            Result r = t.get(g);
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            Cell cell = r.rawCells()[0];
            Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)cell, (byte[])column));
            Assert.assertEquals((long)Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])row, (int)0, (int)row.length), (long)0L);
        }
    }

    private void testCopyTableBySnapshot(String tablePrefix, boolean bulkLoad) throws Exception {
        TableName table1 = TableName.valueOf((String)(tablePrefix + 1));
        TableName table2 = TableName.valueOf((String)(tablePrefix + 2));
        HTable t1 = TEST_UTIL.createTable(table1, FAMILY_A);
        HTable t2 = TEST_UTIL.createTable(table2, FAMILY_A);
        this.loadData((Table)t1, FAMILY_A, Bytes.toBytes((String)"qualifier"));
        String snapshot = tablePrefix + "_snapshot";
        TEST_UTIL.getHBaseAdmin().snapshot(snapshot, table1);
        boolean success = bulkLoad ? this.runCopy(new String[]{"--snapshot", "--new.name=" + table2, "--bulkload", snapshot}) : this.runCopy(new String[]{"--snapshot", "--new.name=" + table2, snapshot});
        Assert.assertTrue((boolean)success);
        this.verifyRows((Table)t2, FAMILY_A, Bytes.toBytes((String)"qualifier"));
    }

    @Test
    public void testLoadingSnapshotToTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotToTable", false);
    }

    @Test
    public void testLoadingSnapshotAndBulkLoadToTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotAndBulkLoadToTable", true);
    }

    @Test
    public void testLoadingSnapshotToRemoteCluster() throws Exception {
        Assert.assertFalse((boolean)this.runCopy(new String[]{"--snapshot", "--peerAdr=hbase://remoteHBase", "sourceSnapshotName"}));
    }

    @Test
    public void testLoadingSnapshotWithoutSnapshotName() throws Exception {
        Assert.assertFalse((boolean)this.runCopy(new String[]{"--snapshot", "--peerAdr=hbase://remoteHBase"}));
    }

    @Test
    public void testLoadingSnapshotWithoutDestTable() throws Exception {
        Assert.assertFalse((boolean)this.runCopy(new String[]{"--snapshot", "sourceSnapshotName"}));
    }
}

