/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRequestsPerSecondMetric {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final long METRICS_PERIOD = 2000L;
    private static Configuration conf;

    @BeforeClass
    public static void setup() throws Exception {
        conf = UTIL.getConfiguration();
        conf.setLong("hbase.regionserver.metrics.period", 2000L);
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testNoNegativeSignAtRequestsPerSecond() throws IOException, InterruptedException {
        TableName TABLENAME = TableName.valueOf((String)"t");
        String FAMILY = "f";
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        UTIL.createMultiRegionTable(TABLENAME, "f".getBytes(), 25);
        Table table = admin.getConnection().getTable(TABLENAME);
        HRegionServer regionServer = UTIL.getMiniHBaseCluster().getRegionServer(0);
        MetricsRegionServerWrapperImpl metricsWrapper = new MetricsRegionServerWrapperImpl(regionServer);
        MetricsRegionServerWrapperImpl.RegionServerMetricsWrapperRunnable metricsServer = new MetricsRegionServerWrapperImpl.RegionServerMetricsWrapperRunnable(metricsWrapper);
        metricsServer.run();
        UTIL.loadNumericRows(table, "f".getBytes(), 1, 2000);
        Thread.sleep(2000L);
        metricsServer.run();
        admin.disableTable(TABLENAME);
        Thread.sleep(2000L);
        metricsServer.run();
        Assert.assertTrue((metricsWrapper.getRequestsPerSecond() > -1.0 ? 1 : 0) != 0);
    }
}

