/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.FIFOCompactionPolicy;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.TimeOffsetEnvironmentEdge;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MediumTests.class})
public class TestFIFOCompactionPolicy {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final byte[] family = Bytes.toBytes((String)"f");
    private final byte[] qualifier = Bytes.toBytes((String)"q");
    @Rule
    public ExpectedException error = ExpectedException.none();

    private Store getStoreWithName(TableName tableName) {
        MiniHBaseCluster cluster = TEST_UTIL.getMiniHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> rsts = cluster.getRegionServerThreads();
        for (int i = 0; i < cluster.getRegionServerThreads().size(); ++i) {
            HRegionServer hrs = rsts.get(i).getRegionServer();
            Iterator i$ = hrs.getOnlineRegions(tableName).iterator();
            if (!i$.hasNext()) continue;
            Region region = (Region)i$.next();
            return (Store)region.getStores().iterator().next();
        }
        return null;
    }

    private Store prepareData(TableName tableName) throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setConfiguration("hbase.hstore.defaultengine.compactionpolicy.class", FIFOCompactionPolicy.class.getName());
        desc.setConfiguration("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName());
        HColumnDescriptor colDesc = new HColumnDescriptor(this.family);
        colDesc.setTimeToLive(1);
        desc.addFamily(colDesc);
        admin.createTable(desc);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        TimeOffsetEnvironmentEdge edge = (TimeOffsetEnvironmentEdge)EnvironmentEdgeManager.getDelegate();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                byte[] value = new byte[131072];
                ThreadLocalRandom.current().nextBytes(value);
                table.put(new Put(Bytes.toBytes((int)(i * 10 + j))).addColumn(this.family, this.qualifier, value));
            }
            admin.flush(tableName);
            edge.increment(1001L);
        }
        return this.getStoreWithName(tableName);
    }

    @BeforeClass
    public static void setEnvironmentEdge() throws Exception {
        TimeOffsetEnvironmentEdge ee = new TimeOffsetEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)ee);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hstore.blockingStoreFiles", 10000);
        conf.setBoolean("hbase.store.delete.expired.storefile", false);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void resetEnvironmentEdge() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testPurgeExpiredFiles() throws Exception {
        TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
        final Store store = this.prepareData(tableName);
        Assert.assertEquals((long)10L, (long)store.getStorefilesCount());
        TEST_UTIL.getHBaseAdmin().majorCompact(tableName);
        TEST_UTIL.waitFor(30000L, new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return store.getStorefilesCount() == 1;
            }

            public String explainFailure() throws Exception {
                return "The store file count " + store.getStorefilesCount() + " is still greater than 1";
            }
        });
    }

    @Test
    public void testSanityCheckTTL() throws IOException {
        this.error.expect(DoNotRetryIOException.class);
        this.error.expectMessage("Default TTL is not supported");
        TableName tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "-TTL"));
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setConfiguration("hbase.hstore.defaultengine.compactionpolicy.class", FIFOCompactionPolicy.class.getName());
        desc.setConfiguration("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName());
        HColumnDescriptor colDesc = new HColumnDescriptor(this.family);
        desc.addFamily(colDesc);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
    }

    @Test
    public void testSanityCheckMinVersion() throws IOException {
        this.error.expect(DoNotRetryIOException.class);
        this.error.expectMessage("MIN_VERSION > 0 is not supported for FIFO compaction");
        TableName tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "-MinVersion"));
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setConfiguration("hbase.hstore.defaultengine.compactionpolicy.class", FIFOCompactionPolicy.class.getName());
        desc.setConfiguration("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName());
        HColumnDescriptor colDesc = new HColumnDescriptor(this.family);
        colDesc.setTimeToLive(1);
        colDesc.setMinVersions(1);
        desc.addFamily(colDesc);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
    }

    @Test
    public void testSanityCheckBlockingStoreFiles() throws IOException {
        this.error.expect(DoNotRetryIOException.class);
        this.error.expectMessage("blocking file count 'hbase.hstore.blockingStoreFiles'");
        this.error.expectMessage("is below recommended minimum of 1000");
        TableName tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "-BlockingStoreFiles"));
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setConfiguration("hbase.hstore.defaultengine.compactionpolicy.class", FIFOCompactionPolicy.class.getName());
        desc.setConfiguration("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName());
        desc.setConfiguration("hbase.hstore.blockingStoreFiles", "10");
        HColumnDescriptor colDesc = new HColumnDescriptor(this.family);
        colDesc.setTimeToLive(1);
        desc.addFamily(colDesc);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
    }

    @Test
    public void testFIFOCompactionPolicyExpiredEmptyHFiles() throws Exception {
        TableName tableName = TableName.valueOf((String)"testFIFOCompactionPolicyExpiredEmptyHFiles");
        HColumnDescriptor colDesc = new HColumnDescriptor(this.family).setTimeToLive(1);
        HTableDescriptor desc = new HTableDescriptor(tableName).setValue("hbase.hstore.defaultengine.compactionpolicy.class", FIFOCompactionPolicy.class.getName()).setValue("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName()).addFamily(colDesc);
        HTable table = TEST_UTIL.createTable(desc, (byte[][])null);
        long ts = System.currentTimeMillis() - 10000L;
        Put put = new Put(Bytes.toBytes((String)"row1")).addColumn(this.family, this.qualifier, ts, Bytes.toBytes((String)"value0"));
        table.put(put);
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        put = new Put(Bytes.toBytes((String)"row2")).addColumn(this.family, this.qualifier, ts, Bytes.toBytes((String)"value1"));
        table.put(put);
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        final Store store = (Store)Preconditions.checkNotNull((Object)this.getStoreWithName(tableName));
        Assert.assertEquals((long)2L, (long)store.getStorefilesCount());
        TEST_UTIL.getHBaseAdmin().majorCompact(tableName);
        int testWaitTimeoutMs = 20000;
        TEST_UTIL.waitFor(20000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() {
                return store.getStorefilesCount() == 1;
            }
        });
        StoreFile sf = (StoreFile)Preconditions.checkNotNull(store.getStorefiles().iterator().next());
        Assert.assertEquals((long)0L, (long)sf.getReader().getEntries());
        put = new Put(Bytes.toBytes((String)"row3")).addColumn(this.family, this.qualifier, ts, Bytes.toBytes((String)"value1"));
        table.put(put);
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        Assert.assertEquals((long)2L, (long)store.getStorefilesCount());
        TEST_UTIL.getHBaseAdmin().majorCompact(tableName);
        TEST_UTIL.waitFor(20000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() {
                return store.getStorefilesCount() == 1;
            }
        });
        sf = (StoreFile)Preconditions.checkNotNull(store.getStorefiles().iterator().next());
        Assert.assertEquals((long)0L, (long)sf.getReader().getEntries());
    }
}

