/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.SWebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestFsDelegationToken {
    private UserProvider userProvider = (UserProvider)Mockito.mock(UserProvider.class);
    private User user = (User)Mockito.mock(User.class);
    private FsDelegationToken fsDelegationToken = new FsDelegationToken(this.userProvider, "Renewer");
    private Token hdfsToken = (Token)Mockito.mock(Token.class);
    private Token webhdfsToken = (Token)Mockito.mock(Token.class);
    private Token swebhdfsToken = (Token)Mockito.mock(Token.class);
    private WebHdfsFileSystem webHdfsFileSystem = (WebHdfsFileSystem)Mockito.mock(WebHdfsFileSystem.class);
    private WebHdfsFileSystem swebHdfsFileSystem = (WebHdfsFileSystem)Mockito.mock(SWebHdfsFileSystem.class);
    private FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);

    @Before
    public void setup() throws IOException, URISyntaxException {
        Mockito.when((Object)this.userProvider.getCurrent()).thenReturn((Object)this.user);
        Mockito.when((Object)this.userProvider.isHadoopSecurityEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystem.getCanonicalServiceName()).thenReturn((Object)"hdfs://");
        Mockito.when((Object)this.fileSystem.getUri()).thenReturn((Object)new URI("hdfs://someUri"));
        Mockito.when((Object)this.webHdfsFileSystem.getCanonicalServiceName()).thenReturn((Object)"webhdfs://");
        Mockito.when((Object)this.webHdfsFileSystem.getUri()).thenReturn((Object)new URI("webhdfs://someUri"));
        Mockito.when((Object)this.swebHdfsFileSystem.getCanonicalServiceName()).thenReturn((Object)"swebhdfs://");
        Mockito.when((Object)this.swebHdfsFileSystem.getUri()).thenReturn((Object)new URI("swebhdfs://someUri"));
        Mockito.when((Object)this.user.getToken(DelegationTokenIdentifier.HDFS_DELEGATION_KIND.toString(), this.fileSystem.getCanonicalServiceName())).thenReturn((Object)this.hdfsToken);
        Mockito.when((Object)this.user.getToken(WebHdfsConstants.WEBHDFS_TOKEN_KIND.toString(), this.webHdfsFileSystem.getCanonicalServiceName())).thenReturn((Object)this.webhdfsToken);
        Mockito.when((Object)this.user.getToken(WebHdfsConstants.SWEBHDFS_TOKEN_KIND.toString(), this.swebHdfsFileSystem.getCanonicalServiceName())).thenReturn((Object)this.swebhdfsToken);
        Mockito.when((Object)this.hdfsToken.getKind()).thenReturn((Object)new Text("HDFS_DELEGATION_TOKEN"));
        Mockito.when((Object)this.webhdfsToken.getKind()).thenReturn((Object)WebHdfsConstants.WEBHDFS_TOKEN_KIND);
        Mockito.when((Object)this.swebhdfsToken.getKind()).thenReturn((Object)WebHdfsConstants.SWEBHDFS_TOKEN_KIND);
    }

    @Test
    public void acquireDelegationToken_defaults_to_hdfsFileSystem() throws IOException {
        this.fsDelegationToken.acquireDelegationToken(this.fileSystem);
        Assert.assertEquals((Object)this.fsDelegationToken.getUserToken().getKind(), (Object)DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
    }

    @Test
    public void acquireDelegationToken_webhdfsFileSystem() throws IOException {
        this.fsDelegationToken.acquireDelegationToken((FileSystem)this.webHdfsFileSystem);
        Assert.assertEquals((Object)this.fsDelegationToken.getUserToken().getKind(), (Object)WebHdfsConstants.WEBHDFS_TOKEN_KIND);
    }

    @Test
    public void acquireDelegationToken_swebhdfsFileSystem() throws IOException {
        this.fsDelegationToken.acquireDelegationToken((FileSystem)this.swebHdfsFileSystem);
        Assert.assertEquals((Object)this.fsDelegationToken.getUserToken().getKind(), (Object)WebHdfsConstants.SWEBHDFS_TOKEN_KIND);
    }

    @Test(expected=NullPointerException.class)
    public void acquireDelegationTokenByTokenKind_rejects_null_token_kind() throws IOException {
        this.fsDelegationToken.acquireDelegationToken(null, this.fileSystem);
    }

    @Test
    public void acquireDelegationTokenByTokenKind_webhdfsFileSystem() throws IOException {
        this.fsDelegationToken.acquireDelegationToken(WebHdfsConstants.WEBHDFS_TOKEN_KIND.toString(), (FileSystem)this.webHdfsFileSystem);
        Assert.assertEquals((Object)this.fsDelegationToken.getUserToken().getKind(), (Object)WebHdfsConstants.WEBHDFS_TOKEN_KIND);
    }

    @Test
    public void acquireDelegationTokenByTokenKind_swebhdfsFileSystem() throws IOException {
        this.fsDelegationToken.acquireDelegationToken(WebHdfsConstants.SWEBHDFS_TOKEN_KIND.toString(), (FileSystem)this.swebHdfsFileSystem);
        Assert.assertEquals((Object)this.fsDelegationToken.getUserToken().getKind(), (Object)WebHdfsConstants.SWEBHDFS_TOKEN_KIND);
    }
}

