/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class WALLink
extends FileLink {
    public WALLink(Configuration conf, String serverName, String logName) throws IOException {
        this(FSUtils.getWALRootDir((Configuration)conf), serverName, logName);
    }

    public WALLink(Path walRootDir, String serverName, String logName) {
        Path oldLogDir = new Path(walRootDir, "oldWALs");
        Path logDir = new Path(new Path(walRootDir, "WALs"), serverName);
        this.setLocations(new Path(logDir, logName), new Path(oldLogDir, logName));
    }

    public WALLink(Path originPath, Path archivePath) {
        this.setLocations(originPath, archivePath);
    }
}

