/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.master.assignment.TestAssignmentManagerBase;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestAssignmentManager
extends TestAssignmentManagerBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAssignmentManager.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAssignmentManager.class);

    @Test
    public void testAssignWithGoodExec() throws Exception {
        this.collectAssignmentManagerMetrics();
        this.testAssign(new TestAssignmentManagerBase.GoodRsExecutor(this));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1000L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testAssignAndCrashBeforeResponse() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAssignAndCrashBeforeResponse");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.HangThenRSCrashExecutor(this));
        TransitRegionStateProcedure proc = this.createAssignProcedure(hri);
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)proc));
    }

    @Test
    public void testUnassignAndCrashBeforeResponse() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAssignAndCrashBeforeResponse");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.HangOnCloseThenRSCrashExecutor(this));
        for (int i = 0; i < 6; ++i) {
            TransitRegionStateProcedure assign = this.createAssignProcedure(hri);
            this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)assign));
            TransitRegionStateProcedure unassign = this.createUnassignProcedure(hri);
            this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)unassign));
        }
    }

    @Test
    public void testAssignSocketTimeout() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.SocketTimeoutRsExecutor(this, 20));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.createAssignProcedure(hri)));
        Assert.assertTrue((this.assignProcMetrics.getSubmittedCounter().getCount() > this.assignSubmittedCount ? 1 : 0) != 0);
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testAssignQueueFullOnce() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.CallQueueTooBigOnceRsExecutor(this));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.createAssignProcedure(hri)));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testTimeoutThenQueueFull() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.TimeoutThenCallQueueTooBigRsExecutor(this, 10));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.createAssignProcedure(hri)));
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.TimeoutThenCallQueueTooBigRsExecutor(this, 15));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.createUnassignProcedure(hri)));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.unassignSubmittedCount + 1L), (long)this.unassignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.unassignFailedCount, (long)this.unassignProcMetrics.getFailedCounter().getCount());
    }

    private void testAssign(TestAssignmentManagerBase.MockRSExecutor executor) throws Exception {
        this.testAssign(executor, 1000);
    }

    private void testAssign(TestAssignmentManagerBase.MockRSExecutor executor, int nRegions) throws Exception {
        this.rsDispatcher.setMockRsExecutor(executor);
        TransitRegionStateProcedure[] assignments = new TransitRegionStateProcedure[nRegions];
        long st = EnvironmentEdgeManager.currentTime();
        this.bulkSubmit(assignments);
        for (int i = 0; i < assignments.length; ++i) {
            ProcedureTestingUtility.waitProcedure(this.master.getMasterProcedureExecutor(), (Procedure)assignments[i]);
            Assert.assertTrue((String)assignments[i].toString(), (boolean)assignments[i].isSuccess());
        }
        long et = EnvironmentEdgeManager.currentTime();
        float sec = (float)(et - st) / 1000.0f;
        LOG.info(String.format("[T] Assigning %dprocs in %s (%.2fproc/sec)", assignments.length, StringUtils.humanTimeDiff((long)(et - st)), Float.valueOf((float)assignments.length / sec)));
    }

    @Test
    public void testAssignAnAssignedRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAssignAnAssignedRegion");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor(this));
        Future<byte[]> futureA = this.submitProcedure((Procedure<MasterProcedureEnv>)this.createAssignProcedure(hri));
        this.waitOnFuture(futureA);
        this.am.getRegionStates().isRegionInState(hri, new RegionState.State[]{RegionState.State.OPEN});
        Future<byte[]> futureB = this.submitProcedure((Procedure<MasterProcedureEnv>)this.createAssignProcedure(hri));
        this.waitOnFuture(futureB);
        this.am.getRegionStates().isRegionInState(hri, new RegionState.State[]{RegionState.State.OPEN});
        Assert.assertEquals((long)(this.assignSubmittedCount + 2L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testUnassignAnUnassignedRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)"testUnassignAnUnassignedRegion");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor(this));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.createAssignProcedure(hri)));
        Future<byte[]> futureA = this.submitProcedure((Procedure<MasterProcedureEnv>)this.createUnassignProcedure(hri));
        this.waitOnFuture(futureA);
        this.am.getRegionStates().isRegionInState(hri, new RegionState.State[]{RegionState.State.CLOSED});
        Future<byte[]> futureB = this.submitProcedure((Procedure<MasterProcedureEnv>)this.createUnassignProcedure(hri));
        this.waitOnFuture(futureB);
        this.am.getRegionStates().isRegionInState(hri, new RegionState.State[]{RegionState.State.CLOSED});
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.unassignSubmittedCount + 2L), (long)this.unassignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.unassignFailedCount, (long)this.unassignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testAssignMetaAndCrashBeforeResponse() throws Exception {
        this.tearDown();
        this.util = new HBaseTestingUtility();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.setupConfiguration(this.util.getConfiguration());
        this.master = new MockMasterServices(this.util.getConfiguration(), this.regionsToRegionServers);
        this.rsDispatcher = new TestAssignmentManagerBase.MockRSProcedureDispatcher(this, this.master);
        this.master.start(NSERVERS, this.rsDispatcher);
        this.am = this.master.getAssignmentManager();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.HangThenRSRestartExecutor(this));
        this.am.assign(RegionInfoBuilder.FIRST_META_REGIONINFO);
        Assert.assertEquals((Object)true, (Object)this.am.isMetaAssigned());
        this.am.wakeMetaLoadedEvent();
    }

    private void assertCloseThenOpen() {
        Assert.assertEquals((long)(this.closeSubmittedCount + 1L), (long)this.closeProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.closeFailedCount, (long)this.closeProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.openSubmittedCount + 1L), (long)this.openProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.openFailedCount, (long)this.openProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testMove() throws Exception {
        TableName tableName = TableName.valueOf((String)"testMove");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor(this));
        this.am.assign(hri);
        this.collectAssignmentManagerMetrics();
        this.am.move(hri);
        Assert.assertEquals((long)(this.moveSubmittedCount + 1L), (long)this.moveProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.moveFailedCount, (long)this.moveProcMetrics.getFailedCounter().getCount());
        this.assertCloseThenOpen();
    }

    @Test
    public void testReopen() throws Exception {
        TableName tableName = TableName.valueOf((String)"testReopen");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor(this));
        this.am.assign(hri);
        this.collectAssignmentManagerMetrics();
        TransitRegionStateProcedure proc = TransitRegionStateProcedure.reopen((MasterProcedureEnv)((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment()), (RegionInfo)hri);
        this.am.getRegionStates().getRegionStateNode(hri).setProcedure(proc);
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)proc));
        Assert.assertEquals((long)(this.reopenSubmittedCount + 1L), (long)this.reopenProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.reopenFailedCount, (long)this.reopenProcMetrics.getFailedCounter().getCount());
        this.assertCloseThenOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRegionFromMetaAfterRegionManuallyAdded() throws Exception {
        try {
            this.util.startMiniCluster();
            AssignmentManager am = this.util.getHBaseCluster().getMaster().getAssignmentManager();
            TableName tableName = TableName.valueOf((String)"testLoadRegionFromMetaAfterRegionManuallyAdded");
            this.util.createTable(tableName, "f");
            RegionInfo hri = this.createRegionInfo(tableName, 1L);
            Assert.assertNull((String)"RegionInfo was just instantiated by the test, but shouldn't be in AM regionStates yet.", (Object)am.getRegionStates().getRegionState(hri));
            MetaTableAccessor.addRegionsToMeta((Connection)this.util.getConnection(), Collections.singletonList(hri), (int)1);
            Assert.assertNull((String)"RegionInfo was manually added in META, but shouldn't be in AM regionStates yet.", (Object)am.getRegionStates().getRegionState(hri));
            hri = am.loadRegionFromMeta(hri.getEncodedName());
            Assert.assertEquals((Object)hri.getEncodedName(), (Object)am.getRegionStates().getRegionState(hri).getRegion().getEncodedName());
        }
        finally {
            this.util.killMiniHBaseCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRegionFromMetaRegionNotInMeta() throws Exception {
        try {
            this.util.startMiniCluster();
            AssignmentManager am = this.util.getHBaseCluster().getMaster().getAssignmentManager();
            TableName tableName = TableName.valueOf((String)"testLoadRegionFromMetaRegionNotInMeta");
            this.util.createTable(tableName, "f");
            RegionInfo hri = this.createRegionInfo(tableName, 1L);
            Assert.assertNull((String)"RegionInfo was just instantiated by the test, but shouldn't be in AM regionStates yet.", (Object)am.getRegionStates().getRegionState(hri));
            Assert.assertNull((String)"RegionInfo was never added in META, should had returned null.", (Object)am.loadRegionFromMeta(hri.getEncodedName()));
        }
        finally {
            this.util.killMiniHBaseCluster();
        }
    }
}

