/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReader;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryFilterRetryableException;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStreamTestBase;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class TestBasicWALEntryStream
extends WALEntryStreamTestBase {
    @Before
    public void setUp() throws Exception {
        this.initWAL();
    }

    @Test
    public void testAppendsWithRolls() throws Exception {
        long oldPos;
        WAL.Entry entry;
        this.appendToLogAndSync();
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");){
            Assert.assertTrue((boolean)entryStream.hasNext());
            entry = entryStream.peek();
            Assert.assertSame((Object)entry, (Object)entryStream.next());
            Assert.assertNotNull((Object)entry);
            Assert.assertFalse((boolean)entryStream.hasNext());
            Assert.assertNull((Object)entryStream.peek());
            Assert.assertNull((Object)entryStream.next());
            oldPos = entryStream.getPosition();
        }
        this.appendToLogAndSync();
        entryStream = new WALEntryStreamTestBase.WALEntryStreamWithRetries(this.logQueue, CONF, oldPos, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");
        var4_2 = null;
        try {
            entry = entryStream.next();
            Assert.assertNotEquals((long)oldPos, (long)entryStream.getPosition());
            Assert.assertNotNull((Object)entry);
            oldPos = entryStream.getPosition();
        }
        catch (Throwable entry2) {
            var4_2 = entry2;
            throw entry2;
        }
        finally {
            if (entryStream != null) {
                if (var4_2 != null) {
                    try {
                        entryStream.close();
                    }
                    catch (Throwable entry2) {
                        var4_2.addSuppressed(entry2);
                    }
                } else {
                    entryStream.close();
                }
            }
        }
        this.appendToLogAndSync();
        this.log.rollWriter();
        this.appendToLogAndSync();
        entryStream = new WALEntryStreamTestBase.WALEntryStreamWithRetries(this.logQueue, CONF, oldPos, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");
        var4_2 = null;
        try {
            entry = entryStream.next();
            Assert.assertNotEquals((long)oldPos, (long)entryStream.getPosition());
            Assert.assertNotNull((Object)entry);
            entry = entryStream.next();
            Assert.assertNotEquals((long)oldPos, (long)entryStream.getPosition());
            Assert.assertNotNull((Object)entry);
            Assert.assertFalse((boolean)entryStream.hasNext());
            oldPos = entryStream.getPosition();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (entryStream != null) {
                if (var4_2 != null) {
                    try {
                        entryStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    entryStream.close();
                }
            }
        }
    }

    @Test
    public void testLogrollWhileStreaming() throws Exception {
        this.appendToLog("1");
        this.appendToLog("2");
        try (WALEntryStreamTestBase.WALEntryStreamWithRetries entryStream = new WALEntryStreamTestBase.WALEntryStreamWithRetries(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");){
            Assert.assertEquals((Object)"1", (Object)this.getRow(entryStream.next()));
            this.appendToLog("3");
            this.log.rollWriter();
            this.appendToLog("4");
            Assert.assertEquals((Object)"2", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((long)2L, (long)this.getQueue().size());
            Assert.assertEquals((Object)"3", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((Object)"4", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((long)1L, (long)this.getQueue().size());
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
    }

    @Test
    public void testNewEntriesWhileStreaming() throws Exception {
        this.appendToLog("1");
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            this.appendToLog("2");
            this.appendToLog("3");
            Assert.assertFalse((boolean)entryStream.hasNext());
            entryStream.reset();
            Assert.assertEquals((Object)"2", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((Object)"3", (Object)this.getRow(entryStream.next()));
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
    }

    @Test
    public void testResumeStreamingFromPosition() throws Exception {
        long lastPosition = 0L;
        this.appendToLog("1");
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            this.appendToLog("2");
            this.appendToLog("3");
            lastPosition = entryStream.getPosition();
        }
        entryStream = new WALEntryStream(this.logQueue, CONF, lastPosition, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");
        var4_3 = null;
        try {
            Assert.assertEquals((Object)"2", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((Object)"3", (Object)this.getRow(entryStream.next()));
            Assert.assertFalse((boolean)entryStream.hasNext());
            Assert.assertEquals((long)1L, (long)this.getQueue().size());
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (entryStream != null) {
                if (var4_3 != null) {
                    try {
                        entryStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    entryStream.close();
                }
            }
        }
    }

    @Test
    public void testPosition() throws Exception {
        long lastPosition = 0L;
        this.appendEntriesToLogAndSync(3);
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, lastPosition, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            lastPosition = entryStream.getPosition();
        }
        entryStream = new WALEntryStream(this.logQueue, CONF, lastPosition, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");
        var4_3 = null;
        try {
            Assert.assertNotNull((Object)entryStream.next());
            Assert.assertNotNull((Object)entryStream.next());
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (entryStream != null) {
                if (var4_3 != null) {
                    try {
                        entryStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    entryStream.close();
                }
            }
        }
    }

    @Test
    public void testEmptyStream() throws Exception {
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");){
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
    }

    @Test
    public void testWALKeySerialization() throws Exception {
        HashMap<String, byte[]> attributes = new HashMap<String, byte[]>();
        attributes.put("foo", Bytes.toBytes((String)"foo-value"));
        attributes.put("bar", Bytes.toBytes((String)"bar-value"));
        WALKeyImpl key = new WALKeyImpl(info.getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), new ArrayList(), 0L, 0L, this.mvcc, scopes, attributes);
        Assert.assertEquals(attributes, (Object)key.getExtendedAttributes());
        WALProtos.WALKey.Builder builder = key.getBuilder(WALCellCodec.getNoneCompressor());
        WALProtos.WALKey serializedKey = builder.build();
        WALKeyImpl deserializedKey = new WALKeyImpl();
        deserializedKey.readFieldsFromPb(serializedKey, WALCellCodec.getNoneUncompressor());
        Assert.assertEquals((Object)key, (Object)deserializedKey);
        Assert.assertEquals(key.getExtendedAttributes().keySet(), deserializedKey.getExtendedAttributes().keySet());
        for (Map.Entry entry : deserializedKey.getExtendedAttributes().entrySet()) {
            Assert.assertArrayEquals((byte[])key.getExtendedAttribute((String)entry.getKey()), (byte[])((byte[])entry.getValue()));
        }
        Assert.assertEquals((Object)key.getReplicationScopes(), (Object)deserializedKey.getReplicationScopes());
    }

    private ReplicationSource mockReplicationSource(boolean recovered, Configuration conf) {
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        Mockito.when((Object)mockSourceManager.getTotalBufferLimit()).thenReturn((Object)0x10000000L);
        Server mockServer = (Server)Mockito.mock(Server.class);
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)source.getSourceManager()).thenReturn((Object)mockSourceManager);
        Mockito.when((Object)source.getSourceMetrics()).thenReturn((Object)new MetricsSource("1"));
        Mockito.when((Object)source.getWALFileLengthProvider()).thenReturn((Object)this.log);
        Mockito.when((Object)source.getServer()).thenReturn((Object)mockServer);
        Mockito.when((Object)source.isRecovered()).thenReturn((Object)recovered);
        MetricsReplicationGlobalSourceSource globalMetrics = (MetricsReplicationGlobalSourceSource)Mockito.mock(MetricsReplicationGlobalSourceSource.class);
        Mockito.when((Object)mockSourceManager.getGlobalMetrics()).thenReturn((Object)globalMetrics);
        return source;
    }

    private ReplicationSourceWALReader createReader(boolean recovered, Configuration conf) {
        ReplicationSource source = this.mockReplicationSource(recovered, conf);
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        ReplicationSourceWALReader reader = new ReplicationSourceWALReader(fs, conf, this.logQueue, 0L, this.getDummyFilter(), source, "fake-wal-group-id");
        reader.start();
        return reader;
    }

    private ReplicationSourceWALReader createReaderWithBadReplicationFilter(int numFailures, Configuration conf) {
        ReplicationSource source = this.mockReplicationSource(false, conf);
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        ReplicationSourceWALReader reader = new ReplicationSourceWALReader(fs, conf, this.logQueue, 0L, this.getIntermittentFailingFilter(numFailures), source, "fake-wal-group-id");
        reader.start();
        return reader;
    }

    @Test
    public void testReplicationSourceWALReader() throws Exception {
        long position;
        this.appendEntriesToLogAndSync(3);
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            entryStream.next();
            entryStream.next();
            position = entryStream.getPosition();
        }
        Path walPath = this.getQueue().peek();
        ReplicationSourceWALReader reader = this.createReader(false, CONF);
        WALEntryBatch entryBatch = reader.take();
        Assert.assertNotNull((Object)entryBatch);
        Assert.assertEquals((long)3L, (long)entryBatch.getWalEntries().size());
        Assert.assertEquals((long)position, (long)entryBatch.getLastWalPosition());
        Assert.assertEquals((Object)walPath, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)3L, (long)entryBatch.getNbRowKeys());
        this.appendToLog("foo");
        entryBatch = reader.take();
        Assert.assertEquals((long)1L, (long)entryBatch.getNbEntries());
        Assert.assertEquals((Object)"foo", (Object)this.getRow((WAL.Entry)entryBatch.getWalEntries().get(0)));
    }

    @Test
    public void testReplicationSourceWALReaderWithFailingFilter() throws Exception {
        long position;
        this.appendEntriesToLogAndSync(3);
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            entryStream.next();
            entryStream.next();
            position = entryStream.getPosition();
        }
        Path walPath = this.getQueue().peek();
        int numFailuresInFilter = 5;
        ReplicationSourceWALReader reader = this.createReaderWithBadReplicationFilter(numFailuresInFilter, CONF);
        WALEntryBatch entryBatch = reader.take();
        Assert.assertEquals((long)numFailuresInFilter, (long)FailingWALEntryFilter.numFailures());
        Assert.assertNotNull((Object)entryBatch);
        Assert.assertEquals((long)3L, (long)entryBatch.getWalEntries().size());
        Assert.assertEquals((long)position, (long)entryBatch.getLastWalPosition());
        Assert.assertEquals((Object)walPath, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)3L, (long)entryBatch.getNbRowKeys());
    }

    @Test
    public void testReplicationSourceWALReaderRecovered() throws Exception {
        this.appendEntriesToLogAndSync(10);
        Path walPath = this.getQueue().peek();
        this.log.rollWriter();
        this.appendEntriesToLogAndSync(5);
        this.log.shutdown();
        Configuration conf = new Configuration(CONF);
        conf.setInt("replication.source.nb.capacity", 10);
        ReplicationSourceWALReader reader = this.createReader(true, conf);
        WALEntryBatch batch = reader.take();
        Assert.assertEquals((Object)walPath, (Object)batch.getLastWalPath());
        Assert.assertEquals((long)10L, (long)batch.getNbEntries());
        Assert.assertFalse((boolean)batch.isEndOfFile());
        batch = reader.take();
        Assert.assertEquals((Object)walPath, (Object)batch.getLastWalPath());
        Assert.assertEquals((long)0L, (long)batch.getNbEntries());
        Assert.assertTrue((boolean)batch.isEndOfFile());
        walPath = this.getQueue().peek();
        batch = reader.take();
        Assert.assertEquals((Object)walPath, (Object)batch.getLastWalPath());
        Assert.assertEquals((long)5L, (long)batch.getNbEntries());
        Assert.assertTrue((boolean)batch.isEndOfFile());
        Assert.assertSame((Object)WALEntryBatch.NO_MORE_DATA, (Object)reader.take());
    }

    @Test
    public void testReplicationSourceWALReaderWrongPosition() throws Exception {
        this.appendEntriesToLogAndSync(1);
        final Path walPath = this.getQueue().peek();
        this.log.rollWriter();
        this.appendEntriesToLogAndSync(20);
        TEST_UTIL.waitFor(5000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return WALEntryStreamTestBase.fs.getFileStatus(walPath).getLen() > 0L && ((AbstractFSWAL)TestBasicWALEntryStream.this.log).getInflightWALCloseCount() == 0;
            }

            public String explainFailure() throws Exception {
                return walPath + " has not been closed yet";
            }
        });
        ReplicationSourceWALReader reader = this.createReader(false, CONF);
        WALEntryBatch entryBatch = reader.take();
        Assert.assertEquals((Object)walPath, (Object)entryBatch.getLastWalPath());
        long walLength = fs.getFileStatus(walPath).getLen();
        Assert.assertTrue((String)("Position " + entryBatch.getLastWalPosition() + " is out of range, file length is " + walLength), (entryBatch.getLastWalPosition() <= walLength ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)entryBatch.getNbEntries());
        Assert.assertTrue((boolean)entryBatch.isEndOfFile());
        Path walPath2 = this.getQueue().peek();
        entryBatch = reader.take();
        Assert.assertEquals((Object)walPath2, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)20L, (long)entryBatch.getNbEntries());
        Assert.assertFalse((boolean)entryBatch.isEndOfFile());
        this.log.rollWriter();
        this.appendEntriesToLogAndSync(10);
        entryBatch = reader.take();
        Assert.assertEquals((Object)walPath2, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)0L, (long)entryBatch.getNbEntries());
        Assert.assertTrue((boolean)entryBatch.isEndOfFile());
        Path walPath3 = this.getQueue().peek();
        entryBatch = reader.take();
        Assert.assertEquals((Object)walPath3, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)10L, (long)entryBatch.getNbEntries());
        Assert.assertFalse((boolean)entryBatch.isEndOfFile());
    }

    @Test
    public void testReplicationSourceWALReaderDisabled() throws IOException, InterruptedException, ExecutionException {
        long position;
        this.appendEntriesToLogAndSync(3);
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            entryStream.next();
            entryStream.next();
            position = entryStream.getPosition();
        }
        Path walPath = this.getQueue().peek();
        ReplicationSource source = this.mockReplicationSource(false, CONF);
        AtomicInteger invokeCount = new AtomicInteger(0);
        AtomicBoolean enabled = new AtomicBoolean(false);
        Mockito.when((Object)source.isPeerEnabled()).then(i -> {
            invokeCount.incrementAndGet();
            return enabled.get();
        });
        ReplicationSourceWALReader reader = new ReplicationSourceWALReader(fs, CONF, this.logQueue, 0L, this.getDummyFilter(), source, "fake-wal-group-id");
        reader.start();
        Future future = ForkJoinPool.commonPool().submit(() -> reader.take());
        TEST_UTIL.waitFor(30000L, () -> invokeCount.get() >= 5);
        Assert.assertFalse((boolean)future.isDone());
        enabled.set(true);
        WALEntryBatch entryBatch = (WALEntryBatch)future.get();
        Assert.assertNotNull((Object)entryBatch);
        Assert.assertEquals((long)3L, (long)entryBatch.getWalEntries().size());
        Assert.assertEquals((long)position, (long)entryBatch.getLastWalPosition());
        Assert.assertEquals((Object)walPath, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)3L, (long)entryBatch.getNbRowKeys());
    }

    private String getRow(WAL.Entry entry) {
        Cell cell = (Cell)entry.getEdit().getCells().get(0);
        return Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength());
    }

    private void appendToLog(String key) throws IOException {
        long txid = this.log.appendData(info, new WALKeyImpl(info.getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), this.mvcc, scopes), this.getWALEdit(key));
        this.log.sync(txid);
    }

    private void appendEntriesToLogAndSync(int count) throws IOException {
        long txid = -1L;
        for (int i = 0; i < count; ++i) {
            txid = this.appendToLog(1);
        }
        this.log.sync(txid);
    }

    private WALEdit getWALEdit(String row) {
        WALEdit edit = new WALEdit();
        edit.add((Cell)new KeyValue(Bytes.toBytes((String)row), family, qualifier, EnvironmentEdgeManager.currentTime(), qualifier));
        return edit;
    }

    private WALEntryFilter getDummyFilter() {
        return new WALEntryFilter(){

            public WAL.Entry filter(WAL.Entry entry) {
                return entry;
            }
        };
    }

    private WALEntryFilter getIntermittentFailingFilter(int numFailuresInFilter) {
        return new FailingWALEntryFilter(numFailuresInFilter);
    }

    @Test
    public void testReadBeyondCommittedLength() throws IOException, InterruptedException {
        this.appendToLog("1");
        this.appendToLog("2");
        long size = this.log.getLogFileSizeIfBeingWritten(this.getQueue().peek()).getAsLong();
        AtomicLong fileLength = new AtomicLong(size - 1L);
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, 0L, p -> OptionalLong.of(fileLength.get()), null, new MetricsSource("1"), "fake-wal-group-id");){
            Assert.assertTrue((boolean)entryStream.hasNext());
            Assert.assertNotNull((Object)entryStream.next());
            Assert.assertFalse((boolean)entryStream.hasNext());
            Thread.sleep(1000L);
            entryStream.reset();
            Assert.assertFalse((boolean)entryStream.hasNext());
            fileLength.set(size);
            entryStream.reset();
            Assert.assertTrue((boolean)entryStream.hasNext());
            Assert.assertNotNull((Object)entryStream.next());
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
    }

    @Test
    public void testEOFExceptionForRecoveredQueue() throws Exception {
        Path emptyLog = new Path("emptyLog");
        FSDataOutputStream fsdos = fs.create(emptyLog);
        fsdos.close();
        Assert.assertEquals((long)0L, (long)fs.getFileStatus(emptyLog).getLen());
        Configuration conf = new Configuration(CONF);
        conf.setInt("replication.source.maxretriesmultiplier", 1);
        conf.setBoolean("replication.source.eof.autorecovery", true);
        conf.setInt("replication.source.nb.batches", 10);
        ReplicationSource source = this.mockReplicationSource(true, conf);
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        MetricsSource metrics = (MetricsSource)Mockito.mock(MetricsSource.class);
        ((MetricsSource)Mockito.doNothing().when((Object)metrics)).incrSizeOfLogQueue();
        ((MetricsSource)Mockito.doNothing().when((Object)metrics)).decrSizeOfLogQueue();
        ReplicationSourceLogQueue localLogQueue = new ReplicationSourceLogQueue(conf, metrics, source);
        localLogQueue.enqueueLog(emptyLog, "fake-wal-group-id");
        ReplicationSourceWALReader reader = new ReplicationSourceWALReader(fs, conf, localLogQueue, 0L, this.getDummyFilter(), source, "fake-wal-group-id");
        reader.start();
        reader.join();
        Assert.assertEquals((long)0L, (long)localLogQueue.getQueueSize("fake-wal-group-id"));
    }

    @Test
    public void testEOFExceptionForRecoveredQueueWithMultipleLogs() throws Exception {
        Configuration conf = new Configuration(CONF);
        MetricsSource metrics = (MetricsSource)Mockito.mock(MetricsSource.class);
        ReplicationSource source = this.mockReplicationSource(true, conf);
        ReplicationSourceLogQueue localLogQueue = new ReplicationSourceLogQueue(conf, metrics, source);
        Path emptyLog = new Path(fs.getHomeDirectory(), "log.2");
        FSDataOutputStream fsdos = fs.create(emptyLog);
        fsdos.close();
        Assert.assertEquals((long)0L, (long)fs.getFileStatus(emptyLog).getLen());
        localLogQueue.enqueueLog(emptyLog, "fake-wal-group-id");
        Path log1 = new Path(fs.getHomeDirectory(), "log.1");
        WALProvider.Writer writer1 = WALFactory.createWALWriter((FileSystem)fs, (Path)log1, (Configuration)TEST_UTIL.getConfiguration());
        this.appendEntries(writer1, 3);
        localLogQueue.enqueueLog(log1, "fake-wal-group-id");
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        Mockito.when((Object)mockSourceManager.getOldSources()).thenReturn(new ArrayList<ReplicationSourceInterface>(Arrays.asList(source)));
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        conf.setInt("replication.source.maxretriesmultiplier", 1);
        conf.setBoolean("replication.source.eof.autorecovery", true);
        conf.setInt("replication.source.nb.batches", 10);
        ReplicationSourceWALReader reader = new ReplicationSourceWALReader(fs, conf, localLogQueue, 0L, this.getDummyFilter(), source, "fake-wal-group-id");
        Assert.assertEquals((String)"Initial log queue size is not correct", (long)2L, (long)localLogQueue.getQueueSize("fake-wal-group-id"));
        reader.start();
        reader.join();
        Assert.assertEquals((long)0L, (long)localLogQueue.getQueueSize("fake-wal-group-id"));
        Assert.assertEquals((String)"Log queue should be empty", (long)0L, (long)localLogQueue.getQueueSize("fake-wal-group-id"));
    }

    private PriorityBlockingQueue<Path> getQueue() {
        return this.logQueue.getQueue("fake-wal-group-id");
    }

    private void appendEntries(WALProvider.Writer writer, int numEntries) throws IOException {
        for (int i = 0; i < numEntries; ++i) {
            byte[] b = Bytes.toBytes((String)Integer.toString(i));
            KeyValue kv = new KeyValue(b, b, b);
            WALEdit edit = new WALEdit();
            edit.add((Cell)kv);
            WALKeyImpl key = new WALKeyImpl(b, TableName.valueOf((byte[])b), 0L, 0L, HConstants.DEFAULT_CLUSTER_ID);
            TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            scopes.put(b, 1);
            writer.append(new WAL.Entry(key, edit));
            writer.sync(false);
        }
        writer.close();
    }

    @Test
    public void testSizeOfLogQueue() throws Exception {
        Assert.assertEquals((long)1L, (long)this.logQueue.getMetrics().getSizeOfLogQueue());
        this.appendToLogAndSync();
        this.log.rollWriter();
        Assert.assertEquals((long)2L, (long)this.logQueue.getMetrics().getSizeOfLogQueue());
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, this.logQueue.getMetrics(), "fake-wal-group-id");){
            Assert.assertTrue((boolean)entryStream.hasNext());
            WAL.Entry entry = entryStream.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
        Assert.assertEquals((long)1L, (long)this.logQueue.getMetrics().getSizeOfLogQueue());
    }

    @Test
    public void testCleanClosedWALs() throws Exception {
        try (WALEntryStreamTestBase.WALEntryStreamWithRetries entryStream = new WALEntryStreamTestBase.WALEntryStreamWithRetries(this.logQueue, CONF, 0L, (WALFileLengthProvider)this.log, null, this.logQueue.getMetrics(), "fake-wal-group-id");){
            Assert.assertEquals((long)0L, (long)this.logQueue.getMetrics().getUncleanlyClosedWALs());
            this.appendToLogAndSync();
            Assert.assertNotNull((Object)entryStream.next());
            this.log.rollWriter();
            this.appendToLogAndSync();
            Assert.assertNotNull((Object)entryStream.next());
            Assert.assertEquals((long)0L, (long)this.logQueue.getMetrics().getUncleanlyClosedWALs());
        }
    }

    @Test
    public void testEOFExceptionInOldWALsDirectory() throws Exception {
        Assert.assertEquals((long)1L, (long)this.logQueue.getQueueSize("fake-wal-group-id"));
        AbstractFSWAL abstractWAL = (AbstractFSWAL)this.log;
        Path emptyLogFile = abstractWAL.getCurrentFileName();
        this.log.rollWriter(true);
        Waiter.waitFor((Configuration)CONF, (long)5000L, () -> abstractWAL.getInflightWALCloseCount() == 0);
        Assert.assertEquals((long)2L, (long)this.logQueue.getQueueSize("fake-wal-group-id"));
        Path archivePath = AbstractFSWALProvider.findArchivedLog((Path)emptyLogFile, (Configuration)CONF);
        Assert.assertNotNull((Object)archivePath);
        Assert.assertTrue((boolean)fs.exists(archivePath));
        fs.truncate(archivePath, 0L);
        Assert.assertEquals((long)0L, (long)fs.getFileStatus(archivePath).getLen());
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        Configuration localConf = new Configuration(CONF);
        localConf.setInt("replication.source.maxretriesmultiplier", 1);
        localConf.setBoolean("replication.source.eof.autorecovery", true);
        this.createReader(false, localConf);
        Waiter.waitFor((Configuration)localConf, (long)10000L, () -> this.logQueue.getQueueSize("fake-wal-group-id") == 1);
    }

    public static class FailingWALEntryFilter
    implements WALEntryFilter {
        private int numFailures = 0;
        private static int countFailures = 0;

        public FailingWALEntryFilter(int numFailuresInFilter) {
            this.numFailures = numFailuresInFilter;
        }

        public WAL.Entry filter(WAL.Entry entry) {
            if (countFailures == this.numFailures) {
                return entry;
            }
            ++countFailures;
            throw new WALEntryFilterRetryableException("failing filter");
        }

        public static int numFailures() {
            return countFailures;
        }
    }
}

