/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.BoundedDelegatingInputStream;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
public class CompressionContext {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionContext.class);
    public static final String ENABLE_WAL_TAGS_COMPRESSION = "hbase.regionserver.wal.tags.enablecompression";
    public static final String ENABLE_WAL_VALUE_COMPRESSION = "hbase.regionserver.wal.value.enablecompression";
    public static final String WAL_VALUE_COMPRESSION_TYPE = "hbase.regionserver.wal.value.compression.type";
    private final Map<DictionaryIndex, Dictionary> dictionaries = new EnumMap<DictionaryIndex, Dictionary>(DictionaryIndex.class);
    TagCompressionContext tagCompressionContext = null;
    ValueCompressor valueCompressor = null;

    public CompressionContext(Class<? extends Dictionary> dictType, boolean recoveredEdits, boolean hasTagCompression, boolean hasValueCompression, Compression.Algorithm valueCompressionType) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        Constructor<? extends Dictionary> dictConstructor = dictType.getConstructor(new Class[0]);
        for (DictionaryIndex dictionaryIndex : DictionaryIndex.values()) {
            Dictionary newDictionary = dictConstructor.newInstance(new Object[0]);
            this.dictionaries.put(dictionaryIndex, newDictionary);
        }
        if (recoveredEdits) {
            this.getDictionary(DictionaryIndex.REGION).init(1);
            this.getDictionary(DictionaryIndex.TABLE).init(1);
        } else {
            this.getDictionary(DictionaryIndex.REGION).init(Short.MAX_VALUE);
            this.getDictionary(DictionaryIndex.TABLE).init(Short.MAX_VALUE);
        }
        this.getDictionary(DictionaryIndex.ROW).init(Short.MAX_VALUE);
        this.getDictionary(DictionaryIndex.FAMILY).init(127);
        this.getDictionary(DictionaryIndex.QUALIFIER).init(127);
        if (hasTagCompression) {
            this.tagCompressionContext = new TagCompressionContext(dictType, Short.MAX_VALUE);
        }
        if (hasValueCompression && valueCompressionType != null) {
            this.valueCompressor = new ValueCompressor(valueCompressionType);
        }
    }

    public CompressionContext(Class<? extends Dictionary> dictType, boolean recoveredEdits, boolean hasTagCompression) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        this(dictType, recoveredEdits, hasTagCompression, false, null);
    }

    public boolean hasTagCompression() {
        return this.tagCompressionContext != null;
    }

    public boolean hasValueCompression() {
        return this.valueCompressor != null;
    }

    public Dictionary getDictionary(Enum dictIndex) {
        return this.dictionaries.get(dictIndex);
    }

    public ValueCompressor getValueCompressor() {
        return this.valueCompressor;
    }

    void clear() {
        for (Dictionary dictionary : this.dictionaries.values()) {
            dictionary.clear();
        }
        if (this.tagCompressionContext != null) {
            this.tagCompressionContext.clear();
        }
        if (this.valueCompressor != null) {
            this.valueCompressor.clear();
        }
    }

    public static Compression.Algorithm getValueCompressionAlgorithm(Configuration conf) {
        if (conf.getBoolean(ENABLE_WAL_VALUE_COMPRESSION, true)) {
            String compressionType = conf.get(WAL_VALUE_COMPRESSION_TYPE);
            if (compressionType != null) {
                return Compression.getCompressionAlgorithmByName((String)compressionType);
            }
            return Compression.Algorithm.GZ;
        }
        return Compression.Algorithm.NONE;
    }

    static class ValueCompressor {
        static final int IO_BUFFER_SIZE = 65536;
        private final Compression.Algorithm algorithm;
        private Compressor compressor;
        private Decompressor decompressor;
        private BoundedDelegatingInputStream lowerIn;
        private ByteArrayOutputStream lowerOut;
        private InputStream compressedIn;
        private OutputStream compressedOut;

        public ValueCompressor(Compression.Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        public Compression.Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public byte[] compress(byte[] valueArray, int valueOffset, int valueLength) throws IOException {
            if (this.compressedOut == null) {
                this.lowerOut = new ByteArrayOutputStream();
                if (this.compressor == null) {
                    this.compressor = this.algorithm.getCompressor();
                }
                this.compressedOut = this.algorithm.createCompressionStream((OutputStream)this.lowerOut, this.compressor, 65536);
            }
            this.compressedOut.write(valueArray, valueOffset, valueLength);
            this.compressedOut.flush();
            byte[] compressed = this.lowerOut.toByteArray();
            this.lowerOut.reset();
            return compressed;
        }

        public int decompress(InputStream in, int inLength, byte[] outArray, int outOffset, int outLength) throws IOException {
            if (this.compressedIn == null) {
                this.lowerIn = new BoundedDelegatingInputStream(in, (long)inLength);
                if (this.decompressor == null) {
                    this.decompressor = this.algorithm.getDecompressor();
                }
                this.compressedIn = this.algorithm.createDecompressionStream((InputStream)this.lowerIn, this.decompressor, 65536);
            } else {
                this.lowerIn.setDelegate(in, (long)inLength);
            }
            return this.compressedIn.read(outArray, outOffset, outLength);
        }

        public void clear() {
            if (this.compressedOut != null) {
                try {
                    this.compressedOut.close();
                }
                catch (IOException e) {
                    LOG.warn("Exception closing compressed output stream", (Throwable)e);
                }
            }
            this.compressedOut = null;
            if (this.lowerOut != null) {
                try {
                    this.lowerOut.close();
                }
                catch (IOException e) {
                    LOG.warn("Exception closing lower output stream", (Throwable)e);
                }
            }
            this.lowerOut = null;
            if (this.compressedIn != null) {
                try {
                    this.compressedIn.close();
                }
                catch (IOException e) {
                    LOG.warn("Exception closing compressed input stream", (Throwable)e);
                }
            }
            this.compressedIn = null;
            if (this.lowerIn != null) {
                try {
                    this.lowerIn.close();
                }
                catch (IOException e) {
                    LOG.warn("Exception closing lower input stream", (Throwable)e);
                }
            }
            this.lowerIn = null;
            if (this.compressor != null) {
                this.compressor.reset();
            }
            if (this.decompressor != null) {
                this.decompressor.reset();
            }
        }
    }

    public static enum DictionaryIndex {
        REGION,
        TABLE,
        FAMILY,
        QUALIFIER,
        ROW;

    }
}

