/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
public abstract class ReaderBase
implements AbstractFSWALProvider.Reader {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderBase.class);
    protected Configuration conf;
    protected FileSystem fs;
    protected Path path;
    protected long edit = 0L;
    protected long fileLength;
    protected CompressionContext compressionContext = null;
    protected boolean emptyCompressionContext = true;

    @Override
    public void init(FileSystem fs, Path path, Configuration conf, FSDataInputStream stream) throws IOException {
        this.conf = conf;
        this.path = path;
        this.fs = fs;
        this.fileLength = this.fs.getFileStatus(path).getLen();
        String cellCodecClsName = this.initReader(stream);
        boolean compression = this.hasCompression();
        if (compression) {
            try {
                if (this.compressionContext == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Initializing compression context for {}: isRecoveredEdits={}, hasTagCompression={}, hasValueCompression={}, valueCompressionType={}", new Object[]{path, CommonFSUtils.isRecoveredEdits((Path)path), this.hasTagCompression(), this.hasValueCompression(), this.getValueCompressionAlgorithm()});
                    }
                    this.compressionContext = new CompressionContext(LRUDictionary.class, CommonFSUtils.isRecoveredEdits((Path)path), this.hasTagCompression(), this.hasValueCompression(), this.getValueCompressionAlgorithm());
                } else {
                    this.compressionContext.clear();
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize CompressionContext", e);
            }
        }
        this.initAfterCompression(cellCodecClsName);
    }

    @Override
    public WAL.Entry next() throws IOException {
        return this.next(null);
    }

    @Override
    public WAL.Entry next(WAL.Entry reuse) throws IOException {
        WAL.Entry e = reuse;
        if (e == null) {
            e = new WAL.Entry();
        }
        boolean hasEntry = false;
        try {
            hasEntry = this.readNext(e);
        }
        catch (IllegalArgumentException iae) {
            TableName tableName = e.getKey().getTableName();
            if (tableName != null && tableName.equals((Object)TableName.OLD_ROOT_TABLE_NAME)) {
                LOG.info("Got an old ROOT edit, ignoring ");
                return this.next(e);
            }
            throw iae;
        }
        ++this.edit;
        if (this.compressionContext != null && this.emptyCompressionContext) {
            this.emptyCompressionContext = false;
        }
        return hasEntry ? e : null;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.compressionContext != null && this.emptyCompressionContext) {
            while (this.next() != null) {
                if (this.getPosition() != pos) continue;
                this.emptyCompressionContext = false;
                break;
            }
        }
        this.seekOnFs(pos);
    }

    protected abstract String initReader(FSDataInputStream var1) throws IOException;

    protected abstract void initAfterCompression() throws IOException;

    protected abstract void initAfterCompression(String var1) throws IOException;

    protected abstract boolean hasCompression();

    protected abstract boolean hasTagCompression();

    protected abstract boolean hasValueCompression();

    protected abstract Compression.Algorithm getValueCompressionAlgorithm();

    protected abstract boolean readNext(WAL.Entry var1) throws IOException;

    protected abstract void seekOnFs(long var1) throws IOException;
}

