/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.github.steveash.guavate.Guavate;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ErrorRecoveryIndexationTaskDTO;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;

public class ErrorRecoveryIndexationTask
implements Task {
    public static final TaskType PREVIOUS_FAILURES_INDEXING = TaskType.of((String)"error-recovery-indexation");
    private final ReIndexerPerformer reIndexerPerformer;
    private final ReprocessingContext reprocessingContext;
    private final ReIndexingExecutionFailures previousFailures;

    public ErrorRecoveryIndexationTask(ReIndexerPerformer reIndexerPerformer, ReIndexingExecutionFailures previousFailures) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.previousFailures = previousFailures;
        this.reprocessingContext = new ReprocessingContext();
    }

    public Task.Result run() {
        return this.reIndexerPerformer.reIndex(this.reprocessingContext, this.previousFailures);
    }

    public TaskType type() {
        return PREVIOUS_FAILURES_INDEXING;
    }

    public ReIndexingExecutionFailures getPreviousFailures() {
        return this.previousFailures;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(ReprocessingContextInformation.forErrorRecoveryIndexationTask(this.reprocessingContext));
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer, MailboxId.Factory mailboxIdFactory) {
            this.reIndexerPerformer = reIndexerPerformer;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        private List<ReIndexingExecutionFailures.ReIndexingFailure> failuresFromDTO(List<ErrorRecoveryIndexationTaskDTO.ReindexingFailureDTO> failureDTOs) {
            return (List)failureDTOs.stream().flatMap(dto -> dto.getUids().stream().map(uid -> new ReIndexingExecutionFailures.ReIndexingFailure(this.mailboxIdFactory.fromString(dto.getMailboxId()), MessageUid.of((long)uid)))).collect(Guavate.toImmutableList());
        }

        public ErrorRecoveryIndexationTask create(ErrorRecoveryIndexationTaskDTO dto) {
            return new ErrorRecoveryIndexationTask(this.reIndexerPerformer, new ReIndexingExecutionFailures(this.failuresFromDTO(dto.getPreviousFailures())));
        }
    }
}

