/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.mailbox.tools.indexer.ErrorRecoveryIndexationTask;

public class ErrorRecoveryIndexationTaskDTO
implements TaskDTO {
    private final String type;
    private final List<ReindexingFailureDTO> previousFailures;

    public static TaskDTOModule<ErrorRecoveryIndexationTask, ErrorRecoveryIndexationTaskDTO> module(ErrorRecoveryIndexationTask.Factory factory) {
        return (TaskDTOModule)DTOModule.forDomainObject(ErrorRecoveryIndexationTask.class).convertToDTO(ErrorRecoveryIndexationTaskDTO.class).toDomainObjectConverter(factory::create).toDTOConverter(ErrorRecoveryIndexationTaskDTO::of).typeName(ErrorRecoveryIndexationTask.PREVIOUS_FAILURES_INDEXING.asString()).withFactory(TaskDTOModule::new);
    }

    public static ErrorRecoveryIndexationTaskDTO of(ErrorRecoveryIndexationTask task, String type) {
        Multimap failuresByMailboxId = (Multimap)task.getPreviousFailures().failures().stream().collect(Guavate.toImmutableListMultimap(ReIndexingExecutionFailures.ReIndexingFailure::getMailboxId, Function.identity()));
        List failureDTOs = (List)failuresByMailboxId.asMap().entrySet().stream().map(ErrorRecoveryIndexationTaskDTO::failuresByMailboxToReindexingFailureDTO).collect(Guavate.toImmutableList());
        return new ErrorRecoveryIndexationTaskDTO(type, failureDTOs);
    }

    private static ReindexingFailureDTO failuresByMailboxToReindexingFailureDTO(Map.Entry<MailboxId, Collection<ReIndexingExecutionFailures.ReIndexingFailure>> entry) {
        List uids = (List)entry.getValue().stream().map(ReIndexingExecutionFailures.ReIndexingFailure::getUid).map(MessageUid::asLong).collect(Guavate.toImmutableList());
        return new ReindexingFailureDTO(entry.getKey().serialize(), uids);
    }

    private ErrorRecoveryIndexationTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="previousFailures") List<ReindexingFailureDTO> previousFailures) {
        this.type = type;
        this.previousFailures = previousFailures;
    }

    public String getType() {
        return this.type;
    }

    public List<ReindexingFailureDTO> getPreviousFailures() {
        return this.previousFailures;
    }

    public static class ReindexingFailureDTO {
        private final String mailboxId;
        private final List<Long> uids;

        private ReindexingFailureDTO(@JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="uids") List<Long> uids) {
            this.mailboxId = mailboxId;
            this.uids = uids;
        }

        public String getMailboxId() {
            return this.mailboxId;
        }

        public List<Long> getUids() {
            return this.uids;
        }
    }
}

