/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.List;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformationDTO;
import org.apache.mailbox.tools.indexer.SingleMailboxReindexingTask;

public class SingleMailboxReindexingTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final ReprocessingContextInformationDTO reprocessingContextInformationDTO;
    private final String mailboxId;

    public static AdditionalInformationDTOModule<SingleMailboxReindexingTask.AdditionalInformation, SingleMailboxReindexingTaskAdditionalInformationDTO> serializationModule(MailboxId.Factory factory) {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(SingleMailboxReindexingTask.AdditionalInformation.class).convertToDTO(SingleMailboxReindexingTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> new SingleMailboxReindexingTask.AdditionalInformation(factory.fromString(dto.getMailboxId()), dto.getSuccessfullyReprocessedMailCount(), dto.getFailedReprocessedMailCount(), ReprocessingContextInformationDTO.deserializeFailures(factory, dto.getFailures()), dto.getTimestamp())).toDTOConverter((details, type) -> new SingleMailboxReindexingTaskAdditionalInformationDTO(type, details.getMailboxId(), details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), ReprocessingContextInformationDTO.serializeFailures(details.failures()), details.timestamp())).typeName(SingleMailboxReindexingTask.MAILBOX_RE_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    @JsonCreator
    private SingleMailboxReindexingTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") List<ReprocessingContextInformationDTO.ReindexingFailureDTO> failures, @JsonProperty(value="timestamp") Instant timestamp) {
        this.mailboxId = mailboxId;
        this.reprocessingContextInformationDTO = new ReprocessingContextInformationDTO(type, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
    }

    public String getType() {
        return this.reprocessingContextInformationDTO.getType();
    }

    public Instant getTimestamp() {
        return this.reprocessingContextInformationDTO.getTimestamp();
    }

    public String getMailboxId() {
        return this.mailboxId;
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.reprocessingContextInformationDTO.getSuccessfullyReprocessedMailCount();
    }

    public int getFailedReprocessedMailCount() {
        return this.reprocessingContextInformationDTO.getFailedReprocessedMailCount();
    }

    public List<ReprocessingContextInformationDTO.ReindexingFailureDTO> getFailures() {
        return this.reprocessingContextInformationDTO.getFailures();
    }
}

