/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.core;

import com.fasterxml.jackson.core.JsonParseException;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.RequestLevelErrorType$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.routes.UnsupportedCapabilitiesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.runtime.ModuleSerializationProxy;

public final class ProblemDetails$
implements Serializable {
    public static final ProblemDetails$ MODULE$ = new ProblemDetails$();
    private static final Logger LOGGER = LoggerFactory.getLogger(ProblemDetails.class);

    public String $lessinit$greater$default$1() {
        return RequestLevelErrorType$.MODULE$.DEFAULT_ERROR_TYPE();
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Logger LOGGER() {
        return LOGGER;
    }

    public ProblemDetails forThrowable(Throwable throwable) {
        ProblemDetails problemDetails;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof IllegalArgumentException) {
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable2;
            problemDetails = this.notRequestProblem(new StringBuilder(104).append("The request was successfully parsed as JSON but did not match the type signature of the Request object: ").append(illegalArgumentException.getMessage()).toString());
        } else if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            this.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
            HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
            String x$2 = unauthorizedException.getMessage();
            String x$3 = this.apply$default$1();
            Option<String> x$4 = this.apply$default$3();
            problemDetails = new ProblemDetails(x$3, x$1, x$4, x$2);
        } else if (throwable2 instanceof JsonParseException) {
            JsonParseException jsonParseException = (JsonParseException)throwable2;
            problemDetails = this.notJSONProblem(new StringBuilder(97).append("The content type of the request was not application/json or the request did not parse as I-JSON: ").append(jsonParseException.getMessage()).toString());
        } else if (throwable2 instanceof UnsupportedCapabilitiesException) {
            UnsupportedCapabilitiesException unsupportedCapabilitiesException = (UnsupportedCapabilitiesException)throwable2;
            problemDetails = this.unknownCapabilityProblem(new StringBuilder(43).append("The request used unsupported capabilities: ").append(unsupportedCapabilitiesException.capabilities()).toString());
        } else {
            this.LOGGER().error("Unexpected error upon API request", throwable2);
            HttpResponseStatus x$5 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String x$6 = throwable2.getMessage();
            String x$7 = this.apply$default$1();
            Option<String> x$8 = this.apply$default$3();
            problemDetails = new ProblemDetails(x$7, x$5, x$8, x$6);
        }
        return problemDetails;
    }

    public ProblemDetails notRequestProblem(String message) {
        return new ProblemDetails(RequestLevelErrorType$.MODULE$.NOT_REQUEST(), HttpResponseStatus.BAD_REQUEST, (Option<String>)None$.MODULE$, message);
    }

    public ProblemDetails notJSONProblem(String message) {
        return new ProblemDetails(RequestLevelErrorType$.MODULE$.NOT_JSON(), HttpResponseStatus.BAD_REQUEST, (Option<String>)None$.MODULE$, message);
    }

    public ProblemDetails unknownCapabilityProblem(String message) {
        return new ProblemDetails(RequestLevelErrorType$.MODULE$.UNKNOWN_CAPABILITY(), HttpResponseStatus.BAD_REQUEST, (Option<String>)None$.MODULE$, message);
    }

    public ProblemDetails invalidResultReference(String message) {
        return new ProblemDetails(RequestLevelErrorType$.MODULE$.UNKNOWN_CAPABILITY(), HttpResponseStatus.BAD_REQUEST, (Option<String>)None$.MODULE$, message);
    }

    public ProblemDetails apply(String type, HttpResponseStatus status, Option<String> limit, String detail) {
        return new ProblemDetails(type, status, limit, detail);
    }

    public String apply$default$1() {
        return RequestLevelErrorType$.MODULE$.DEFAULT_ERROR_TYPE();
    }

    public Option<String> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<Tuple4<Refined<String, string.Uri>, HttpResponseStatus, Option<String>, String>> unapply(ProblemDetails x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)new Refined((Object)x$0.type()), (Object)x$0.status(), x$0.limit(), (Object)x$0.detail()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProblemDetails$.class);
    }

    private ProblemDetails$() {
    }
}

