/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import cats.Applicative;
import cats.implicits$;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.api.model.Preview;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UTCDate$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailBody;
import org.apache.james.jmap.mail.EmailBodyMetadata;
import org.apache.james.jmap.mail.EmailBodyPart;
import org.apache.james.jmap.mail.EmailBodyPart$;
import org.apache.james.jmap.mail.EmailBodyValue;
import org.apache.james.jmap.mail.EmailFullView;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailHeaderValue;
import org.apache.james.jmap.mail.EmailHeaders;
import org.apache.james.jmap.mail.EmailHeaders$;
import org.apache.james.jmap.mail.EmailMetadata;
import org.apache.james.jmap.mail.EmailViewFactory;
import org.apache.james.jmap.mail.FetchAllBodyValues;
import org.apache.james.jmap.mail.FetchHTMLBodyValues;
import org.apache.james.jmap.mail.FetchTextBodyValues;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.mail.PartId;
import org.apache.james.jmap.method.ZoneIdProvider;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.html.HtmlTextExtractor;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001\u0002\u0005\n\tQA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!)a\u0007\u0001C\u0001o!)A\t\u0001C!\u000b\")a\u000f\u0001C\u0005o\"1a\u000f\u0001C\u0005\u0003?Aq!!\u0010\u0001\t\u0013\tyD\u0001\u000bF[\u0006LGNR;mYZKWm\u001e$bGR|'/\u001f\u0006\u0003\u0015-\tA!\\1jY*\u0011A\"D\u0001\u0005U6\f\u0007O\u0003\u0002\u000f\u001f\u0005)!.Y7fg*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0019A$H\u0010\u000e\u0003%I!AH\u0005\u0003!\u0015k\u0017-\u001b7WS\u0016<h)Y2u_JL\bC\u0001\u000f!\u0013\t\t\u0013BA\u0007F[\u0006LGNR;mYZKWm^\u0001\u000fu>tW-\u00133Qe>4\u0018\u000eZ3s!\t!s%D\u0001&\u0015\t13\"\u0001\u0004nKRDw\u000eZ\u0005\u0003Q\u0015\u0012aBW8oK&#\u0007K]8wS\u0012,'/\u0001\bqe\u00164\u0018.Z<GC\u000e$xN]=\u0011\u0005-\u001adB\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0015iw\u000eZ3m\u0015\t\u00014\"A\u0002ba&L!AM\u0017\u0002\u000fA\u0013XM^5fo&\u0011A'\u000e\u0002\b\r\u0006\u001cGo\u001c:z\u0015\t\u0011T&\u0001\u0004=S:LGO\u0010\u000b\u0004qeR\u0004C\u0001\u000f\u0001\u0011\u0015\u00113\u00011\u0001$\u0011\u0015I3\u00011\u0001+Q\t\u0019A\b\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u00061\u0011N\u001c6fGRT\u0011!Q\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0007z\u0012a!\u00138kK\u000e$\u0018a\u0002;p\u000b6\f\u0017\u000e\u001c\u000b\u0004\r\"\fHCA$N!\rA5jH\u0007\u0002\u0013*\u0011!jF\u0001\u0005kRLG.\u0003\u0002M\u0013\n\u0019AK]=\t\u000b9#\u0001\u0019A(\u0002\u000f5,7o]1hKB!a\u0003\u0015*Z\u0013\t\tvC\u0001\u0004UkBdWM\r\t\u0003'^k\u0011\u0001\u0016\u0006\u0003]US!AV\u0007\u0002\u000f5\f\u0017\u000e\u001c2pq&\u0011\u0001\f\u0016\u0002\n\u001b\u0016\u001c8/Y4f\u0013\u0012\u00042A\u00172f\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_'\u00051AH]8pizJ\u0011\u0001G\u0005\u0003C^\tq\u0001]1dW\u0006<W-\u0003\u0002dI\n\u00191+Z9\u000b\u0005\u0005<\u0002CA*g\u0013\t9GKA\u0007NKN\u001c\u0018mZ3SKN,H\u000e\u001e\u0005\u0006S\u0012\u0001\rA[\u0001\u0012QRlG\u000eV3yi\u0016CHO]1di>\u0014\bCA6p\u001b\u0005a'BA7o\u0003\u0011AG/\u001c7\u000b\u0005)k\u0011B\u00019m\u0005EAE/\u001c7UKb$X\t\u001f;sC\u000e$xN\u001d\u0005\u0006e\u0012\u0001\ra]\u0001\be\u0016\fX/Z:u!\taB/\u0003\u0002v\u0013\tyQ)\\1jY\u001e+GOU3rk\u0016\u001cH/A\tfqR\u0014\u0018m\u0019;C_\u0012Lh+\u00197vKN$2\u0001_A\u000f)\u0015I\u0018\u0011CA\u000e!\rA5J\u001f\t\u0007w~\f)!a\u0003\u000f\u0005ql\bC\u0001/\u0018\u0013\tqx#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\t\u0019AA\u0002NCBT!A`\f\u0011\u0007q\t9!C\u0002\u0002\n%\u0011a\u0001U1si&#\u0007c\u0001\u000f\u0002\u000e%\u0019\u0011qB\u0005\u0003\u001d\u0015k\u0017-\u001b7C_\u0012Lh+\u00197vK\"9\u00111C\u0003A\u0002\u0005U\u0011!\u00042pIf\u001cFO];diV\u0014X\rE\u0002\u001d\u0003/I1!!\u0007\n\u00055)U.Y5m\u0005>$\u0017\u0010U1si\")!/\u0002a\u0001g\")\u0011.\u0002a\u0001URA\u0011\u0011EA\u0016\u0003c\t\u0019\u0004\u0005\u0003I\u0017\u0006\r\u0002#\u0002.\u0002&\u0005%\u0012bAA\u0014I\n!A*[:u!\u00191\u0002+!\u0002\u0002\f!9\u0011Q\u0006\u0004A\u0002\u0005=\u0012!\u00029beR\u001c\b#\u0002.\u0002&\u0005U\u0001\"\u0002:\u0007\u0001\u0004\u0019\bbBA\u001b\r\u0001\u0007\u0011qG\u0001\fg\"|W\u000f\u001c3GKR\u001c\u0007\u000eE\u0002\u0017\u0003sI1!a\u000f\u0018\u0005\u001d\u0011un\u001c7fC:\fQ#\u001a=ue\u0006\u001cG\u000fV3yi\n{G-\u001f,bYV,7\u000f\u0006\u0003\u0002B\u0005%C\u0003CA\u0011\u0003\u0007\n)%a\u0012\t\u000f\u00055r\u00011\u0001\u00020!)!o\u0002a\u0001g\"9\u0011QG\u0004A\u0002\u0005]\u0002\"B5\b\u0001\u0004Q\u0007")
public class EmailFullViewFactory
implements EmailViewFactory<EmailFullView> {
    private final ZoneIdProvider zoneIdProvider;
    private final Preview.Factory previewFactory;

    @Override
    public Try<EmailFullView> toEmail(HtmlTextExtractor htmlTextExtractor, EmailGetRequest request, Tuple2<MessageId, Seq<MessageResult>> message) {
        MessageId messageId = (MessageId)message._1();
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)((IterableOnceOps)((IterableOps)message._2()).map((Function1 & Serializable)x$14 -> x$14.getMailboxId())).toList());
        return ((Try)((IterableOps)message._2()).headOption().map((Function1 & Serializable)x$15 -> new Success(x$15)).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalArgumentException("No message supplied")))).flatMap((Function1 & Serializable)firstMessage -> Email$.MODULE$.parseAsMime4JMessage((MessageResult)firstMessage).flatMap((Function1 & Serializable)mime4JMessage -> EmailBodyPart$.MODULE$.of(messageId, (Message)mime4JMessage).flatMap((Function1 & Serializable)bodyStructure -> this.extractBodyValues(htmlTextExtractor, (EmailBodyPart)bodyStructure, request).flatMap((Function1 & Serializable)bodyValues -> BlobId$.MODULE$.of(messageId).flatMap((Function1 & Serializable)blobId -> Try$.MODULE$.apply((Function0 & Serializable)() -> $this.previewFactory.fromMessageResult(firstMessage)).flatMap((Function1 & Serializable)preview -> KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags(firstMessage.getFlags()).map((Function1 & Serializable)keywords -> {
            MessageId x$1 = messageId;
            BlobId x$2 = blobId;
            String x$3 = messageId.serialize();
            MailboxIds x$4 = mailboxIds;
            UTCDate x$5 = UTCDate$.MODULE$.from(firstMessage.getInternalDate(), $this.zoneIdProvider.get());
            Keywords x$6 = keywords;
            Long x$7 = Email$.MODULE$.sanitizeSize(firstMessage.getSize());
            EmailMetadata x$8 = new EmailMetadata(x$1, x$2, x$3, x$6, x$4, x$7, x$5);
            EmailHeaders x$9 = EmailHeaders$.MODULE$.from($this.zoneIdProvider.get(), (Message)mime4JMessage);
            EmailBodyMetadata x$10 = new EmailBodyMetadata(!firstMessage.getLoadedAttachments().isEmpty(), (Preview)preview);
            EmailBody x$11 = new EmailBody((EmailBodyPart)bodyStructure, bodyStructure.textBody(), bodyStructure.htmlBody(), bodyStructure.attachments(), (Map<PartId, EmailBodyValue>)bodyValues);
            Map<String, Option<EmailHeaderValue>> x$12 = EmailHeaders$.MODULE$.extractSpecificHeaders(request.properties(), $this.zoneIdProvider.get(), (Message)mime4JMessage);
            return new EmailFullView(x$8, x$9, x$11, x$10, x$12);
        })))))));
    }

    private Try<Map<PartId, EmailBodyValue>> extractBodyValues(HtmlTextExtractor htmlTextExtractor, EmailBodyPart bodyStructure, EmailGetRequest request) {
        return this.extractTextBodyValues(htmlTextExtractor, bodyStructure.textBody(), request, request.fetchTextBodyValues().exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)((FetchTextBodyValues)x$16).value()))).flatMap((Function1 & Serializable)textBodyValues -> this.extractBodyValues(bodyStructure.htmlBody(), request, request.fetchHTMLBodyValues().exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)((FetchHTMLBodyValues)x$17).value()))).flatMap((Function1 & Serializable)htmlBodyValues -> this.extractBodyValues(bodyStructure.flatten(), request, request.fetchAllBodyValues().exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)((FetchAllBodyValues)x$18).value()))).map((Function1 & Serializable)allBodyValues -> ((IterableOnceOps)((StrictOptimizedSeqOps)((IterableOps)textBodyValues.$plus$plus((IterableOnce)htmlBodyValues)).$plus$plus((IterableOnce)allBodyValues)).distinctBy((Function1 & Serializable)x$19 -> (PartId)x$19._1())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
    }

    private Try<List<Tuple2<PartId, EmailBodyValue>>> extractBodyValues(List<EmailBodyPart> parts, EmailGetRequest request, boolean shouldFetch) {
        return shouldFetch ? ((Try)implicits$.MODULE$.toTraverseOps((Object)parts.map((Function1 & Serializable)part -> part.bodyContent().map((Function1 & Serializable)bodyValue -> bodyValue.map((Function1 & Serializable)b -> new Tuple2((Object)part.partId(), (Object)b.truncate(request.maxBodyValueBytes()))))), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForTry())).map((Function1 & Serializable)list -> (List)list.flatten(Predef$.MODULE$.$conforms())) : new Success((Object)package$.MODULE$.Nil());
    }

    private Try<List<Tuple2<PartId, EmailBodyValue>>> extractTextBodyValues(HtmlTextExtractor htmlTextExtractor, List<EmailBodyPart> parts, EmailGetRequest request, boolean shouldFetch) {
        return shouldFetch ? ((Try)implicits$.MODULE$.toTraverseOps((Object)parts.map((Function1 & Serializable)part -> part.textBodyContent(htmlTextExtractor).map((Function1 & Serializable)bodyValue -> bodyValue.map((Function1 & Serializable)b -> new Tuple2((Object)part.partId(), (Object)b.truncate(request.maxBodyValueBytes()))))), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForTry())).map((Function1 & Serializable)list -> (List)list.flatten(Predef$.MODULE$.$conforms())) : new Success((Object)package$.MODULE$.Nil());
    }

    @Inject
    public EmailFullViewFactory(ZoneIdProvider zoneIdProvider, Preview.Factory previewFactory) {
        this.zoneIdProvider = zoneIdProvider;
        this.previewFactory = previewFactory;
    }
}

