/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.numeric;
import eu.timepit.refined.string;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailCreationRequest;
import org.apache.james.jmap.mail.EmailCreationResponse;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.method.EmailSetCreatePerformer$CreationResults$;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.html.HtmlTextExtractor;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0015w!B-[\u0011\u0003)g!B4[\u0011\u0003A\u0007\"B8\u0002\t\u0003\u0001h\u0001B9\u0002\u0001JD!\"!\u0002\u0004\u0005+\u0007I\u0011AA\u0004\u0011)\t9b\u0001B\tB\u0003%\u0011\u0011\u0002\u0005\u0007_\u000e!\t!!\u0007\t\u000f\u0005}1\u0001\"\u0001\u0002\"!9\u0011qM\u0002\u0005\u0002\u0005%\u0004\"CA>\u0007\u0005\u0005I\u0011AA?\u0011%\t\tiAI\u0001\n\u0003\t\u0019\tC\u0005\u0002\u001a\u000e\t\t\u0011\"\u0011\u0002\u001c\"I\u0011QV\u0002\u0002\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003o\u001b\u0011\u0011!C\u0001\u0003sC\u0011\"!2\u0004\u0003\u0003%\t%a2\t\u0013\u0005U7!!A\u0005\u0002\u0005]\u0007\"CAq\u0007\u0005\u0005I\u0011IAr\u0011%\t9oAA\u0001\n\u0003\nI\u000fC\u0005\u0002l\u000e\t\t\u0011\"\u0011\u0002n\"I\u0011q^\u0002\u0002\u0002\u0013\u0005\u0013\u0011_\u0004\n\u0003k\f\u0011\u0011!E\u0001\u0003o4\u0001\"]\u0001\u0002\u0002#\u0005\u0011\u0011 \u0005\u0007_V!\tA!\u0005\t\u0013\u0005-X#!A\u0005F\u00055\b\"\u0003B\n+\u0005\u0005I\u0011\u0011B\u000b\u0011%\u0011I\"FA\u0001\n\u0003\u0013Y\u0002C\u0005\u0003$U\t\t\u0011\"\u0003\u0003&\u0019I\u00111C\u0001\u0011\u0002G\u0005\u0011Q\u0003\u0004\u0007\u0005[\t\u0001Ia\f\t\u0015\tEBD!f\u0001\n\u0003\u0011\u0019\u0004\u0003\u0006\u00036q\u0011\t\u0012)A\u0005\u0003sA!Ba\u000e\u001d\u0005+\u0007I\u0011\u0001B\u001d\u0011)\u0011Y\u0004\bB\tB\u0003%\u0011q\f\u0005\u0007_r!\tA!\u0010\t\u0013\u0005mD$!A\u0005\u0002\t\u0015\u0003\"CAA9E\u0005I\u0011\u0001B&\u0011%\u0011y\u0005HI\u0001\n\u0003\u0011\t\u0006C\u0005\u0002\u001ar\t\t\u0011\"\u0011\u0002\u001c\"I\u0011Q\u0016\u000f\u0002\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003oc\u0012\u0011!C\u0001\u0005+B\u0011\"!2\u001d\u0003\u0003%\t%a2\t\u0013\u0005UG$!A\u0005\u0002\te\u0003\"CAq9\u0005\u0005I\u0011\tB/\u0011%\t9\u000fHA\u0001\n\u0003\nI\u000fC\u0005\u0002lr\t\t\u0011\"\u0011\u0002n\"I\u0011q\u001e\u000f\u0002\u0002\u0013\u0005#\u0011M\u0004\n\u0005K\n\u0011\u0011!E\u0001\u0005O2\u0011B!\f\u0002\u0003\u0003E\tA!\u001b\t\r=|C\u0011\u0001B9\u0011%\tYoLA\u0001\n\u000b\ni\u000fC\u0005\u0003\u0014=\n\t\u0011\"!\u0003t!I!\u0011D\u0018\u0002\u0002\u0013\u0005%\u0011\u0010\u0005\n\u0005Gy\u0013\u0011!C\u0005\u0005K1aA!\"\u0002\u0001\n\u001d\u0005B\u0003B\u0019k\tU\r\u0011\"\u0001\u00034!Q!QG\u001b\u0003\u0012\u0003\u0006I!!\u000f\t\u0015\t%UG!f\u0001\n\u0003\u0011Y\t\u0003\u0006\u0003\u0014V\u0012\t\u0012)A\u0005\u0005\u001bCaa\\\u001b\u0005\u0002\tU\u0005b\u0002BOk\u0011\u0005!q\u0014\u0005\n\u0003w*\u0014\u0011!C\u0001\u0005CC\u0011\"!!6#\u0003%\tAa\u0013\t\u0013\t=S'%A\u0005\u0002\t\u001d\u0006\"CAMk\u0005\u0005I\u0011IAN\u0011%\ti+NA\u0001\n\u0003\ty\u000bC\u0005\u00028V\n\t\u0011\"\u0001\u0003,\"I\u0011QY\u001b\u0002\u0002\u0013\u0005\u0013q\u0019\u0005\n\u0003+,\u0014\u0011!C\u0001\u0005_C\u0011\"!96\u0003\u0003%\tEa-\t\u0013\u0005\u001dX'!A\u0005B\u0005%\b\"CAvk\u0005\u0005I\u0011IAw\u0011%\ty/NA\u0001\n\u0003\u00129lB\u0005\u0003<\u0006\t\t\u0011#\u0001\u0003>\u001aI!QQ\u0001\u0002\u0002#\u0005!q\u0018\u0005\u0007_&#\tAa1\t\u0013\u0005-\u0018*!A\u0005F\u00055\b\"\u0003B\n\u0013\u0006\u0005I\u0011\u0011Bc\u0011%\u0011I\"SA\u0001\n\u0003\u0013Y\rC\u0005\u0003$%\u000b\t\u0011\"\u0003\u0003&\u0019)qM\u0017\u0001\u0003T\"Q!Q[(\u0003\u0002\u0003\u0006IAa6\t\u0015\t\rxJ!A!\u0002\u0013\u0011)\u000f\u0003\u0006\u0003r>\u0013\t\u0011)A\u0005\u0005gD!ba\u0001P\u0005\u0003\u0005\u000b\u0011BB\u0003\u0011\u0019yw\n\"\u0001\u0004\u0012!91qF(\u0005\u0002\rE\u0002bBB\u0018\u001f\u0012%11\r\u0005\b\u0007kzE\u0011BB<\u0011\u001d\u0019Yk\u0014C\u0005\u0007[\u000bq#R7bS2\u001cV\r^\"sK\u0006$X\rU3sM>\u0014X.\u001a:\u000b\u0005mc\u0016AB7fi\"|GM\u0003\u0002^=\u0006!!.\\1q\u0015\ty\u0006-A\u0003kC6,7O\u0003\u0002bE\u00061\u0011\r]1dQ\u0016T\u0011aY\u0001\u0004_J<7\u0001\u0001\t\u0003M\u0006i\u0011A\u0017\u0002\u0018\u000b6\f\u0017\u000e\\*fi\u000e\u0013X-\u0019;f!\u0016\u0014hm\u001c:nKJ\u001c\"!A5\u0011\u0005)lW\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQMA\bDe\u0016\fG/[8o%\u0016\u001cX\u000f\u001c;t'\u0011\u0019\u0011n\u001d<\u0011\u0005)$\u0018BA;l\u0005\u001d\u0001&o\u001c3vGR\u0004\"a^@\u000f\u0005alhBA=}\u001b\u0005Q(BA>e\u0003\u0019a$o\\8u}%\tA.\u0003\u0002\u007fW\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u0011AbU3sS\u0006d\u0017N_1cY\u0016T!A`6\u0002\u000fI,7/\u001e7ugV\u0011\u0011\u0011\u0002\t\u0006o\u0006-\u0011qB\u0005\u0005\u0003\u001b\t\u0019AA\u0002TKF\u00042!!\u0005\u001c\u001b\u0005\t!AD\"sK\u0006$\u0018n\u001c8SKN,H\u000e^\n\u00037%\f\u0001B]3tk2$8\u000f\t\u000b\u0005\u00037\ti\u0002E\u0002\u0002\u0012\rAq!!\u0002\u0007\u0001\u0004\tI!A\u0004de\u0016\fG/\u001a3\u0016\u0005\u0005\r\u0002#\u00026\u0002&\u0005%\u0012bAA\u0014W\n1q\n\u001d;j_:\u0004\u0002\"a\u000b\u00024\u0005e\u0012q\f\b\u0005\u0003[\ty\u0003\u0005\u0002zW&\u0019\u0011\u0011G6\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\u00075\u000b\u0007OC\u0002\u00022-\u0004B!a\u000f\u0002Z9!\u0011QHA*\u001d\u0011\ty$a\u0014\u000f\t\u0005\u0005\u0013Q\n\b\u0005\u0003\u0007\nYE\u0004\u0003\u0002F\u0005%cbA=\u0002H%\t1-\u0003\u0002bE&\u0011q\fY\u0005\u0003;zK1!!\u0015]\u0003\u0011i\u0017-\u001b7\n\t\u0005U\u0013qK\u0001\t\u000b6\f\u0017\u000e\\*fi*\u0019\u0011\u0011\u000b/\n\t\u0005m\u0013Q\f\u0002\u0010\u000b6\f\u0017\u000e\\\"sK\u0006$\u0018n\u001c8JI*!\u0011QKA,!\u0011\t\t'a\u0019\u000e\u0005\u0005]\u0013\u0002BA3\u0003/\u0012Q#R7bS2\u001c%/Z1uS>t'+Z:q_:\u001cX-\u0001\u0006o_R\u001c%/Z1uK\u0012,\"!a\u001b\u0011\u000b)\f)#!\u001c\u0011\u0011\u0005-\u00121GA\u001d\u0003_\u0002B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003kb\u0016\u0001B2pe\u0016LA!!\u001f\u0002t\tA1+\u001a;FeJ|'/\u0001\u0003d_BLH\u0003BA\u000e\u0003\u007fB\u0011\"!\u0002\n!\u0003\u0005\r!!\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0011\u0016\u0005\u0003\u0013\t9i\u000b\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C;oG\",7m[3e\u0015\r\t\u0019j[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0016\u0001\u00026bm\u0006LA!a+\u0002\"\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!-\u0011\u0007)\f\u0019,C\u0002\u00026.\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a/\u0002BB\u0019!.!0\n\u0007\u0005}6NA\u0002B]fD\u0011\"a1\u000e\u0003\u0003\u0005\r!!-\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\r\u0005\u0004\u0002L\u0006E\u00171X\u0007\u0003\u0003\u001bT1!a4l\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\fiM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAm\u0003?\u00042A[An\u0013\r\tin\u001b\u0002\b\u0005>|G.Z1o\u0011%\t\u0019mDA\u0001\u0002\u0004\tY,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAO\u0003KD\u0011\"a1\u0011\u0003\u0003\u0005\r!!-\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!(\u0002\r\u0015\fX/\u00197t)\u0011\tI.a=\t\u0013\u0005\r7#!AA\u0002\u0005m\u0016aD\"sK\u0006$\u0018n\u001c8SKN,H\u000e^:\u0011\u0007\u0005EQcE\u0003\u0016\u0003w\u00149\u0001\u0005\u0005\u0002~\n\r\u0011\u0011BA\u000e\u001b\t\tyPC\u0002\u0003\u0002-\fqA];oi&lW-\u0003\u0003\u0003\u0006\u0005}(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!!\u0011\u0002B\b\u001b\t\u0011YA\u0003\u0003\u0003\u000e\u0005\u0015\u0016AA5p\u0013\u0011\t\tAa\u0003\u0015\u0005\u0005]\u0018!B1qa2LH\u0003BA\u000e\u0005/Aq!!\u0002\u0019\u0001\u0004\tI!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu!q\u0004\t\u0006U\u0006\u0015\u0012\u0011\u0002\u0005\n\u0005CI\u0012\u0011!a\u0001\u00037\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u00119\u0003\u0005\u0003\u0002 \n%\u0012\u0002\u0002B\u0016\u0003C\u0013aa\u00142kK\u000e$(aD\"sK\u0006$\u0018n\u001c8Tk\u000e\u001cWm]:\u0014\rqI\u0017qB:w\u0003!\u0019G.[3oi&#WCAA\u001d\u0003%\u0019G.[3oi&#\u0007%\u0001\u0005sKN\u0004xN\\:f+\t\ty&A\u0005sKN\u0004xN\\:fAQ1!q\bB!\u0005\u0007\u00022!!\u0005\u001d\u0011\u001d\u0011\t$\ta\u0001\u0003sAqAa\u000e\"\u0001\u0004\ty\u0006\u0006\u0004\u0003@\t\u001d#\u0011\n\u0005\n\u0005c\u0011\u0003\u0013!a\u0001\u0003sA\u0011Ba\u000e#!\u0003\u0005\r!a\u0018\u0016\u0005\t5#\u0006BA\u001d\u0003\u000f\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003T)\"\u0011qLAD)\u0011\tYLa\u0016\t\u0013\u0005\rw%!AA\u0002\u0005EF\u0003BAm\u00057B\u0011\"a1*\u0003\u0003\u0005\r!a/\u0015\t\u0005u%q\f\u0005\n\u0003\u0007T\u0013\u0011!a\u0001\u0003c#B!!7\u0003d!I\u00111Y\u0017\u0002\u0002\u0003\u0007\u00111X\u0001\u0010\u0007J,\u0017\r^5p]N+8mY3tgB\u0019\u0011\u0011C\u0018\u0014\u000b=\u0012YGa\u0002\u0011\u0015\u0005u(QNA\u001d\u0003?\u0012y$\u0003\u0003\u0003p\u0005}(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!q\r\u000b\u0007\u0005\u007f\u0011)Ha\u001e\t\u000f\tE\"\u00071\u0001\u0002:!9!q\u0007\u001aA\u0002\u0005}C\u0003\u0002B>\u0005\u0007\u0003RA[A\u0013\u0005{\u0002rA\u001bB@\u0003s\ty&C\u0002\u0003\u0002.\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003B\u0011g\u0005\u0005\t\u0019\u0001B \u0005=\u0019%/Z1uS>tg)Y5mkJ,7CB\u001bj\u0003\u001f\u0019h/A\u0001f+\t\u0011i\tE\u0002x\u0005\u001fKAA!%\u0002\u0004\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0003K\u0002\"bAa&\u0003\u001a\nm\u0005cAA\tk!9!\u0011\u0007\u001eA\u0002\u0005e\u0002b\u0002BEu\u0001\u0007!QR\u0001\u0012CNlUm]:bO\u0016\u001cV\r^#se>\u0014XCAA8)\u0019\u00119Ja)\u0003&\"I!\u0011\u0007\u001f\u0011\u0002\u0003\u0007\u0011\u0011\b\u0005\n\u0005\u0013c\u0004\u0013!a\u0001\u0005\u001b+\"A!++\t\t5\u0015q\u0011\u000b\u0005\u0003w\u0013i\u000bC\u0005\u0002D\u0006\u000b\t\u00111\u0001\u00022R!\u0011\u0011\u001cBY\u0011%\t\u0019mQA\u0001\u0002\u0004\tY\f\u0006\u0003\u0002\u001e\nU\u0006\"CAb\t\u0006\u0005\t\u0019AAY)\u0011\tIN!/\t\u0013\u0005\rw)!AA\u0002\u0005m\u0016aD\"sK\u0006$\u0018n\u001c8GC&dWO]3\u0011\u0007\u0005E\u0011jE\u0003J\u0005\u0003\u00149\u0001\u0005\u0006\u0002~\n5\u0014\u0011\bBG\u0005/#\"A!0\u0015\r\t]%q\u0019Be\u0011\u001d\u0011\t\u0004\u0014a\u0001\u0003sAqA!#M\u0001\u0004\u0011i\t\u0006\u0003\u0003N\nE\u0007#\u00026\u0002&\t=\u0007c\u00026\u0003\u0000\u0005e\"Q\u0012\u0005\n\u0005Ci\u0015\u0011!a\u0001\u0005/\u001b\"aT5\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0003\u0003Z\n}WB\u0001Bn\u0015\r\u0011i\u000eX\u0001\u0005UN|g.\u0003\u0003\u0003b\nm'AE#nC&d7+\u001a;TKJL\u0017\r\\5{KJ\fQB\u00197pEJ+7o\u001c7wKJ\u001c\b\u0003\u0002Bt\u0005[l!A!;\u000b\u0007\t-H,\u0001\u0004s_V$Xm]\u0005\u0005\u0005_\u0014IOA\u0007CY>\u0014'+Z:pYZ,'o]\u0001\u0012QRlG\u000eV3yi\u0016CHO]1di>\u0014\b\u0003\u0002B{\u0005\u007fl!Aa>\u000b\t\te(1`\u0001\u0005QRlGNC\u0002\u0003~z\u000bA!\u001e;jY&!1\u0011\u0001B|\u0005EAE/\u001c7UKb$X\t\u001f;sC\u000e$xN]\u0001\u000f[\u0006LGNY8y\u001b\u0006t\u0017mZ3s!\u0011\u00199a!\u0004\u000e\u0005\r%!bAB\u0006=\u00069Q.Y5mE>D\u0018\u0002BB\b\u0007\u0013\u0011a\"T1jY\n|\u00070T1oC\u001e,'\u000f\u0006\u0006\u0004\u0014\rU1qCB\r\u00077\u0001\"AZ(\t\u000f\tUG\u000b1\u0001\u0003X\"9!1\u001d+A\u0002\t\u0015\bb\u0002By)\u0002\u0007!1\u001f\u0005\b\u0007\u0007!\u0006\u0019AB\u0003Q\r!6q\u0004\t\u0005\u0007C\u0019Y#\u0004\u0002\u0004$)!1QEB\u0014\u0003\u0019IgN[3di*\u00111\u0011F\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0007[\u0019\u0019C\u0001\u0004J]*,7\r^\u0001\u0007GJ,\u0017\r^3\u0015\r\rM2qJB-!\u0019\u0019)da\u0011\u0004H5\u00111q\u0007\u0006\u0005\u0007s\u0019Y$A\u0005qk\nd\u0017n\u001d5fe*\u0019An!\u0010\u000b\t\u0005U4q\b\u0006\u0003\u0007\u0003\nqA]3bGR|'/\u0003\u0003\u0004F\r]\"!B*N_:|\u0007cAB%\u00079\u001911\n\u0001\u000f\t\u0005}2QJ\u0005\u00037rCqa!\u0015V\u0001\u0004\u0019\u0019&A\u0004sKF,Xm\u001d;\u0011\t\u0005\u00054QK\u0005\u0005\u0007/\n9FA\bF[\u0006LGnU3u%\u0016\fX/Z:u\u0011\u001d\u0019Y&\u0016a\u0001\u0007;\na\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0003\u0004\b\r}\u0013\u0002BB1\u0007\u0013\u0011a\"T1jY\n|\u0007pU3tg&|g\u000e\u0006\u0005\u0004f\r%41NB:!\u0019\u0019)da\u0011\u0004hA\u00191\u0011J\u000e\t\u000f\tEb\u000b1\u0001\u0002:!91\u0011\u000b,A\u0002\r5\u0004\u0003BA1\u0007_JAa!\u001d\u0002X\t!R)\\1jY\u000e\u0013X-\u0019;j_:\u0014V-];fgRDqaa\u0017W\u0001\u0004\u0019i&\u0001\u0004baB,g\u000e\u001a\u000b\u000b\u0007s\u001aYh! \u0004\u0014\u000eU\u0005cAB%9!9!\u0011G,A\u0002\u0005e\u0002bBB@/\u0002\u00071\u0011Q\u0001\u000eCB\u0004XM\u001c3D_6l\u0017M\u001c3\u0011\t\r\r5Q\u0012\b\u0005\u0007\u000b\u001bII\u0004\u0003\u0002B\r\u001d\u0015bAB\u0006=&!11RB\u0005\u00039iUm]:bO\u0016l\u0015M\\1hKJLAaa$\u0004\u0012\ni\u0011\t\u001d9f]\u0012\u001cu.\\7b]\u0012TAaa#\u0004\n!911L,A\u0002\ru\u0003bBBL/\u0002\u00071\u0011T\u0001\u000b[\u0006LGNY8y\u0013\u0012\u001c\b#B<\u0004\u001c\u000e}\u0015\u0002BBO\u0003\u0007\u0011A\u0001T5tiB!1\u0011UBT\u001b\t\u0019\u0019K\u0003\u0003\u0004&\u000e%\u0011!B7pI\u0016d\u0017\u0002BBU\u0007G\u0013\u0011\"T1jY\n|\u00070\u00133\u0002\u001f\u0005\u001c\u0018\t\u001d9f]\u0012\u001cu.\\7b]\u0012$ba!!\u00040\u000eE\u0006bBB)1\u0002\u00071Q\u000e\u0005\b\u0007gC\u0006\u0019AB[\u0003\u001diWm]:bO\u0016\u0004Baa.\u0004B6\u00111\u0011\u0018\u0006\u0005\u0007w\u001bi,A\u0002e_6T1aa0_\u0003\u0019i\u0017.\\35U&!11YB]\u0005\u001diUm]:bO\u0016\u0004")
public class EmailSetCreatePerformer {
    private final EmailSetSerializer serializer;
    private final BlobResolvers blobResolvers;
    private final HtmlTextExtractor htmlTextExtractor;
    private final MailboxManager mailboxManager;

    public SMono<CreationResults> create(EmailSetRequest request, MailboxSession mailboxSession) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)request.create().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String clientId = (String)((Refined)tuple2._1()).value();
            JsObject json = (JsObject)tuple2._2();
            SMono sMono = (SMono)$this.serializer.deserializeCreationRequest((JsValue)json).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException(e.toString()))), (Function1 & Serializable)creationRequest -> this.create(clientId, (EmailCreationRequest)creationRequest, mailboxSession));
            return sMono;
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq().map((Function1)EmailSetCreatePerformer$CreationResults$.MODULE$);
    }

    private SMono<CreationResult> create(String clientId, EmailCreationRequest request, MailboxSession mailboxSession) {
        List<MailboxId> mailboxIds = request.mailboxIds().value();
        return mailboxIds.size() != 1 ? SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException("mailboxIds need to have size 1"))) : SMono$.MODULE$.fromCallable(() -> request.toMime4JMessage($this.blobResolvers, $this.htmlTextExtractor, mailboxSession)).flatMap((Function1 & Serializable)either -> (SMono)either.fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e)), (Function1 & Serializable)message -> SMono$.MODULE$.fromCallable(() -> this.append(clientId, this.asAppendCommand(request, (Message)message), mailboxSession, mailboxIds)))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e))).subscribeOn(Schedulers.elastic());
    }

    private CreationSuccess append(String clientId, MessageManager.AppendCommand appendCommand, MailboxSession mailboxSession, List<MailboxId> mailboxIds) {
        MessageManager.AppendResult appendResult = this.mailboxManager.getMailbox((MailboxId)mailboxIds.head(), mailboxSession).appendMessage(appendCommand, mailboxSession);
        Option blobId = BlobId$.MODULE$.of(appendResult.getId().getMessageId()).toOption();
        return new CreationSuccess(clientId, new EmailCreationResponse(appendResult.getId().getMessageId(), blobId, blobId, Email$.MODULE$.sanitizeSize(Predef$.MODULE$.Long2long(appendResult.getSize()))));
    }

    private MessageManager.AppendCommand asAppendCommand(EmailCreationRequest request, Message message) {
        return MessageManager.AppendCommand.builder().recent().withFlags((Flags)request.keywords().map((Function1 & Serializable)x$3 -> x$3.asFlags()).getOrElse((Function0 & Serializable)() -> new Flags())).withInternalDate(Date.from(((UTCDate)request.receivedAt().getOrElse((Function0 & Serializable)() -> new UTCDate(ZonedDateTime.now()))).asUTC().toInstant())).build(message);
    }

    @Inject
    public EmailSetCreatePerformer(EmailSetSerializer serializer, BlobResolvers blobResolvers, HtmlTextExtractor htmlTextExtractor, MailboxManager mailboxManager) {
        this.serializer = serializer;
        this.blobResolvers = blobResolvers;
        this.htmlTextExtractor = htmlTextExtractor;
        this.mailboxManager = mailboxManager;
    }

    public static class CreationFailure
    implements CreationResult,
    Product,
    Serializable {
        private final String clientId;
        private final Throwable e;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String clientId() {
            return this.clientId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            SetError setError;
            Throwable throwable = this.e();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                setError = SetError$.MODULE$.notFound(new StringBuilder(8).append("Mailbox ").append(mailboxNotFoundException.getMessage()).toString());
            } else if (throwable instanceof BlobNotFoundException) {
                BlobNotFoundException blobNotFoundException = (BlobNotFoundException)throwable;
                setError = SetError$.MODULE$.invalidArguments(new StringBuilder(22).append("Attachment not found: ").append(new Refined((Object)blobNotFoundException.blobId().value())).toString(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value()))}))));
            } else if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                setError = SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            } else {
                setError = SetError$.MODULE$.serverFail(this.e().getMessage());
            }
            return setError;
        }

        public CreationFailure copy(String clientId, Throwable e) {
            return new CreationFailure(clientId, e);
        }

        public String copy$default$1() {
            return this.clientId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "CreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = new Refined((Object)this.clientId());
                    break;
                }
                case 1: {
                    object = this.e();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationFailure;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "clientId";
                    break;
                }
                case 1: {
                    string2 = "e";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationFailure creationFailure = (CreationFailure)x$1;
            Refined refined = new Refined((Object)this.clientId());
            Refined refined2 = new Refined((Object)creationFailure.clientId());
            if (refined == null) {
                if (refined2 != null) {
                    return false;
                }
            } else if (!refined.equals(refined2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = creationFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!creationFailure.canEqual(this)) return false;
            return true;
        }

        public CreationFailure(String clientId, Throwable e) {
            this.clientId = clientId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface CreationResult {
    }

    public static class CreationResults
    implements Product,
    Serializable {
        private final Seq<CreationResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<CreationResult> results() {
            return this.results;
        }

        public Option<Map<Refined<String, boolean.And<collection.Size<boolean.And<boolean.Not<numeric.Less<Object>>, boolean.Not<numeric.Greater<Object>>>>, string.MatchesRegex<String>>>, EmailCreationResponse>> created() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                None$ none$;
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationSuccess) {
                    CreationSuccess creationSuccess = (CreationSuccess)creationResult;
                    none$ = new Some((Object)new Tuple2((Object)new Refined((Object)creationSuccess.clientId()), (Object)creationSuccess.response()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<Refined<String, boolean.And<collection.Size<boolean.And<boolean.Not<numeric.Less<Object>>, boolean.Not<numeric.Greater<Object>>>>, string.MatchesRegex<String>>>, SetError>> notCreated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                None$ none$;
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationFailure) {
                    CreationFailure creationFailure = (CreationFailure)creationResult;
                    none$ = new Some((Object)new Tuple2((Object)new Refined((Object)creationFailure.clientId()), (Object)creationFailure.asMessageSetError()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public CreationResults copy(Seq<CreationResult> results) {
            return new CreationResults(results);
        }

        public Seq<CreationResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "CreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.results();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationResults;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "results";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationResults creationResults = (CreationResults)x$1;
            Seq<CreationResult> seq = this.results();
            Seq<CreationResult> seq2 = creationResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!creationResults.canEqual(this)) return false;
            return true;
        }

        public CreationResults(Seq<CreationResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class CreationSuccess
    implements CreationResult,
    Product,
    Serializable {
        private final String clientId;
        private final EmailCreationResponse response;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String clientId() {
            return this.clientId;
        }

        public EmailCreationResponse response() {
            return this.response;
        }

        public CreationSuccess copy(String clientId, EmailCreationResponse response) {
            return new CreationSuccess(clientId, response);
        }

        public String copy$default$1() {
            return this.clientId();
        }

        public EmailCreationResponse copy$default$2() {
            return this.response();
        }

        public String productPrefix() {
            return "CreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = new Refined((Object)this.clientId());
                    break;
                }
                case 1: {
                    object = this.response();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationSuccess;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "clientId";
                    break;
                }
                case 1: {
                    string2 = "response";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationSuccess creationSuccess = (CreationSuccess)x$1;
            Refined refined = new Refined((Object)this.clientId());
            Refined refined2 = new Refined((Object)creationSuccess.clientId());
            if (refined == null) {
                if (refined2 != null) {
                    return false;
                }
            } else if (!refined.equals(refined2)) return false;
            EmailCreationResponse emailCreationResponse = this.response();
            EmailCreationResponse emailCreationResponse2 = creationSuccess.response();
            if (emailCreationResponse == null) {
                if (emailCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationResponse).equals(emailCreationResponse2)) return false;
            if (!creationSuccess.canEqual(this)) return false;
            return true;
        }

        public CreationSuccess(String clientId, EmailCreationResponse response) {
            this.clientId = clientId;
            this.response = response;
            Product.$init$((Product)this);
        }
    }
}

