/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.vacation.VacationPatch;
import org.apache.james.jmap.api.vacation.VacationRepository;
import org.apache.james.jmap.change.AccountIdRegistrationKey;
import org.apache.james.jmap.change.StateChangeEvent;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.State;
import org.apache.james.jmap.core.State$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.json.VacationSerializer$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.method.VacationResponseSetMethod$;
import org.apache.james.jmap.method.VacationResponseUpdateFailure;
import org.apache.james.jmap.method.VacationResponseUpdateResult;
import org.apache.james.jmap.method.VacationResponseUpdateResults;
import org.apache.james.jmap.method.VacationResponseUpdateResults$;
import org.apache.james.jmap.method.VacationResponseUpdateSuccess$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.jmap.vacation.VacationResponsePatchObject;
import org.apache.james.jmap.vacation.VacationResponseSetError;
import org.apache.james.jmap.vacation.VacationResponseSetError$;
import org.apache.james.jmap.vacation.VacationResponseSetRequest;
import org.apache.james.jmap.vacation.VacationResponseSetResponse;
import org.apache.james.jmap.vacation.VacationResponseUpdateResponse;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t}q!B\r\u001b\u0011\u0003)c!B\u0014\u001b\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%\tA\r\u0005\u0007w\u0005\u0001\u000b\u0011B\u001a\u0007\t\u001dR\u0002\u0001\u0010\u0005\t\r\u0016\u0011\t\u0011)A\u0005\u000f\"A\u0011,\u0002B\u0001B\u0003%!\f\u0003\u0005b\u000b\t\u0015\r\u0011\"\u0001c\u0011!QWA!A!\u0002\u0013\u0019\u0007\u0002C6\u0006\u0005\u000b\u0007I\u0011\u00017\t\u0011M,!\u0011!Q\u0001\n5DQaL\u0003\u0005\u0002QD\u0001b`\u0003C\u0002\u0013\u0005\u0013\u0011\u0001\u0005\t\u0003_)\u0001\u0015!\u0003\u0002\u0004!I\u0011\u0011G\u0003C\u0002\u0013\u0005\u00131\u0007\u0005\t\u0003'*\u0001\u0015!\u0003\u00026!9\u0011QK\u0003\u0005B\u0005]\u0003bBAH\u000b\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003o+A\u0011BA]\u0011\u001d\t9,\u0002C\u0005\u0003\u0013Dq!a8\u0006\t\u0013\t\t\u000fC\u0004\u0002r\u0016!I!a=\t\u000f\u0005uX\u0001\"\u0003\u0002\u0000\"9!\u0011D\u0003\u0005\n\tm\u0011!\u0007,bG\u0006$\u0018n\u001c8SKN\u0004xN\\:f'\u0016$X*\u001a;i_\u0012T!a\u0007\u000f\u0002\r5,G\u000f[8e\u0015\tib$\u0001\u0003k[\u0006\u0004(BA\u0010!\u0003\u0015Q\u0017-\\3t\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001A\u0011a%A\u0007\u00025\tIb+Y2bi&|gNU3ta>t7/Z*fi6+G\u000f[8e'\t\t\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\n!EV!D\u0003RKuJT0S\u000bN\u0003vJT*F?B\u000bEk\u0011%`\u001f\nSUi\u0011+`\u0017\u0016KV#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00027b]\u001eT\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\t11\u000b\u001e:j]\u001e\f1EV!D\u0003RKuJT0S\u000bN\u0003vJT*F?B\u000bEk\u0011%`\u001f\nSUi\u0011+`\u0017\u0016K\u0006eE\u0002\u0006Su\u00022A\n A\u0013\ty$D\u0001\rNKRDw\u000e\u001a*fcVL'/\u001b8h\u0003\u000e\u001cw.\u001e8u\u0013\u0012\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\u000f\u0002\u0011Y\f7-\u0019;j_:L!!\u0012\"\u00035Y\u000b7-\u0019;j_:\u0014Vm\u001d9p]N,7+\u001a;SKF,Xm\u001d;\u0002\u0011\u00154XM\u001c;CkN\u0004\"\u0001S&\u000e\u0003%S!A\u0013\u0010\u0002\r\u00154XM\u001c;t\u0013\ta\u0015J\u0001\u0005Fm\u0016tGOQ;tQ\u00111aJV,\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016AB5oU\u0016\u001cGOC\u0001T\u0003\u0015Q\u0017M^1y\u0013\t)\u0006KA\u0003OC6,G-A\u0003wC2,X-I\u0001Y\u0003\u0011QU*\u0011)\u0002%Y\f7-\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u00037~k\u0011\u0001\u0018\u0006\u0003\u0007vS!A\u0018\u000f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002a9\n\u0011b+Y2bi&|gNU3q_NLGo\u001c:z\u00035iW\r\u001e:jG\u001a\u000b7\r^8ssV\t1\r\u0005\u0002eQ6\tQM\u0003\u0002_M*\u0011qMH\u0001\b[\u0016$(/[2t\u0013\tIWMA\u0007NKR\u0014\u0018n\u0019$bGR|'/_\u0001\u000f[\u0016$(/[2GC\u000e$xN]=!\u0003=\u0019Xm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014X#A7\u0011\u00059\fX\"A8\u000b\u0005Ad\u0012A\u0002:pkR,7/\u0003\u0002s_\ny1+Z:tS>t7+\u001e9qY&,'/\u0001\ttKN\u001c\u0018n\u001c8TkB\u0004H.[3sAQ)QO\u001e=zuB\u0011a%\u0002\u0005\u0006\r2\u0001\ra\u0012\u0015\u0005m:3v\u000bC\u0003Z\u0019\u0001\u0007!\fC\u0003b\u0019\u0001\u00071\rC\u0003l\u0019\u0001\u0007Q\u000e\u000b\u0002\ryB\u0011q*`\u0005\u0003}B\u0013a!\u00138kK\u000e$\u0018AC7fi\"|GMT1nKV\u0011\u00111\u0001\t\u0005\u0003\u000b\tIC\u0004\u0003\u0002\b\u0005\rb\u0002BA\u0005\u0003?qA!a\u0003\u0002\u001e9!\u0011QBA\u000e\u001d\u0011\ty!!\u0007\u000f\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006%\u0003\u0019a$o\\8u}%\t1%\u0003\u0002\"E%\u0011q\u0004I\u0005\u0003;yI1!!\t\u001d\u0003\u0011\u0019wN]3\n\t\u0005\u0015\u0012qE\u0001\u000b\u0013:4xnY1uS>t'bAA\u00119%!\u00111FA\u0017\u0005)iU\r\u001e5pI:\u000bW.\u001a\u0006\u0005\u0003K\t9#A\u0006nKRDw\u000e\u001a(b[\u0016\u0004\u0013\u0001\u0006:fcVL'/\u001a3DCB\f'-\u001b7ji&,7/\u0006\u0002\u00026A1\u0011qGA \u0003\u000brA!!\u000f\u0002<A\u0019\u0011\u0011C\u0016\n\u0007\u0005u2&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\n\u0019EA\u0002TKRT1!!\u0010,!\u0011\t9%!\u0014\u000f\t\u0005\u001d\u0011\u0011J\u0005\u0005\u0003\u0017\n9#\u0001\u000bDCB\f'-\u001b7jifLE-\u001a8uS\u001aLWM]\u0005\u0005\u0003\u001f\n\tF\u0001\u000bDCB\f'-\u001b7jifLE-\u001a8uS\u001aLWM\u001d\u0006\u0005\u0003\u0017\n9#A\u000bsKF,\u0018N]3e\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\u0011\u0002\u0013\u0011|\u0007K]8dKN\u001cHCCA-\u0003g\n9(a\u001f\u0002\fB1\u00111LA5\u0003[j!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\naV\u0014G.[:iKJT1\u0001LA2\u0015\u0011\t\t#!\u001a\u000b\u0005\u0005\u001d\u0014a\u0002:fC\u000e$xN]\u0005\u0005\u0003W\niFA\u0003T\u001b>tw\u000eE\u0002'\u0003_J1!!\u001d\u001b\u0005UIeN^8dCRLwN\\,ji\"\u001cuN\u001c;fqRDq!!\u001e\u0012\u0001\u0004\t)$\u0001\u0007dCB\f'-\u001b7ji&,7\u000fC\u0004\u0002zE\u0001\r!!\u001c\u0002\u0015%tgo\\2bi&|g\u000eC\u0004\u0002~E\u0001\r!a \u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B!\u0011\u0011QAD\u001b\t\t\u0019IC\u0002\u0002\u0006z\tq!\\1jY\n|\u00070\u0003\u0003\u0002\n\u0006\r%AD'bS2\u0014w\u000e_*fgNLwN\u001c\u0005\u0007\u0003\u001b\u000b\u0002\u0019\u0001!\u0002\u000fI,\u0017/^3ti\u0006Qq-\u001a;SKF,Xm\u001d;\u0015\r\u0005M\u00151VAW!\u001d\t)*a(\u0002&\u0002sA!a&\u0002\u001c:!\u0011\u0011CAM\u0013\u0005a\u0013bAAOW\u00059\u0001/Y2lC\u001e,\u0017\u0002BAQ\u0003G\u0013a!R5uQ\u0016\u0014(bAAOWA!\u0011QSAT\u0013\u0011\tI+a)\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|g\u000eC\u0004\u0002~I\u0001\r!a \t\u000f\u0005e$\u00031\u0001\u00020B!\u0011\u0011WAZ\u001b\t\t9#\u0003\u0003\u00026\u0006\u001d\"AC%om>\u001c\u0017\r^5p]\u00061Q\u000f\u001d3bi\u0016$b!a/\u0002D\u0006\u0015\u0007CBA.\u0003S\ni\fE\u0002'\u0003\u007fK1!!1\u001b\u0005u1\u0016mY1uS>t'+Z:q_:\u001cX-\u00169eCR,'+Z:vYR\u001c\bbBA?'\u0001\u0007\u0011q\u0010\u0005\u0007\u0003\u000f\u001c\u0002\u0019\u0001!\u00025Y\f7-\u0019;j_:\u0014Vm\u001d9p]N,7+\u001a;SKF,Xm\u001d;\u0015\r\u0005-\u00171[Ao!\u0019\tY&!\u001b\u0002NB\u0019a%a4\n\u0007\u0005E'D\u0001\u000fWC\u000e\fG/[8o%\u0016\u001c\bo\u001c8tKV\u0003H-\u0019;f%\u0016\u001cX\u000f\u001c;\t\u000f\u0005UG\u00031\u0001\u0002X\u0006qa/\u00197jI\u0006$X\r\u001a)bi\u000eD\u0007cA.\u0002Z&\u0019\u00111\u001c/\u0003\u001bY\u000b7-\u0019;j_:\u0004\u0016\r^2i\u0011\u001d\ti\b\u0006a\u0001\u0003\u007f\n1\u0003^8WC\u000e\fG/[8o\u0003\u000e\u001cw.\u001e8u\u0013\u0012$B!a9\u0002pB!\u0011Q]Av\u001b\t\t9OC\u0002\u0002jv\u000bQ!\\8eK2LA!!<\u0002h\nI\u0011iY2pk:$\u0018\n\u001a\u0005\b\u0003{*\u0002\u0019AA@\u00039\u0019'/Z1uKJ+7\u000f]8og\u0016$\u0002\"a,\u0002v\u0006]\u0018\u0011 \u0005\b\u0003s2\u0002\u0019AAX\u0011\u0019\t9M\u0006a\u0001\u0001\"9\u00111 \fA\u0002\u0005u\u0016\u0001D;qI\u0006$XMU3tk2$\u0018\u0001\u0005<bY&$\u0017\r^3O_\u000e\u0013X-\u0019;f)\u0011\u0011\tAa\u0006\u0011\u000b)\u0012\u0019Aa\u0002\n\u0007\t\u00151F\u0001\u0004PaRLwN\u001c\t\t\u0003o\u0011IA!\u0004\u0003\u0012%!!1BA\"\u0005\ri\u0015\r\u001d\t\u0005\u0003o\u0011y!C\u0002;\u0003\u0007\u00022!\u0011B\n\u0013\r\u0011)B\u0011\u0002\u0019-\u0006\u001c\u0017\r^5p]J+7\u000f]8og\u0016\u001cV\r^#se>\u0014\bBBAd/\u0001\u0007\u0001)A\twC2LG-\u0019;f\u001d>$Um\u001d;s_f$BA!\u0001\u0003\u001e!1\u0011q\u0019\rA\u0002\u0001\u0003")
public class VacationResponseSetMethod
implements MethodRequiringAccountId<VacationResponseSetRequest> {
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final VacationRepository vacationRepository;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    public static String VACATION_RESPONSE_PATCH_OBJECT_KEY() {
        return VacationResponseSetMethod$.MODULE$.VACATION_RESPONSE_PATCH_OBJECT_KEY();
    }

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, VacationResponseSetRequest request) {
        return this.update(mailboxSession, request).map((Function1 & Serializable)updateResult -> this.createResponse(invocation.invocation(), request, (VacationResponseUpdateResults)updateResult)).flatMap((Function1 & Serializable)next -> {
            Event.EventId x$1 = Event.EventId.random();
            None$ x$2 = None$.MODULE$;
            None$ x$3 = None$.MODULE$;
            None$ x$4 = None$.MODULE$;
            Username x$5 = mailboxSession.getUser();
            Some x$6 = new Some((Object)new State(UUID.randomUUID()));
            StateChangeEvent event = new StateChangeEvent(x$1, x$5, (Option<State>)x$6, (Option<State>)x$2, (Option<State>)x$3, (Option<State>)x$4);
            AccountId accountId = AccountId.fromUsername((Username)mailboxSession.getUser());
            return SMono$.MODULE$.apply((Publisher)$this.eventBus.dispatch((Event)event, (RegistrationKey)new AccountIdRegistrationKey(accountId))).then(SMono$.MODULE$.just(next));
        }).map((Function1 & Serializable)x$1 -> new InvocationWithContext((Invocation)x$1, invocation.processingContext()));
    }

    @Override
    public Either<IllegalArgumentException, VacationResponseSetRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        Right right;
        JsResult<VacationResponseSetRequest> jsResult = VacationSerializer$.MODULE$.deserializeVacationResponseSetRequest((JsValue)invocation.arguments());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            VacationResponseSetRequest vacationResponseSetRequest = (VacationResponseSetRequest)jsSuccess.value();
            right = package$.MODULE$.Right().apply((Object)vacationResponseSetRequest);
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            right = package$.MODULE$.Left().apply((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        } else {
            throw new MatchError(jsResult);
        }
        return right;
    }

    private SMono<VacationResponseUpdateResults> update(MailboxSession mailboxSession, VacationResponseSetRequest vacationResponseSetRequest) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)vacationResponseSetRequest.parsePatch().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                Either either = (Either)tuple2._2();
                if (either instanceof Right) {
                    Right right = (Right)either;
                    VacationResponsePatchObject patch = (VacationResponsePatchObject)right.value();
                    return (SMono)patch.asVacationPatch().fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new VacationResponseUpdateFailure(id, (Throwable)e)), (Function1 & Serializable)validatedPatch -> this.update((VacationPatch)validatedPatch, mailboxSession));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String id = (String)tuple2._1();
            Either either = (Either)tuple2._2();
            if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
            Left left = (Left)either;
            IllegalArgumentException e2 = (IllegalArgumentException)left.value();
            return SMono$.MODULE$.just((Object)new VacationResponseUpdateFailure(id, e2));
        }));
        Function1 & Serializable x$1 = (Function1 & Serializable)updateResultMono -> updateResultMono;
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).map((Function1 & Serializable)updateResult -> updateResult.asVacationResponseUpdateResults()).reduceWith((Function0 & Serializable)() -> VacationResponseUpdateResults$.MODULE$.empty(), (Function2 & Serializable)(a, b) -> VacationResponseUpdateResults$.MODULE$.merge((VacationResponseUpdateResults)a, (VacationResponseUpdateResults)b));
    }

    private SMono<VacationResponseUpdateResult> update(VacationPatch validatedPatch, MailboxSession mailboxSession) {
        return SMono$.MODULE$.fromPublisher((Publisher)this.vacationRepository.modifyVacation(this.toVacationAccountId(mailboxSession), validatedPatch)).then(SMono$.MODULE$.just((Object)VacationResponseUpdateSuccess$.MODULE$));
    }

    private AccountId toVacationAccountId(MailboxSession mailboxSession) {
        return AccountId.fromUsername((Username)mailboxSession.getUser());
    }

    private Invocation createResponse(Invocation invocation, VacationResponseSetRequest vacationResponseSetRequest, VacationResponseUpdateResults updateResult) {
        VacationResponseSetResponse response = new VacationResponseSetResponse(vacationResponseSetRequest.accountId(), State$.MODULE$.INSTANCE(), (Option<Map<String, VacationResponseUpdateResponse>>)new Some(updateResult.updateSuccess()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty())), (Option<Map<String, VacationResponseSetError>>)new Some(updateResult.updateFailures()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())), this.validateNoCreate(vacationResponseSetRequest), this.validateNoDestroy(vacationResponseSetRequest));
        return new Invocation(this.methodName(), (JsObject)VacationSerializer$.MODULE$.serialize(response).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.methodCallId());
    }

    private Option<Map<String, VacationResponseSetError>> validateNoCreate(VacationResponseSetRequest vacationResponseSetRequest) {
        return vacationResponseSetRequest.create().map((Function1 & Serializable)aMap -> aMap.view().mapValues((Function1 & Serializable)x$4 -> VacationResponseSetError$.MODULE$.invalidArgument((Option<SetError.SetErrorDescription>)new Some((Object)new SetError.SetErrorDescription("'create' is not supported on singleton objects")))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Option<Map<String, VacationResponseSetError>> validateNoDestroy(VacationResponseSetRequest vacationResponseSetRequest) {
        return vacationResponseSetRequest.destroy().map((Function1 & Serializable)aSet -> ((IterableOnceOps)aSet.map((Function1 & Serializable)id -> new Tuple2(id, (Object)VacationResponseSetError$.MODULE$.invalidArgument((Option<SetError.SetErrorDescription>)new Some((Object)new SetError.SetErrorDescription("'destroy' is not supported on singleton objects")))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Inject
    public VacationResponseSetMethod(@Named(value="JMAP") EventBus eventBus, VacationRepository vacationRepository, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.eventBus = eventBus;
        this.vacationRepository = vacationRepository;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"VacationResponse/set")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_VACATION_RESPONSE())}));
        Statics.releaseFence();
    }
}

