/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutesHandler;
import org.apache.james.jmap.VersionParser;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.util.Port;
import org.slf4j.LoggerFactory;
import reactor.netty.DisposableChannel;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class JMAPServer
implements Startable {
    private static final int RANDOM_PORT = 0;
    private final JMAPConfiguration configuration;
    private final Set<JMAPRoutesHandler> jmapRoutesHandlers;
    private final VersionParser versionParser;
    private Optional<DisposableServer> server;

    @Inject
    public JMAPServer(JMAPConfiguration configuration, Set<JMAPRoutesHandler> jmapRoutesHandlers, VersionParser versionParser) {
        this.configuration = configuration;
        this.jmapRoutesHandlers = jmapRoutesHandlers;
        this.versionParser = versionParser;
        this.server = Optional.empty();
    }

    public Port getPort() {
        return this.server.map(DisposableServer::port).map(Port::of).orElseThrow(() -> new IllegalStateException("port is not available because server is not started or disabled"));
    }

    public void start() {
        if (this.configuration.isEnabled()) {
            this.server = Optional.of(HttpServer.create().port(this.configuration.getPort().map(Port::getValue).orElse(0).intValue()).handle((request, response) -> this.handleVersionRoute((HttpServerRequest)request).handleRequest((HttpServerRequest)request, (HttpServerResponse)response)).wiretap(this.wireTapEnabled()).bindNow());
        }
    }

    private boolean wireTapEnabled() {
        return LoggerFactory.getLogger((String)"org.apache.james.jmap.wire").isTraceEnabled();
    }

    private JMAPRoute.Action handleVersionRoute(HttpServerRequest request) {
        try {
            return this.jmapRoutesHandlers.stream().flatMap(jmapRoutesHandler -> jmapRoutesHandler.routes(this.versionParser.parseRequestVersionHeader(request))).filter(jmapRoute -> jmapRoute.matches(request)).map(JMAPRoute::getAction).findFirst().orElse((req, res) -> res.status(HttpResponseStatus.NOT_FOUND).send());
        }
        catch (IllegalArgumentException e) {
            return (req, res) -> res.status(HttpResponseStatus.BAD_REQUEST).send();
        }
    }

    @PreDestroy
    public void stop() {
        this.server.ifPresent(DisposableChannel::disposeNow);
    }
}

