/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.jwt.PublicKeyReader;

public class JwtConfiguration {
    private static final boolean DEFAULT_VALUE = true;
    private final Optional<String> jwtPublicKeyPem;

    public JwtConfiguration(Optional<String> jwtPublicKeyPem) {
        Preconditions.checkState((boolean)this.validPublicKey(jwtPublicKeyPem), (Object)"The provided public key is not valid");
        this.jwtPublicKeyPem = jwtPublicKeyPem;
    }

    private boolean validPublicKey(Optional<String> jwtPublicKeyPem) {
        PublicKeyReader reader = new PublicKeyReader();
        return jwtPublicKeyPem.map(value -> reader.fromPEM(Optional.of(value)).isPresent()).orElse(true);
    }

    public Optional<String> getJwtPublicKeyPem() {
        return this.jwtPublicKeyPem;
    }
}

