/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.transport.mailets.redirect.AddressExtractor;
import org.apache.james.transport.mailets.redirect.InitParameters;
import org.apache.james.transport.mailets.redirect.ProcessRedirectNotify;
import org.apache.james.transport.mailets.redirect.RedirectMailetInitParameters;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.TypeCode;
import org.apache.james.transport.mailets.utils.MimeMessageModifier;
import org.apache.james.transport.util.RecipientsUtils;
import org.apache.james.transport.util.ReplyToUtils;
import org.apache.james.transport.util.SenderUtils;
import org.apache.james.transport.util.TosUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Forward
extends GenericMailet
implements RedirectNotify {
    private static final Logger LOGGER = LoggerFactory.getLogger(Forward.class);
    private static final String[] CONFIGURABLE_PARAMETERS = new String[]{"debug", "passThrough", "fakeDomainCheck", "forwardto", "forwardTo"};
    private static final List<String> ALLOWED_SPECIALS = ImmutableList.of((Object)"postmaster", (Object)"sender", (Object)"from", (Object)"replyTo", (Object)"reversePath", (Object)"unaltered", (Object)"recipients", (Object)"to", (Object)"null");
    private final DNSService dns;

    @Inject
    Forward(DNSService dns) {
        this.dns = dns;
    }

    public String getMailetInfo() {
        return "Forward Mailet";
    }

    @Override
    public InitParameters getInitParameters() {
        return RedirectMailetInitParameters.from(this, Optional.of(TypeCode.NONE), Optional.empty());
    }

    @Override
    public String[] getAllowedInitParameters() {
        return CONFIGURABLE_PARAMETERS;
    }

    @Override
    public DNSService getDNSService() {
        return this.dns;
    }

    public void init() throws MessagingException {
        if (this.getInitParameters().isDebug()) {
            LOGGER.debug("Initializing");
        }
        this.checkInitParameters(this.getAllowedInitParameters());
        if (this.getInitParameters().isStatic() && this.getInitParameters().isDebug()) {
            LOGGER.debug(this.getInitParameters().asString());
        }
    }

    @Override
    public String getMessage(Mail originalMail) throws MessagingException {
        return this.getInitParameters().getMessage();
    }

    @Override
    public List<MailAddress> getRecipients() throws MessagingException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (InternetAddress address : this.extractAddresses(this.getForwardTo())) {
            builder.add((Object)this.toMailAddress(address));
        }
        return builder.build();
    }

    @Override
    public List<MailAddress> getRecipients(Mail originalMail) throws MessagingException {
        return RecipientsUtils.from(this).getRecipients(originalMail);
    }

    private InternetAddress[] extractAddresses(String addressList) throws MessagingException {
        try {
            return InternetAddress.parse((String)addressList, (boolean)false);
        }
        catch (AddressException e) {
            throw new MessagingException("Exception thrown in getRecipients() parsing: " + addressList, (Exception)((Object)e));
        }
    }

    private MailAddress toMailAddress(InternetAddress address) throws MessagingException {
        try {
            Optional<MailAddress> specialAddress = AddressExtractor.withContext(this.getMailetContext()).allowedSpecials(ALLOWED_SPECIALS).getSpecialAddress(address.getAddress());
            if (specialAddress.isPresent()) {
                return specialAddress.get();
            }
            return new MailAddress(address);
        }
        catch (Exception e) {
            throw new MessagingException("Exception thrown in getRecipients() parsing: " + address.getAddress());
        }
    }

    private String getForwardTo() throws MessagingException {
        String forwardTo = this.getInitParameter("forwardto", this.getInitParameter("forwardTo"));
        if (Strings.isNullOrEmpty((String)forwardTo)) {
            throw new MessagingException("Failed to initialize \"recipients\" list: no or empty <forwardTo> or <forwardto> init parameter found");
        }
        return forwardTo;
    }

    @Override
    public List<InternetAddress> getTo() throws MessagingException {
        return ImmutableList.of();
    }

    @Override
    public List<MailAddress> getTo(Mail originalMail) throws MessagingException {
        return TosUtils.from(this).getTo(originalMail);
    }

    @Override
    public Optional<MailAddress> getReplyTo() throws MessagingException {
        return Optional.empty();
    }

    @Override
    public Optional<MailAddress> getReplyTo(Mail originalMail) throws MessagingException {
        return ReplyToUtils.from(this.getReplyTo()).getReplyTo(originalMail);
    }

    @Override
    public Optional<MailAddress> getReversePath() throws MessagingException {
        return Optional.empty();
    }

    @Override
    public Optional<MailAddress> getReversePath(Mail originalMail) throws MessagingException {
        return Optional.empty();
    }

    @Override
    public Optional<MailAddress> getSender() throws MessagingException {
        return Optional.empty();
    }

    @Override
    public Optional<MailAddress> getSender(Mail originalMail) throws MessagingException {
        return SenderUtils.from(this.getSender()).getSender(originalMail);
    }

    @Override
    public Optional<String> getSubjectPrefix(Mail newMail, String subjectPrefix, Mail originalMail) throws MessagingException {
        return Optional.empty();
    }

    @Override
    public MimeMessageModifier getMimeMessageModifier(Mail newMail, Mail originalMail) throws MessagingException {
        return new MimeMessageModifier(newMail.getMessage());
    }

    @Override
    public void service(Mail originalMail) throws MessagingException {
        ProcessRedirectNotify.from(this).process(originalMail);
    }
}

