/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.context.web;

import org.apache.james.container.spring.resource.DefaultJamesResourceLoader;
import org.apache.james.container.spring.resource.JamesResourceLoader;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class JamesServerWebApplicationContext
extends XmlWebApplicationContext
implements JamesResourceLoader {
    private final JamesResourceLoader resourceLoader = new DefaultJamesResourceLoader(new JamesDirectoriesProvider(){

        public String getAbsoluteDirectory() {
            if (JamesServerWebApplicationContext.this.absoluteDirectory == null) {
                return this.getRootDirectory();
            }
            return JamesServerWebApplicationContext.this.absoluteDirectory;
        }

        public String getConfDirectory() {
            if (JamesServerWebApplicationContext.this.confDirectory == null) {
                return this.getRootDirectory() + "/WEB-INF/conf/";
            }
            return JamesServerWebApplicationContext.this.confDirectory;
        }

        public String getRootDirectory() {
            if (JamesServerWebApplicationContext.this.rootDirectory == null) {
                return JamesServerWebApplicationContext.this.getServletContext().getRealPath("/");
            }
            return JamesServerWebApplicationContext.this.rootDirectory;
        }

        public String getVarDirectory() {
            if (JamesServerWebApplicationContext.this.varDirectory == null) {
                return this.getRootDirectory() + "/var/";
            }
            return JamesServerWebApplicationContext.this.varDirectory;
        }
    });
    private String rootDirectory;
    private String absoluteDirectory;
    private String varDirectory;
    private String confDirectory;

    public Resource getResource(String fileURL) {
        Resource r = this.resourceLoader.getResource(fileURL);
        if (r == null) {
            r = super.getResource(fileURL);
        }
        return r;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public void setAbsoluteDirectory(String absoluteDirectory) {
        this.absoluteDirectory = absoluteDirectory;
    }

    public void setVarDirectory(String varDirectory) {
        this.varDirectory = varDirectory;
    }

    public void setConfDirectory(String confDirectory) {
        this.confDirectory = confDirectory;
    }

    public String getAbsoluteDirectory() {
        return this.resourceLoader.getAbsoluteDirectory();
    }

    public String getConfDirectory() {
        return this.resourceLoader.getConfDirectory();
    }

    public String getVarDirectory() {
        return this.resourceLoader.getVarDirectory();
    }

    public String getRootDirectory() {
        return this.resourceLoader.getRootDirectory();
    }
}

