/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.Serializable;
import java.time.Duration;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.task.Hostname;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import org.apache.james.task.eventsourcing.CancelCommandHandler;
import org.apache.james.task.eventsourcing.CancelRequested;
import org.apache.james.task.eventsourcing.CompleteCommandHandler;
import org.apache.james.task.eventsourcing.CreateCommandHandler;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.FailCommandHandler;
import org.apache.james.task.eventsourcing.RequestCancelCommandHandler;
import org.apache.james.task.eventsourcing.StartCommandHandler;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import org.apache.james.task.eventsourcing.TaskCommand;
import org.apache.james.task.eventsourcing.TaskEvent;
import org.apache.james.task.eventsourcing.TaskExecutionDetailsProjection;
import org.apache.james.task.eventsourcing.TerminationSubscriber;
import org.apache.james.task.eventsourcing.UpdateCommandHandler;
import org.apache.james.task.eventsourcing.WorkQueueSupplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001B\u000e\u001d\u0001\u001dB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\n\u0003\u0005R\u0001\t\u0015\r\u0011\"\u0001S\u0011!1\u0006A!A!\u0002\u0013\u0019\u0006\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0001-\t\u0011q\u0003!\u0011!Q\u0001\neC\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005?\"11\r\u0001C\u00019\u0011Dq!a\u0001\u0001\t\u0013\t)\u0001C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012!A\u00111\u0006\u0001!\u0002\u0013\t\u0019\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u0011q\u0007\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002<!A\u00111\t\u0001!\u0002\u0013\ti\u0004C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003_\u0002A\u0011IA@\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!,\u0001\t\u0003\ny\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005]\b\u0001\"\u0011\u0002H\tARI^3oiN{WO]2j]\u001e$\u0016m]6NC:\fw-\u001a:\u000b\u0005uq\u0012!D3wK:$8o\\;sG&twM\u0003\u0002 A\u0005!A/Y:l\u0015\t\t#%A\u0003kC6,7O\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0006\u0001!\u0002DG\u000f\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA\u0001\\1oO*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018+\u0005\u0019y%M[3diB\u0011\u0011GM\u0007\u0002=%\u00111G\b\u0002\f)\u0006\u001c8.T1oC\u001e,'\u000f\u0005\u00026q5\taG\u0003\u00028Y\u0005\u0011\u0011n\\\u0005\u0003sY\u0012\u0011b\u00117pg\u0016\f'\r\\3\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014aA1qS*\u0011q\bI\u0001\nY&4WmY=dY\u0016L!!\u0011\u001f\u0003\u0013M#\u0018M\u001d;bE2,\u0017!E<pe.\fV/Z;f'V\u0004\b\u000f\\5feB\u0011A)R\u0007\u00029%\u0011a\t\b\u0002\u0012/>\u00148.U;fk\u0016\u001cV\u000f\u001d9mS\u0016\u0014\u0018AC3wK:$8\u000b^8sKV\t\u0011\n\u0005\u0002K\u001d6\t1J\u0003\u0002M\u001b\u0006QQM^3oiN$xN]3\u000b\u0005u\u0001\u0013BA(L\u0005))e/\u001a8u'R|'/Z\u0001\fKZ,g\u000e^*u_J,\u0007%\u0001\u000efq\u0016\u001cW\u000f^5p]\u0012+G/Y5mgB\u0013xN[3di&|g.F\u0001T!\t!E+\u0003\u0002V9\tqB+Y:l\u000bb,7-\u001e;j_:$U\r^1jYN\u0004&o\u001c6fGRLwN\\\u0001\u001cKb,7-\u001e;j_:$U\r^1jYN\u0004&o\u001c6fGRLwN\u001c\u0011\u0002\u0011!|7\u000f\u001e8b[\u0016,\u0012!\u0017\t\u0003ciK!a\u0017\u0010\u0003\u0011!{7\u000f\u001e8b[\u0016\f\u0011\u0002[8ti:\fW.\u001a\u0011\u0002+Q,'/\\5oCRLwN\\*vEN\u001c'/\u001b2feV\tq\f\u0005\u0002EA&\u0011\u0011\r\b\u0002\u0016)\u0016\u0014X.\u001b8bi&|gnU;cg\u000e\u0014\u0018NY3s\u0003Y!XM]7j]\u0006$\u0018n\u001c8Tk\n\u001c8M]5cKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004fM\u001eD\u0017N\u001b\t\u0003\t\u0002AQA\u0011\u0006A\u0002\rCQa\u0012\u0006A\u0002%CQ!\u0015\u0006A\u0002MCQa\u0016\u0006A\u0002eCQ!\u0018\u0006A\u0002}C#A\u00037\u0011\u000554X\"\u00018\u000b\u0005=\u0004\u0018aC1o]>$\u0018\r^5p]NT!!\u001d:\u0002\r\r|W.\\8o\u0015\t\u0019H/\u0001\u0004h_><G.\u001a\u0006\u0002k\u0006\u00191m\\7\n\u0005]t'!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\"\u0012!\"\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fa!\u001b8kK\u000e$(\"\u0001@\u0002\u000b)\fg/\u0019=\n\u0007\u0005\u00051P\u0001\u0004J]*,7\r^\u0001\u000fo>\u00148\u000eR5ta\u0006$8\r[3s+\t\t9\u0001\u0005\u0003\u0002\n\u0005-Q\"A'\n\u0007\u00055QJ\u0001\u0006Tk\n\u001c8M]5cKJ\f1\u0002\\8bI\"K7\u000f^8ssV\u0011\u00111\u0003\t\t\u0003+\tY\"a\b\u0002&5\u0011\u0011q\u0003\u0006\u0003\u00033\tQa]2bY\u0006LA!!\b\u0002\u0018\tIa)\u001e8di&|g.\r\t\u0005\u0003\u0013\t\t#C\u0002\u0002$5\u00131\"Q4he\u0016<\u0017\r^3JIB\u0019!*a\n\n\u0007\u0005%2JA\u0004ISN$xN]=\u0002\u00191|\u0017\r\u001a%jgR|'/\u001f\u0011\u0002'\u00154XM\u001c;T_V\u00148-\u001b8h'f\u001cH/Z7\u0016\u0005\u0005E\u0002\u0003BA\u0005\u0003gI1!!\u000eN\u0005M)e/\u001a8u'>,(oY5oONK8\u000f^3n\u0003Q)g/\u001a8u'>,(oY5oONK8\u000f^3nA\u0005Iqo\u001c:l#V,W/Z\u000b\u0003\u0003{\u00012!MA \u0013\r\t\tE\b\u0002\n/>\u00148.U;fk\u0016\f!b^8sWF+X-^3!\u0003\u0015\u0019H/\u0019:u)\t\tI\u0005\u0005\u0003\u0002\u0016\u0005-\u0013\u0002BA'\u0003/\u0011A!\u00168ji\u000611/\u001e2nSR$B!a\u0015\u0002ZA\u0019\u0011'!\u0016\n\u0007\u0005]cD\u0001\u0004UCN\\\u0017\n\u001a\u0005\u0007?M\u0001\r!a\u0017\u0011\u0007E\ni&C\u0002\u0002`y\u0011A\u0001V1tW\u0006\u0019r-\u001a;Fq\u0016\u001cW\u000f^5p]\u0012+G/Y5mgR!\u0011QMA6!\r\t\u0014qM\u0005\u0004\u0003Sr\"\u0001\u0006+bg.,\u00050Z2vi&|g\u000eR3uC&d7\u000fC\u0004\u0002nQ\u0001\r!a\u0015\u0002\u0005%$\u0017\u0001\u00027jgR$\"!a\u001d\u0011\r\u0005U\u00141PA3\u001b\t\t9HC\u0002\u0002z1\nA!\u001e;jY&!\u0011QPA<\u0005\u0011a\u0015n\u001d;\u0015\t\u0005M\u0014\u0011\u0011\u0005\b\u0003\u00073\u0002\u0019AAC\u0003\u0019\u0019H/\u0019;vgB!\u0011qQAG\u001d\r\t\u0014\u0011R\u0005\u0004\u0003\u0017s\u0012a\u0003+bg.l\u0015M\\1hKJLA!a$\u0002\u0012\n11\u000b^1ukNT1!a#\u001f\u0003%a\u0017n\u001d;TG\u0006d\u0017-\u0006\u0002\u0002\u0018B1\u0011\u0011TAU\u0003KrA!a'\u0002&:!\u0011QTAR\u001b\t\tyJC\u0002\u0002\"\u001a\na\u0001\u0010:p_Rt\u0014BAA\r\u0013\u0011\t9+a\u0006\u0002\u000fA\f7m[1hK&!\u0011QPAV\u0015\u0011\t9+a\u0006\u0002\r\r\fgnY3m)\u0011\tI%!-\t\u000f\u00055\u0004\u00041\u0001\u0002T\u0005)\u0011m^1jiR1\u0011QMA\\\u0003sCq!!\u001c\u001a\u0001\u0004\t\u0019\u0006C\u0004\u0002<f\u0001\r!!0\u0002\u000fQLW.Z8viB!\u0011qXAc\u001b\t\t\tMC\u0002\u0002D2\nA\u0001^5nK&!\u0011qYAa\u0005!!UO]1uS>t\u0007&B\r\u0002L\u0006%\bCBA\u000b\u0003\u001b\f\t.\u0003\u0003\u0002P\u0006]!A\u0002;ie><8\u000f\u0005\u0003\u0002T\u0006\u0015h\u0002BAk\u0003\u0013sA!a6\u0002d:!\u0011\u0011\\Aq\u001d\u0011\tY.a8\u000f\t\u0005u\u0015Q\\\u0005\u0002K%\u00111\u0005J\u0005\u0003C\tJ!a\b\u0011\n\t\u0005\u001d\u0018\u0011\u0013\u0002\u0018%\u0016\f7\r[3e)&lWm\\;u\u000bb\u001cW\r\u001d;j_:\u001c#!!5)\u000be\ti/!>\u0011\r\u0005U\u0011QZAx!\r\t\u0014\u0011_\u0005\u0004\u0003gt\"!\u0006+bg.tu\u000e\u001e$pk:$W\t_2faRLwN\\\u0012\u0003\u0003_\fQa\u00197pg\u0016D3AGA~!\u0011\tiPa\u0001\u000e\u0005\u0005}(b\u0001B\u0001{\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\u0011q \u0002\u000b!J,G)Z:ue>L\b")
public class EventSourcingTaskManager
implements TaskManager,
Closeable,
Startable {
    private final EventStore eventStore;
    private final TaskExecutionDetailsProjection executionDetailsProjection;
    private final Hostname hostname;
    private final TerminationSubscriber terminationSubscriber;
    private final Function1<AggregateId, History> loadHistory;
    private final EventSourcingSystem eventSourcingSystem;
    private final WorkQueue workQueue;

    public EventStore eventStore() {
        return this.eventStore;
    }

    public TaskExecutionDetailsProjection executionDetailsProjection() {
        return this.executionDetailsProjection;
    }

    public Hostname hostname() {
        return this.hostname;
    }

    public TerminationSubscriber terminationSubscriber() {
        return this.terminationSubscriber;
    }

    private Subscriber workDispatcher() {
        return x0$1 -> {
            Event event = x0$1;
            if (event instanceof Created) {
                Created created = (Created)event;
                TaskAggregateId aggregateId = created.aggregateId();
                Task task = created.task();
                TaskWithId taskWithId = new TaskWithId(aggregateId.taskId(), task);
                this.workQueue().submit(taskWithId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (event instanceof CancelRequested) {
                CancelRequested cancelRequested = (CancelRequested)event;
                TaskAggregateId aggregateId = cancelRequested.aggregateId();
                this.workQueue().cancel(aggregateId.taskId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        };
    }

    private Function1<AggregateId, History> loadHistory() {
        return this.loadHistory;
    }

    private EventSourcingSystem eventSourcingSystem() {
        return this.eventSourcingSystem;
    }

    private WorkQueue workQueue() {
        return this.workQueue;
    }

    public void start() {
        this.workQueue().start();
    }

    /*
     * WARNING - void declaration
     */
    public TaskId submit(Task task) {
        void var2_2;
        TaskId taskId = TaskId.generateTaskId();
        TaskCommand.Create command = new TaskCommand.Create(taskId, task);
        this.eventSourcingSystem().dispatch((Command)command);
        return var2_2;
    }

    public TaskExecutionDetails getExecutionDetails(TaskId id) {
        return (TaskExecutionDetails)this.executionDetailsProjection().load(id).getOrElse((Function0 & Serializable)() -> {
            throw new TaskNotFoundException();
        });
    }

    public java.util.List<TaskExecutionDetails> list() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.listScala()).asJava();
    }

    public java.util.List<TaskExecutionDetails> list(TaskManager.Status status) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.listScala().filter((Function1 & Serializable)details -> BoxesRunTime.boxToBoolean((boolean)EventSourcingTaskManager.$anonfun$list$1(status, details)))).asJava();
    }

    private List<TaskExecutionDetails> listScala() {
        return this.executionDetailsProjection().list();
    }

    public void cancel(TaskId id) {
        TaskCommand.RequestCancel command = new TaskCommand.RequestCancel(id);
        this.eventSourcingSystem().dispatch((Command)command);
    }

    public TaskExecutionDetails await(TaskId id, Duration timeout) throws TaskNotFoundException, TaskManager.ReachedTimeoutException {
        TaskExecutionDetails taskExecutionDetails;
        try {
            Mono details = Mono.fromSupplier(() -> this.getExecutionDetails(id)).filter(x$1 -> x$1.getStatus().isFinished());
            Mono findEvent = Flux.from(this.terminationSubscriber().listenEvents()).filter(x0$1 -> {
                boolean bl;
                Event event = x0$1;
                if (event instanceof TaskEvent) {
                    TaskEvent taskEvent = (TaskEvent)event;
                    TaskId taskId = taskEvent.getAggregateId().taskId();
                    TaskId taskId2 = id;
                    bl = !(taskId != null ? !taskId.equals(taskId2) : taskId2 != null);
                } else {
                    bl = false;
                }
                return bl;
            }).next().then(details);
            taskExecutionDetails = (TaskExecutionDetails)Flux.merge((Publisher[])new Publisher[]{findEvent, details}).subscribeOn(Schedulers.elastic()).blockFirst(timeout);
        }
        catch (IllegalStateException illegalStateException) {
            throw new TaskManager.ReachedTimeoutException();
        }
        return taskExecutionDetails;
    }

    @Override
    @PreDestroy
    public void close() {
        this.workQueue().close();
    }

    public static final /* synthetic */ boolean $anonfun$list$1(TaskManager.Status status$1, TaskExecutionDetails details) {
        TaskManager.Status status = details.getStatus();
        TaskManager.Status status2 = status$1;
        return !(status != null ? !status.equals(status2) : status2 != null);
    }

    @Inject
    @VisibleForTesting
    public EventSourcingTaskManager(WorkQueueSupplier workQueueSupplier, EventStore eventStore, TaskExecutionDetailsProjection executionDetailsProjection, Hostname hostname, TerminationSubscriber terminationSubscriber) {
        this.eventStore = eventStore;
        this.executionDetailsProjection = executionDetailsProjection;
        this.hostname = hostname;
        this.terminationSubscriber = terminationSubscriber;
        this.loadHistory = (Function1 & Serializable)aggregateId -> this.eventStore().getEventsOfAggregate(aggregateId);
        this.eventSourcingSystem = new EventSourcingSystem((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CommandHandler[]{new CreateCommandHandler(this.loadHistory(), hostname), new StartCommandHandler(this.loadHistory(), hostname), new RequestCancelCommandHandler(this.loadHistory(), hostname), new CompleteCommandHandler(this.loadHistory()), new CancelCommandHandler(this.loadHistory()), new FailCommandHandler(this.loadHistory()), new UpdateCommandHandler(this.loadHistory())})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subscriber[]{executionDetailsProjection.asSubscriber(hostname), this.workDispatcher(), terminationSubscriber})), eventStore);
        this.workQueue = workQueueSupplier.apply(this.eventSourcingSystem());
    }
}

