/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.james.core.Username;
import org.apache.james.jmap.AccessToken;
import org.apache.james.jmap.JMAPTestingConstants;
import org.hamcrest.core.IsAnything;

public class HttpJmapAuthentication {
    public static AccessToken authenticateJamesUser(URIBuilder uriBuilder, Username username, String password) {
        return (AccessToken)JMAPTestingConstants.calmlyAwait.until(() -> HttpJmapAuthentication.doAuthenticate(uriBuilder, username, password), IsAnything.anything());
    }

    public static AccessToken doAuthenticate(URIBuilder uriBuilder, Username username, String password) throws ClientProtocolException, IOException, URISyntaxException {
        String continuationToken = HttpJmapAuthentication.getContinuationToken(uriBuilder, username);
        Response response = HttpJmapAuthentication.postAuthenticate(uriBuilder, password, continuationToken);
        return AccessToken.of((String)JsonPath.parse((String)response.returnContent().asString()).read("accessToken", new Predicate[0]));
    }

    private static Response postAuthenticate(URIBuilder uriBuilder, String password, String continuationToken) throws ClientProtocolException, IOException, URISyntaxException {
        return Request.Post((URI)uriBuilder.setPath("/authentication").build()).bodyString("{\"token\": \"" + continuationToken + "\", \"method\": \"password\", \"password\": \"" + password + "\"}", ContentType.APPLICATION_JSON).setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType()).execute();
    }

    private static String getContinuationToken(URIBuilder uriBuilder, Username username) throws ClientProtocolException, IOException, URISyntaxException {
        Response response = Request.Post((URI)uriBuilder.setPath("/authentication").build()).bodyString("{\"username\": \"" + username.asString() + "\", \"clientName\": \"Mozilla Thunderbird\", \"clientVersion\": \"42.0\", \"deviceName\": \"Joe Blogg\u2019s iPhone\"}", ContentType.APPLICATION_JSON).setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType()).execute();
        return (String)JsonPath.parse((String)response.returnContent().asString()).read("continuationToken", new Predicate[0]);
    }
}

