/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.james.core.Username;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;

public interface JMAPTestingConstants {
    public static final ConditionFactory calmlyAwait = Awaitility.with().pollInterval(Duration.ofMillis(100L)).and().with().pollDelay(Duration.ofMillis(1L)).await();
    public static final RequestSpecBuilder jmapRequestSpecBuilder = new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8)));
    public static final String NAME = "[0][0]";
    public static final String ARGUMENTS = "[0][1]";
    public static final String FIRST_MAILBOX = "[0][1].list[0]";
    public static final String SECOND_MAILBOX = "[0][1].list[1]";
    public static final String SECOND_NAME = "[1][0]";
    public static final String SECOND_ARGUMENTS = "[1][1]";
    public static final String DOMAIN = "domain.tld";
    public static final String DOMAIN_ALIAS = "domain-alias.tld";
    public static final Username BOB = Username.of((String)"bob@domain.tld");
    public static final String BOB_PASSWORD = "123456";
    public static final Username ALICE = Username.of((String)"alice@domain.tld");
    public static final String ALICE_PASSWORD = "789123";
    public static final Username CEDRIC = Username.of((String)"cedric@domain.tld");
    public static final String CEDRIC_PASSWORD = "456789";
    public static final String LOCALHOST_IP = "127.0.0.1";
}

