/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import io.restassured.RestAssured;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.ResponseSpecification;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.james.jmap.AccessToken;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.model.MailboxId;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.text.IsEmptyString;

public class JmapCommonRequests {
    private static final String NAME = "[0][0]";
    private static final String ARGUMENTS = "[0][1]";
    private static final String NOT_UPDATED = "[0][1].notUpdated";

    public static String getOutboxId(AccessToken accessToken) {
        return JmapCommonRequests.getMailboxId(accessToken, Role.OUTBOX);
    }

    public static String getSentId(AccessToken accessToken) {
        return JmapCommonRequests.getMailboxId(accessToken, Role.SENT);
    }

    public static String getDraftId(AccessToken accessToken) {
        return JmapCommonRequests.getMailboxId(accessToken, Role.DRAFTS);
    }

    public static String getMailboxId(AccessToken accessToken, Role role) {
        return JmapCommonRequests.getAllMailboxesIds(accessToken).stream().filter(mailbox -> ((String)mailbox.get("role")).equals(role.serialize())).map(mailbox -> (String)mailbox.get("id")).findFirst().get();
    }

    public static List<Map<String, String>> getAllMailboxesIds(AccessToken accessToken) {
        return ((Response)((Response)RestAssured.with().header("Authorization", (Object)accessToken.asString(), new Object[0]).body("[[\"getMailboxes\", {\"properties\": [\"role\", \"name\", \"id\"]}, \"#0\"]]").post("/jmap", new Object[0])).andReturn()).body().jsonPath().getList("[0][1].list");
    }

    public static boolean isAnyMessageFoundInRecipientsMailboxes(AccessToken recipientToken) {
        try {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)recipientToken.asString(), new Object[0]).body("[[\"getMessageList\", {}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body(NAME, Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0]);
            return true;
        }
        catch (AssertionError e) {
            return false;
        }
    }

    public static boolean isAnyMessageFoundInRecipientsMailbox(AccessToken recipientToken, MailboxId mailboxId) {
        return JmapCommonRequests.isAnyMessageFoundInRecipientsMailbox(recipientToken, mailboxId.serialize());
    }

    public static boolean isAnyMessageFoundInRecipientsMailbox(AccessToken recipientToken, String serialize) {
        try {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)recipientToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + serialize + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body(NAME, Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0]);
            return true;
        }
        catch (AssertionError e) {
            return false;
        }
    }

    public static String getInboxId(AccessToken accessToken) {
        return JmapCommonRequests.getMailboxId(accessToken, Role.INBOX);
    }

    public static List<String> listMessageIdsForAccount(AccessToken accessToken) {
        return (List)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)accessToken.asString(), new Object[0]).body("[[\"getMessageList\", {}, \"#0\"]]").post("/jmap", new Object[0])).then()).extract().body().path("[0][1].messageIds", new String[0]);
    }

    public static String getLastMessageId(AccessToken accessToken) {
        return (String)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)accessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"sort\":[\"date desc\"]}, \"#0\"]]").post("/jmap", new Object[0])).then()).extract().body().path("[0][1].messageIds[0]", new String[0]);
    }

    public static String getLatestMessageId(AccessToken accessToken, Role mailbox) {
        String mailboxId = JmapCommonRequests.getMailboxId(accessToken, mailbox);
        return (String)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)accessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + mailboxId + "\"]}, \"sort\":[\"date desc\"]}, \"#0\"]]").post("/jmap", new Object[0])).then()).extract().path("[0][1].messageIds[0]", new String[0]);
    }

    public static String bodyOfMessage(AccessToken accessToken, String messageId) {
        return (String)JmapCommonRequests.getMessageContent(accessToken, messageId).get("[0][1].list[0].textBody");
    }

    public static List<String> receiversOfMessage(AccessToken accessToken, String messageId) {
        return JmapCommonRequests.getMessageContent(accessToken, messageId).getList("[0][1].list[0].to.email");
    }

    private static JsonPath getMessageContent(AccessToken accessToken, String messageId) {
        return ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)accessToken.asString(), new Object[0]).body("[[\"getMessages\", {\"ids\": [\"" + messageId + "\"]}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body(NAME, Matchers.equalTo((Object)"messages"), new Object[0])).body("[0][1].list", Matchers.hasSize((int)1), new Object[0])).extract().jsonPath();
    }

    public static List<String> listMessageIdsInMailbox(AccessToken accessToken, String mailboxId) {
        return (List)((ValidatableResponse)((Response)RestAssured.with().header("Authorization", (Object)accessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + mailboxId + "\"]}}, \"#0\"]]").post("/jmap", new Object[0])).then()).extract().body().path("[0][1].messageIds", new String[0]);
    }

    public static ResponseSpecification getSetMessagesUpdateOKResponseAssertions(String messageId) {
        ResponseSpecBuilder builder = new ResponseSpecBuilder().expectStatusCode(200).expectBody(NAME, Matchers.equalTo((Object)"messagesSet")).expectBody("[0][1].updated", Matchers.hasSize((int)1)).expectBody("[0][1].updated", Matchers.contains((Object[])new String[]{messageId})).expectBody("[0][1].error", Is.is((Matcher)IsEmptyString.emptyOrNullString())).expectBody(NOT_UPDATED, Matchers.not((Matcher)Matchers.hasKey((Object)messageId)));
        return builder.build();
    }

    public static void deleteMessages(AccessToken accessToken, List<String> idsToDestroy) {
        String idString = JmapCommonRequests.concatMessageIds(idsToDestroy);
        RestAssured.with().header("Authorization", (Object)accessToken.asString(), new Object[0]).body("[[\"setMessages\", {\"destroy\": [" + idString + "]}, \"#0\"]]").post("/jmap", new Object[0]);
    }

    public static String concatMessageIds(List<String> ids) {
        return ids.stream().map(id -> "\"" + id + "\"").collect(Collectors.joining(","));
    }
}

