/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.docker;

import com.github.dockerjava.api.model.ContainerNetwork;
import com.google.common.base.Strings;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.junit.AssumptionViolatedException;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;

public class DockerContainer
implements TestRule,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerContainer.class);
    private static final String DOCKER_CONTAINER = "DOCKER_CONTAINER";
    private GenericContainer<?> container;

    public static DockerContainer fromName(String imageName) {
        DockerContainer.disableDockerTestsIfDockerUnavailable();
        return new DockerContainer(new GenericContainer(imageName));
    }

    public static DockerContainer fromDockerfile(ImageFromDockerfile imageFromDockerfile) {
        DockerContainer.disableDockerTestsIfDockerUnavailable();
        return new DockerContainer(new GenericContainer((Future)imageFromDockerfile));
    }

    private static void disableDockerTestsIfDockerUnavailable() {
        try {
            DockerClientFactory.instance().client();
        }
        catch (IllegalStateException e) {
            LOGGER.error("Cannot connect to docker service", (Throwable)e);
            throw new AssumptionViolatedException("Skipping all docker tests as no Docker environment was found");
        }
    }

    public DockerContainer(GenericContainer<?> container) {
        this.container = container;
    }

    public DockerContainer withAffinityToContainer() {
        String containerEnv = System.getenv(DOCKER_CONTAINER);
        if (Strings.isNullOrEmpty((String)containerEnv)) {
            LOGGER.warn("'DOCKER_CONTAINER' environment variable not found, dockering without affinity");
            return this;
        }
        List envVariables = this.container.getEnv();
        envVariables.add("affinity:container==" + this.container);
        this.container.setEnv(envVariables);
        return this;
    }

    public DockerContainer withNetwork(Network network) {
        this.container.withNetwork(network);
        return this;
    }

    public DockerContainer withNetworkAliases(String ... aliases) {
        this.container.withNetworkAliases(aliases);
        return this;
    }

    public DockerContainer withLogConsumer(Consumer<OutputFrame> consumer) {
        this.container.withLogConsumer(consumer);
        return this;
    }

    public DockerContainer withEnv(String key, String value) {
        this.container.addEnv(key, value);
        return this;
    }

    public DockerContainer withTmpFs(Map<String, String> mapping) {
        this.container.withTmpFs(mapping);
        return this;
    }

    public DockerContainer withExposedPorts(Integer ... ports) {
        this.container.withExposedPorts(ports);
        return this;
    }

    public DockerContainer waitingFor(WaitStrategy waitStrategy) {
        this.container.waitingFor(waitStrategy);
        return this;
    }

    public DockerContainer withStartupTimeout(Duration startupTimeout) {
        this.container.withStartupTimeout(startupTimeout);
        return this;
    }

    public DockerContainer withCommands(String ... commands) {
        this.container.withCommand(commands);
        return this;
    }

    public Container.ExecResult exec(String ... command) throws IOException, InterruptedException {
        return this.container.execInContainer(command);
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public void pause() {
        DockerClientFactory.instance().client().pauseContainerCmd(this.container.getContainerInfo().getId()).exec();
    }

    public boolean isRunning() {
        return this.container.isRunning();
    }

    public void unpause() {
        DockerClientFactory.instance().client().unpauseContainerCmd(this.container.getContainerInfo().getId()).exec();
    }

    public Integer getMappedPort(int originalPort) {
        return this.container.getMappedPort(originalPort);
    }

    public String getContainerIp() {
        return this.container.getContainerInfo().getNetworkSettings().getNetworks().values().stream().map(ContainerNetwork::getIpAddress).findFirst().orElseThrow(IllegalStateException::new);
    }

    public String getHostIp() {
        return this.container.getContainerIpAddress();
    }

    public Statement apply(final Statement statement, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    DockerContainer.this.container.start();
                    statement.evaluate();
                }
                finally {
                    DockerContainer.this.container.stop();
                }
            }
        };
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.container.stop();
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.container.start();
    }
}

