/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.dockerjava.api.model.ContainerNetwork;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.function.Consumer;
import org.apache.james.util.docker.RateLimiters;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;

public class FakeSmtpExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final int SMTP_PORT = 25;
    private final GenericContainer<?> container;
    private final FakeSmtp fakeSmtp;

    public static FakeSmtpExtension withSmtpPort(Integer smtpPort) {
        GenericContainer container = FakeSmtpExtension.fakeSmtpContainer().withExposedPorts(new Integer[]{smtpPort}).withCommand(new String[]{"node", "cli", "--listen", "80", "--smtp", smtpPort.toString()});
        return new FakeSmtpExtension(container);
    }

    public static FakeSmtpExtension withDefaultPort() {
        return FakeSmtpExtension.withSmtpPort(25);
    }

    private static GenericContainer<?> fakeSmtpContainer() {
        return new GenericContainer("weave/rest-smtp-sink:latest").waitingFor(new HostPortWaitStrategy().withRateLimiter(RateLimiters.TWENTIES_PER_SECOND).withStartupTimeout(Duration.ofMinutes(1L)));
    }

    private FakeSmtpExtension(GenericContainer<?> container) {
        this.container = container;
        this.fakeSmtp = new FakeSmtp(container);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.container.start();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.container.stop();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().isAssignableFrom(FakeSmtp.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.fakeSmtp;
    }

    public static class FakeSmtp {
        public static final ResponseSpecification RESPONSE_SPECIFICATION = new ResponseSpecBuilder().build();
        private final GenericContainer<?> container;

        public FakeSmtp(GenericContainer<?> container) {
            this.container = container;
        }

        public String getContainerIp() {
            return this.container.getContainerInfo().getNetworkSettings().getNetworks().values().stream().map(ContainerNetwork::getIpAddress).findFirst().orElseThrow(IllegalStateException::new);
        }

        private String getHostIp() {
            return this.container.getContainerIpAddress();
        }

        public void assertEmailReceived(Consumer<ValidatableResponse> expectations) {
            expectations.accept((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given((RequestSpecification)this.requestSpecification(), (ResponseSpecification)RESPONSE_SPECIFICATION).get("/api/email", new Object[0])).then()).statusCode(200));
        }

        private RequestSpecification requestSpecification() {
            return new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).setPort(80).setBaseUri("http://" + this.getContainerIp()).build();
        }

        public void clean() {
            FakeSmtp.clean(this.requestSpecification());
        }

        private static void clean(RequestSpecification requestSpecification) {
            ((Response)RestAssured.given((RequestSpecification)requestSpecification, (ResponseSpecification)RESPONSE_SPECIFICATION).get("/api/email", new Object[0])).jsonPath().getList("id", String.class).stream().mapToInt(Integer::valueOf).max().ifPresent(id -> RestAssured.given((RequestSpecification)requestSpecification, (ResponseSpecification)RESPONSE_SPECIFICATION).get("/api/email/purge/" + id, new Object[0]));
        }

        public GenericContainer<?> getContainer() {
            return this.container;
        }
    }
}

