/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.net.smtp.AuthenticatingSMTPClient;
import org.apache.james.core.MailAddress;
import org.apache.james.util.Port;
import org.apache.james.utils.SMTPSendingException;
import org.apache.james.utils.SmtpSendingStep;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.ExternalResource;

public class SMTPMessageSender
extends ExternalResource
implements Closeable,
AfterEachCallback {
    private static final String DEFAULT_PROTOCOL = "TLS";
    private static final String UTF_8_ENCODING = "UTF-8";
    private final AuthenticatingSMTPClient smtpClient;
    private final String senderDomain;

    public static SMTPMessageSender noAuthentication(String ip, int port, String senderDomain) throws IOException {
        AuthenticatingSMTPClient smtpClient = SMTPMessageSender.newUtf8AuthenticatingClient();
        smtpClient.connect(ip, port);
        return new SMTPMessageSender(smtpClient, senderDomain);
    }

    public static SMTPMessageSender authentication(String ip, int port, String senderDomain, String username, String password) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, InvalidKeyException {
        AuthenticatingSMTPClient smtpClient = SMTPMessageSender.newUtf8AuthenticatingClient();
        smtpClient.connect(ip, port);
        if (!smtpClient.auth(AuthenticatingSMTPClient.AUTH_METHOD.PLAIN, username, password)) {
            throw new RuntimeException("auth failed");
        }
        return new SMTPMessageSender(smtpClient, senderDomain);
    }

    private static AuthenticatingSMTPClient newUtf8AuthenticatingClient() {
        return new AuthenticatingSMTPClient(DEFAULT_PROTOCOL, UTF_8_ENCODING);
    }

    private SMTPMessageSender(AuthenticatingSMTPClient smtpClient, String senderDomain) {
        this.smtpClient = smtpClient;
        this.senderDomain = senderDomain;
    }

    public SMTPMessageSender(String senderDomain) {
        this(SMTPMessageSender.newUtf8AuthenticatingClient(), senderDomain);
    }

    public SMTPMessageSender connect(String ip, Port port) throws IOException {
        this.smtpClient.connect(ip, port.getValue());
        return this;
    }

    public SMTPMessageSender authenticate(String username, String password) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (!this.smtpClient.auth(AuthenticatingSMTPClient.AUTH_METHOD.PLAIN, username, password)) {
            throw new SMTPSendingException(SmtpSendingStep.Authentication, this.smtpClient.getReplyString());
        }
        return this;
    }

    public SMTPMessageSender sendMessage(String from, String recipient) throws IOException {
        String message = "FROM: " + from + "\r\nsubject: test\r\n\r\ncontent\r\n.\r\n";
        return this.sendMessageWithHeaders(from, (List<String>)ImmutableList.of((Object)recipient), message);
    }

    public SMTPMessageSender sendMessageNoBracket(String from, String recipient) throws IOException {
        this.doHelo();
        this.doSetSender(from);
        this.doRCPT(recipient);
        this.doData("FROM: " + from + "\r\nsubject: test\r\n\r\ncontent\r\n.\r\n");
        return this;
    }

    public SMTPMessageSender sendMessageWithHeaders(String from, String recipient, String message) throws IOException {
        return this.sendMessageWithHeaders(from, (List<String>)ImmutableList.of((Object)recipient), message);
    }

    public SMTPMessageSender sendMessageWithHeaders(String from, List<String> recipients, String message) throws IOException {
        this.doHelo();
        this.doSetSender(from);
        recipients.forEach(Throwing.consumer(this::doAddRcpt).sneakyThrow());
        this.doData(message);
        return this;
    }

    public SMTPMessageSender sendMessageNoSender(String recipient) throws IOException {
        this.doHelo();
        this.doSetSender("");
        this.doAddRcpt(recipient);
        this.doData("subject: test\r\n\r\ncontent\r\n.\r\n");
        return this;
    }

    public SMTPMessageSender sendMessage(Mail mail) throws MessagingException, IOException {
        String from = mail.getMaybeSender().asString();
        ImmutableList recipients = (ImmutableList)mail.getRecipients().stream().map(MailAddress::asString).collect(Guavate.toImmutableList());
        String message = this.asString((Message)mail.getMessage());
        return this.sendMessageWithHeaders(from, (List<String>)recipients, message);
    }

    public SMTPMessageSender sendMessage(FakeMail.Builder mail) throws MessagingException, IOException {
        return this.sendMessage((Mail)mail.build());
    }

    private String asString(Message message) throws IOException, MessagingException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        message.writeTo((OutputStream)outputStream);
        return new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.after();
    }

    @Override
    public void close() throws IOException {
        this.smtpClient.disconnect();
    }

    private void doSetSender(String from) throws IOException {
        boolean success = this.smtpClient.setSender(from);
        if (!success) {
            throw new SMTPSendingException(SmtpSendingStep.Sender, this.smtpClient.getReplyString());
        }
    }

    private void doHelo() throws IOException {
        int code = this.smtpClient.helo(this.senderDomain);
        if (code != 250) {
            throw new SMTPSendingException(SmtpSendingStep.Helo, this.smtpClient.getReplyString());
        }
    }

    private void doRCPT(String recipient) throws IOException {
        int code = this.smtpClient.rcpt(recipient);
        if (code != 250) {
            throw new SMTPSendingException(SmtpSendingStep.RCPT, this.smtpClient.getReplyString());
        }
    }

    private void doData(String message) throws IOException {
        boolean success = this.smtpClient.sendShortMessageData(message);
        if (!success) {
            throw new SMTPSendingException(SmtpSendingStep.Data, this.smtpClient.getReplyString());
        }
    }

    private void doAddRcpt(String rcpt) throws IOException {
        boolean success = this.smtpClient.addRecipient(rcpt);
        if (!success) {
            throw new SMTPSendingException(SmtpSendingStep.RCPT, this.smtpClient.getReplyString());
        }
    }
}

