/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.commons.lang3.NotImplementedException;

public class UpdatableTickingClock
extends Clock {
    private Instant currentInstant;

    public UpdatableTickingClock(Instant currentInstant) {
        this.currentInstant = currentInstant;
    }

    @VisibleForTesting
    public void setInstant(Instant instant) {
        this.currentInstant = instant;
    }

    @Override
    public ZoneId getZone() {
        return ZoneId.of("UTC");
    }

    @Override
    public Clock withZone(ZoneId zone) {
        throw new NotImplementedException("No timezone attached to this clock");
    }

    @Override
    public Instant instant() {
        return this.currentInstant;
    }

    public synchronized void tick() {
        this.currentInstant = this.currentInstant.plusMillis(1L);
    }
}

