/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;

public abstract class AbstractAuthRequiredToRelayRcptHook
implements RcptHook {
    private static final HookResult AUTH_REQUIRED = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("530").smtpDescription(DSNStatus.getStatus(5, "7.1") + " Authentication Required").build();
    private static final HookResult RELAYING_DENIED = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("550").smtpDescription(DSNStatus.getStatus(5, "7.1") + " Requested action not taken: relaying denied").build();

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        Domain toDomain;
        if (!session.isRelayingAllowed() && !this.isLocalDomain(toDomain = rcpt.getDomain())) {
            if (session.isAuthSupported()) {
                return AUTH_REQUIRED;
            }
            return RELAYING_DENIED;
        }
        return HookResult.DECLINED;
    }

    protected abstract boolean isLocalDomain(Domain var1);
}

