/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.suppliers;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.config.SSLModule;
import org.jclouds.location.Provider;

@Singleton
public class SSLContextWithKeysSupplier
implements Supplier<SSLContext> {
    private final TrustManager[] trustManager;
    private final Supplier<Credentials> creds;

    @Inject
    SSLContextWithKeysSupplier(@Provider Supplier<Credentials> creds, HttpUtils utils, SSLModule.TrustAllCerts trustAllCerts) {
        TrustManager[] trustManagerArray;
        if (utils.trustAllCerts()) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = trustAllCerts;
        } else {
            trustManagerArray = null;
        }
        this.trustManager = trustManagerArray;
        this.creds = creds;
    }

    public SSLContext get() {
        Credentials currentCreds = (Credentials)Preconditions.checkNotNull((Object)this.creds.get(), (Object)"credential supplier returned null");
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            X509Certificate certificate = SSLContextWithKeysSupplier.getCertificate(SSLContextWithKeysSupplier.loadFile(currentCreds.identity));
            PrivateKey privateKey = SSLContextWithKeysSupplier.getKey(SSLContextWithKeysSupplier.loadFile(currentCreds.credential));
            sslContext.init(new KeyManager[]{new InMemoryKeyManager(certificate, privateKey)}, this.trustManager, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (KeyManagementException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static X509Certificate getCertificate(String certificate) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificate.getBytes(Charsets.UTF_8)));
        }
        catch (CertificateException ex) {
            throw new RuntimeException("Invalid certificate", ex);
        }
    }

    private static PrivateKey getKey(String privateKey) {
        try {
            PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKey));
            Object object = pemParser.readObject();
            if (Security.getProvider("BC") == null) {
                Security.addProvider((java.security.Provider)new BouncyCastleProvider());
            }
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            KeyPair keyPair = converter.getKeyPair((PEMKeyPair)object);
            return keyPair.getPrivate();
        }
        catch (IOException ex) {
            throw new RuntimeException("Invalid private key", ex);
        }
    }

    private static String loadFile(String filePath) throws IOException {
        return Files.toString((File)new File(filePath), (Charset)Charsets.UTF_8);
    }

    private static class InMemoryKeyManager
    extends X509ExtendedKeyManager {
        private static final String DEFAULT_ALIAS = "docker";
        private final X509Certificate certificate;
        private final PrivateKey privateKey;

        public InMemoryKeyManager(X509Certificate certificate, PrivateKey privateKey) throws IOException, CertificateException {
            this.certificate = certificate;
            this.privateKey = privateKey;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return DEFAULT_ALIAS;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return DEFAULT_ALIAS;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return new X509Certificate[]{this.certificate};
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return new String[]{DEFAULT_ALIAS};
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.privateKey;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return new String[]{DEFAULT_ALIAS};
        }
    }
}

