/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.functions.GenericResponseContainer;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class ParseServerNameToCredentialsMapFromJsonResponse
implements Function<HttpResponse, Map<String, Credentials>> {
    private final ParseJson<GenericResponseContainer<Password>> json;

    @Inject
    ParseServerNameToCredentialsMapFromJsonResponse(ParseJson<GenericResponseContainer<Password>> json) {
        this.json = json;
    }

    public Map<String, Credentials> apply(HttpResponse arg0) {
        HashMap serverNameToCredentials = Maps.newHashMap();
        for (Password password : ((GenericResponseContainer)this.json.apply(arg0)).getList()) {
            if (null == password.getServer()) continue;
            serverNameToCredentials.put(password.getServer().getName(), new Credentials(password.getUserName(), password.getPassword()));
        }
        return serverNameToCredentials;
    }

    private static class Password
    implements Comparable<Password> {
        @Named(value="username")
        private final String userName;
        private final String password;
        private final Server server;

        @ConstructorProperties(value={"username", "password", "server"})
        public Password(String userName, String password, @Nullable Server server) {
            this.userName = (String)Preconditions.checkNotNull((Object)userName, (Object)"username");
            this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password");
            this.server = server;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public Server getServer() {
            return this.server;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Password other = (Password)o;
            return Objects.equal((Object)this.userName, (Object)other.userName) && Objects.equal((Object)this.password, (Object)other.password) && Objects.equal((Object)this.server, (Object)other.server);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.userName, this.password, this.server});
        }

        @Override
        public int compareTo(Password o) {
            if (null == o.getServer()) {
                return null == this.server ? 0 : -1;
            }
            if (this.server == null) {
                return 1;
            }
            return this.server.getName().compareTo(o.getServer().getName());
        }
    }
}

