/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers.poissonarrivals;

import java.nio.DoubleBuffer;
import java.util.Random;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.timers.poissonarrivals.DurationProvider;
import org.apache.jmeter.timers.poissonarrivals.EventProducer;
import org.apache.jmeter.timers.poissonarrivals.ThroughputProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantPoissonProcessGenerator
implements EventProducer {
    private static final Logger log = LoggerFactory.getLogger(ConstantPoissonProcessGenerator.class);
    private static final double PRECISION = 1.0E-5;
    private Random rnd = new Random();
    private ThroughputProvider throughputProvider;
    private int batchSize;
    private int batchThreadDelay;
    private DurationProvider durationProvider;
    private double lastThroughput;
    private int exactLimit;
    private double allowedThroughputSurplus;
    private DoubleBuffer events;
    private double lastEvent;
    private final boolean logFirstSamples;

    public ConstantPoissonProcessGenerator(ThroughputProvider throughput, int batchSize, int batchThreadDelay, DurationProvider duration, int exactLimit, double allowedThroughputSurplus, Long seed, boolean logFirstSamples) {
        this.throughputProvider = throughput;
        this.batchSize = batchSize;
        this.batchThreadDelay = batchThreadDelay;
        this.durationProvider = duration;
        this.exactLimit = exactLimit;
        this.allowedThroughputSurplus = allowedThroughputSurplus;
        this.logFirstSamples = logFirstSamples;
        if (seed != null && seed.intValue() != 0) {
            this.rnd.setSeed(seed);
        }
        this.ensureCapacity();
    }

    private void ensureCapacity() {
        int size = (int)Math.round((this.throughputProvider.getThroughput() * (double)this.durationProvider.getDuration() + 1.0) * 3.0);
        if (this.events != null && this.events.capacity() >= size) {
            return;
        }
        this.events = DoubleBuffer.allocate(size);
    }

    public void generateNext() {
        double throughput;
        this.lastThroughput = throughput = this.throughputProvider.getThroughput();
        if (this.batchSize > 1) {
            throughput /= (double)this.batchSize;
        }
        long duration = this.durationProvider.getDuration();
        this.ensureCapacity();
        int samples = (int)Math.ceil(throughput * (double)duration);
        int i = 0;
        long t = System.currentTimeMillis();
        int loops = 0;
        double currentAllowedThroughputSurplus = samples < this.exactLimit ? 0.0 : this.allowedThroughputSurplus / 100.0;
        do {
            double time = 0.0;
            this.events.clear();
            if (throughput < 1.0E-5) {
                log.info("Throughput should exceed zero");
                break;
            }
            if (duration < 5L) {
                log.info("Duration should exceed 5 seconds");
                break;
            }
            i = 0;
            while (time < (double)duration) {
                double u = this.rnd.nextDouble();
                double delay = -Math.log(1.0 - u) / throughput;
                this.events.put((time += delay) + this.lastEvent);
                ++i;
            }
            ++loops;
        } while (System.currentTimeMillis() - t < 5000L && (i < samples + 1 || (double)((float)(i - 1 - samples) * 1.0f / (float)samples) > currentAllowedThroughputSurplus));
        t = System.currentTimeMillis() - t;
        if (t > 1000L) {
            log.warn("Spent {} ms while generating sequence of delays for {} samples, {} throughput, {} duration", new Object[]{t, samples, throughput, duration});
        }
        if (this.logFirstSamples) {
            if (log.isDebugEnabled()) {
                log.debug("Generated {} events ({} required, rate {}) in {} ms, restart was issued {} times", new Object[]{this.events.position(), samples, throughput, t, loops});
            }
            if (log.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Generated ").append(this.events.position()).append(" timings (");
                if (this.durationProvider instanceof AbstractTestElement) {
                    sb.append(((AbstractTestElement)this.durationProvider).getName());
                }
                sb.append(" ").append(samples).append(" required, rate ").append(throughput).append(", duration ").append(duration).append(", exact lim ").append(this.exactLimit).append(", i").append(i).append(") in ").append(t).append(" ms, restart was issued ").append(loops).append(" times. ");
                sb.append("First 15 events will be fired at: ");
                double prev = 0.0;
                for (i = 0; i < this.events.position() && i < 15; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    double ev = this.events.get(i);
                    sb.append(ev);
                    sb.append(" (+").append(ev - prev).append(")");
                    prev = ev;
                }
                log.info(sb.toString());
            }
        }
        this.events.flip();
        if (this.batchSize > 1) {
            DoubleBuffer tmpBuffer = DoubleBuffer.allocate(this.batchSize * this.events.remaining());
            while (this.events.hasRemaining()) {
                double curTime = this.events.get();
                for (int j = 0; j < this.batchSize; ++j) {
                    tmpBuffer.put(curTime + (double)(j * this.batchThreadDelay));
                }
            }
            tmpBuffer.flip();
            this.events = tmpBuffer;
        }
    }

    @Override
    public double next() {
        if (!this.events.hasRemaining() || !this.valuesAreEqualWithPrecision(this.throughputProvider.getThroughput(), this.lastThroughput)) {
            this.generateNext();
        }
        this.lastEvent = this.events.get();
        return this.lastEvent;
    }

    private boolean valuesAreEqualWithPrecision(double throughput, double lastThroughput) {
        return Math.abs(throughput - lastThroughput) < 1.0E-5;
    }
}

