/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.math.BigDecimal;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.jmeter.util.JMeterUtils;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.customRenderers.axisValue.PostAxisValueRenderListener;
import org.jCharts.axisChart.customRenderers.axisValue.renderers.ValueLabelPosition;
import org.jCharts.axisChart.customRenderers.axisValue.renderers.ValueLabelRenderer;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.chartData.interfaces.IAxisDataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.ClusteredBarChartProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.LabelAxisProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.util.ChartFont;
import org.jCharts.types.ChartType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxisGraph
extends JPanel {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(AxisGraph.class);
    private static final String ELLIPSIS = "...";
    private static final int ELLIPSIS_LEN = "...".length();
    protected double[][] data = null;
    protected String title;
    protected String xAxisTitle;
    protected String yAxisTitle;
    protected String yAxisLabel;
    protected int maxLength;
    protected String[] xAxisLabels;
    protected int width;
    protected int height;
    protected String[] legendLabels = new String[]{JMeterUtils.getResString((String)"aggregate_graph_legend")};
    protected int maxYAxisScale;
    protected Font titleFont;
    protected Font legendFont;
    private static final Font FONT_DEFAULT = UIManager.getDefaults().getFont("TextField.font");
    protected Font valueFont = new Font("SansSerif", 0, (int)Math.round((double)FONT_DEFAULT.getSize() * 0.6));
    protected Color[] color = new Color[]{Color.YELLOW};
    protected Color foreColor = Color.BLACK;
    protected boolean outlinesBarFlag = false;
    protected boolean showGrouping = true;
    protected boolean valueOrientation = true;
    protected int legendPlacement = 0;

    public AxisGraph() {
    }

    public AxisGraph(LayoutManager layout) {
        super(layout);
    }

    public AxisGraph(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public void setData(double[][] data) {
        this.data = data;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setXAxisTitle(String title) {
        this.xAxisTitle = title;
    }

    public void setYAxisTitle(String title) {
        this.yAxisTitle = title;
    }

    public void setXAxisLabels(String[] labels) {
        this.xAxisLabels = labels;
    }

    public void setYAxisLabels(String label) {
        this.yAxisLabel = label;
    }

    public void setLegendLabels(String[] labels) {
        this.legendLabels = labels;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getMaxYAxisScale() {
        return this.maxYAxisScale;
    }

    public void setMaxYAxisScale(int maxYAxisScale) {
        this.maxYAxisScale = maxYAxisScale;
    }

    public Color[] getColor() {
        return this.color;
    }

    public void setColor(Color[] color) {
        this.color = color;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(Color foreColor) {
        this.foreColor = foreColor;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font valueFont) {
        this.valueFont = valueFont;
    }

    public int getLegendPlacement() {
        return this.legendPlacement;
    }

    public void setLegendPlacement(int legendPlacement) {
        this.legendPlacement = legendPlacement;
    }

    public boolean isOutlinesBarFlag() {
        return this.outlinesBarFlag;
    }

    public void setOutlinesBarFlag(boolean outlinesBarFlag) {
        this.outlinesBarFlag = outlinesBarFlag;
    }

    public boolean isValueOrientation() {
        return this.valueOrientation;
    }

    public void setValueOrientation(boolean valueOrientation) {
        this.valueOrientation = valueOrientation;
    }

    public boolean isShowGrouping() {
        return this.showGrouping;
    }

    public void setShowGrouping(boolean showGrouping) {
        this.showGrouping = showGrouping;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.data != null && this.title != null && this.xAxisLabels != null && this.yAxisLabel != null && this.yAxisTitle != null) {
            this.drawSample(this.title, this.maxLength, this.xAxisLabels, this.yAxisTitle, this.legendLabels, this.data, this.width, this.height, this.color, this.legendFont, graphics);
        }
    }

    private double findMax(double[][] _data) {
        double max = _data[0][0];
        double[][] dArray = _data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray2;
            for (double d : dArray2 = dArray[i]) {
                if (!(d > max)) continue;
                max = d;
            }
        }
        return max;
    }

    private String squeeze(String input, int _maxLength) {
        if (input.length() > _maxLength) {
            return input.substring(0, _maxLength - ELLIPSIS_LEN) + ELLIPSIS;
        }
        return input;
    }

    private void drawSample(String _title, int _maxLength, String[] _xAxisLabels, String _yAxisTitle, String[] _legendLabels, double[][] _data, int _width, int _height, Color[] _color, Font legendFont, Graphics g) {
        double max = this.maxYAxisScale > 0 ? (double)this.maxYAxisScale : this.findMax(_data);
        try {
            if (_maxLength < 3) {
                _maxLength = 3;
            }
            if (_title.length() == 0) {
                _title = JMeterUtils.getResString((String)"aggregate_graph_title");
            }
            for (int i = 0; i < _xAxisLabels.length; ++i) {
                String label = _xAxisLabels[i];
                _xAxisLabels[i] = this.squeeze(label, _maxLength);
            }
            this.setPreferredSize(new Dimension(_width, _height));
            DataSeries dataSeries = new DataSeries(_xAxisLabels, null, _yAxisTitle, _title);
            ClusteredBarChartProperties clusteredBarChartProperties = new ClusteredBarChartProperties();
            clusteredBarChartProperties.setShowOutlinesFlag(this.outlinesBarFlag);
            ValueLabelRenderer valueLabelRenderer = new ValueLabelRenderer(false, false, this.showGrouping, 0);
            valueLabelRenderer.setValueLabelPosition(ValueLabelPosition.AT_TOP);
            valueLabelRenderer.setValueChartFont(new ChartFont(this.valueFont, (Paint)this.foreColor));
            valueLabelRenderer.useVerticalLabels(this.valueOrientation);
            clusteredBarChartProperties.addPostRenderEventListener((PostAxisValueRenderListener)valueLabelRenderer);
            Paint[] paints = new Paint[_color.length];
            System.arraycopy(_color, 0, paints, 0, paints.length);
            AxisChartDataSet axisChartDataSet = new AxisChartDataSet(_data, _legendLabels, paints, ChartType.BAR_CLUSTERED, (ChartTypeProperties)clusteredBarChartProperties);
            dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
            ChartProperties chartProperties = new ChartProperties();
            LabelAxisProperties xaxis = new LabelAxisProperties();
            DataAxisProperties yaxis = new DataAxisProperties();
            yaxis.setUseCommas(this.showGrouping);
            if (legendFont != null) {
                yaxis.setAxisTitleChartFont(new ChartFont(legendFont, (Paint)new Color(20)));
                yaxis.setScaleChartFont(new ChartFont(legendFont, (Paint)new Color(20)));
                xaxis.setAxisTitleChartFont(new ChartFont(legendFont, (Paint)new Color(20)));
                xaxis.setScaleChartFont(new ChartFont(legendFont, (Paint)new Color(20)));
            }
            if (this.titleFont != null) {
                chartProperties.setTitleFont(new ChartFont(this.titleFont, (Paint)new Color(0)));
            }
            try {
                BigDecimal round = BigDecimal.valueOf(max / 1000.0);
                round = round.setScale(0, 0);
                double topValue = round.doubleValue() * 1000.0;
                yaxis.setUserDefinedScale(0.0, 500.0);
                yaxis.setNumItems((int)(topValue / 500.0) + 1);
                yaxis.setShowGridLines(1);
            }
            catch (PropertyException e) {
                log.warn("Chart property exception occurred.", (Throwable)e);
            }
            AxisProperties axisProperties = new AxisProperties(xaxis, (LabelAxisProperties)yaxis);
            axisProperties.setXAxisLabelsAreVertical(true);
            LegendProperties legendProperties = new LegendProperties();
            legendProperties.setBorderStroke(null);
            legendProperties.setPlacement(this.legendPlacement);
            legendProperties.setIconBorderPaint((Paint)Color.WHITE);
            if (this.legendPlacement == 1 || this.legendPlacement == 2) {
                legendProperties.setNumColumns(1);
            }
            if (legendFont != null) {
                legendProperties.setFont(legendFont);
            }
            AxisChart axisChart = new AxisChart((IAxisDataSeries)dataSeries, chartProperties, axisProperties, legendProperties, _width, _height);
            axisChart.setGraphics2D((Graphics2D)g);
            axisChart.render();
        }
        catch (ChartDataException | PropertyException e) {
            log.warn("Exception occurred while rendering chart.", e);
        }
    }
}

