/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.graphite;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.jmeter.visualizers.backend.graphite.SocketConnectionInfos;
import org.apache.jmeter.visualizers.backend.graphite.SocketOutputStream;
import org.apache.jorphan.util.JOrphanUtils;

public class SocketOutputStreamPoolFactory
extends BaseKeyedPooledObjectFactory<SocketConnectionInfos, SocketOutputStream>
implements KeyedPooledObjectFactory<SocketConnectionInfos, SocketOutputStream> {
    private final int socketTimeoutInMillis;
    private final int socketConnectTimeoutInMillis;

    public SocketOutputStreamPoolFactory(int socketConnectTimeoutInMillis, int socketTimeoutInMillis) {
        this.socketConnectTimeoutInMillis = socketConnectTimeoutInMillis;
        this.socketTimeoutInMillis = socketTimeoutInMillis;
    }

    public PooledObject<SocketOutputStream> makeObject(SocketConnectionInfos connectionInfos) throws Exception {
        return this.wrap(this.create(connectionInfos));
    }

    public void destroyObject(SocketConnectionInfos socketConnectionInfos, PooledObject<SocketOutputStream> socketOutputStream) throws Exception {
        super.destroyObject((Object)socketConnectionInfos, socketOutputStream);
        SocketOutputStream outputStream = (SocketOutputStream)socketOutputStream.getObject();
        JOrphanUtils.closeQuietly((Closeable)outputStream);
        JOrphanUtils.closeQuietly((Socket)outputStream.getSocket());
    }

    public boolean validateObject(SocketConnectionInfos hostAndPort, PooledObject<SocketOutputStream> socketOutputStream) {
        Socket socket = ((SocketOutputStream)socketOutputStream.getObject()).getSocket();
        return socket.isConnected() && socket.isBound() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }

    public SocketOutputStream create(SocketConnectionInfos connectionInfos) throws Exception {
        Socket socket = new Socket();
        socket.setKeepAlive(true);
        socket.setSoTimeout(this.socketTimeoutInMillis);
        socket.connect(new InetSocketAddress(connectionInfos.getHost(), connectionInfos.getPort()), this.socketConnectTimeoutInMillis);
        return new SocketOutputStream(socket);
    }

    public PooledObject<SocketOutputStream> wrap(SocketOutputStream outputStream) {
        return new DefaultPooledObject((Object)outputStream);
    }
}

