/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.extractor.Extractor;
import org.apache.jmeter.extractor.JSoupExtractor;
import org.apache.jmeter.extractor.JoddExtractor;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlExtractor
extends AbstractScopedTestElement
implements PostProcessor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(HtmlExtractor.class);
    public static final String EXTRACTOR_JSOUP = "JSOUP";
    public static final String EXTRACTOR_JODD = "JODD";
    public static final String DEFAULT_EXTRACTOR = "";
    private static final String EXPRESSION = "HtmlExtractor.expr";
    private static final String ATTRIBUTE = "HtmlExtractor.attribute";
    private static final String REFNAME = "HtmlExtractor.refname";
    private static final String MATCH_NUMBER = "HtmlExtractor.match_number";
    private static final String DEFAULT = "HtmlExtractor.default";
    private static final String EXTRACTOR_IMPL = "HtmlExtractor.extractor_impl";
    private static final String REF_MATCH_NR = "_matchNr";
    private static final String UNDERSCORE = "_";
    private static final String DEFAULT_EMPTY_VALUE = "HtmlExtractor.default_empty_value";
    private Extractor extractor;

    public static String[] getImplementations() {
        return new String[]{EXTRACTOR_JSOUP, EXTRACTOR_JODD};
    }

    public void process() {
        block14: {
            JMeterContext context = this.getThreadContext();
            SampleResult previousResult = context.getPreviousResult();
            if (previousResult == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("HtmlExtractor {}: processing result", (Object)this.getName());
            }
            JMeterVariables vars = context.getVariables();
            String refName = this.getRefName();
            String expression = this.getExpression();
            String attribute = this.getAttribute();
            int matchNumber = this.getMatchNumber();
            String defaultValue = this.getDefaultValue();
            if (defaultValue.length() > 0 || this.isEmptyDefaultValue()) {
                vars.put(refName, defaultValue);
            }
            try {
                String refNameN;
                int i;
                String match;
                int prevCount;
                List<String> matches;
                block13: {
                    matches = this.extractMatchingStrings(vars, expression, attribute, matchNumber, previousResult);
                    prevCount = 0;
                    String prevString = vars.get(refName + REF_MATCH_NR);
                    if (prevString != null) {
                        vars.remove(refName + REF_MATCH_NR);
                        try {
                            prevCount = Integer.parseInt(prevString);
                        }
                        catch (NumberFormatException nfe) {
                            if (!log.isWarnEnabled()) break block13;
                            log.warn("{}: Could not parse number: '{}'.", (Object)this.getName(), (Object)prevString);
                        }
                    }
                }
                int matchCount = 0;
                if (matchNumber >= 0) {
                    match = this.getCorrectMatch(matches, matchNumber);
                    if (match != null) {
                        vars.put(refName, match);
                    }
                } else {
                    matchCount = matches.size();
                    vars.put(refName + REF_MATCH_NR, Integer.toString(matchCount));
                    for (i = 1; i <= matchCount; ++i) {
                        match = this.getCorrectMatch(matches, i);
                        if (match == null) continue;
                        refNameN = refName + UNDERSCORE + i;
                        vars.put(refNameN, match);
                    }
                }
                for (i = matchCount + 1; i <= prevCount; ++i) {
                    refNameN = refName + UNDERSCORE + i;
                    vars.remove(refNameN);
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block14;
                log.warn("{}: Error while generating result. {}", (Object)this.getName(), (Object)e.toString());
            }
        }
    }

    private String getCorrectMatch(List<String> matches, int entry) {
        int matchSize = matches.size();
        if (matchSize <= 0 || entry > matchSize) {
            return null;
        }
        if (entry == 0) {
            return matches.get(JMeterUtils.getRandomInt((int)matchSize));
        }
        return matches.get(entry - 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<String> extractMatchingStrings(JMeterVariables vars, String expression, String attribute, int matchNumber, SampleResult previousResult) {
        int found = 0;
        ArrayList<String> result = new ArrayList<String>();
        if (this.isScopeVariable()) {
            String inputString = vars.get(this.getVariableName());
            if (!StringUtils.isEmpty((CharSequence)inputString)) {
                this.getExtractorImpl().extract(expression, attribute, matchNumber, inputString, result, found, "-1");
                return Collections.unmodifiableList(result);
            }
            if (inputString != null) return Collections.emptyList();
            if (!log.isWarnEnabled()) return Collections.emptyList();
            log.warn("No variable '{}' found to process by CSS Selector Extractor '{}', skipping processing", (Object)this.getVariableName(), (Object)this.getName());
            return Collections.emptyList();
        }
        List sampleList = this.getSampleList(previousResult);
        int i = 0;
        Iterator iterator = sampleList.iterator();
        do {
            if (!iterator.hasNext()) return Collections.unmodifiableList(result);
            SampleResult sr = (SampleResult)iterator.next();
            String inputString = sr.getResponseDataAsString();
            found = this.getExtractorImpl().extract(expression, attribute, matchNumber, inputString, result, found, i > 0 ? null : Integer.toString(i));
            ++i;
        } while (matchNumber <= 0 || found != matchNumber);
        return Collections.unmodifiableList(result);
    }

    public static Extractor getExtractorImpl(String impl) {
        boolean useDefaultExtractor = DEFAULT_EXTRACTOR.equals(impl);
        if (useDefaultExtractor || EXTRACTOR_JSOUP.equals(impl)) {
            return new JSoupExtractor();
        }
        if (EXTRACTOR_JODD.equals(impl)) {
            return new JoddExtractor();
        }
        throw new IllegalArgumentException("Extractor implementation:" + impl + " is unknown");
    }

    private Extractor getExtractorImpl() {
        if (this.extractor == null) {
            this.extractor = HtmlExtractor.getExtractorImpl(this.getExtractor());
        }
        return this.extractor;
    }

    public void setExtractor(String attribute) {
        this.setProperty(EXTRACTOR_IMPL, attribute);
    }

    public String getExtractor() {
        return this.getPropertyAsString(EXTRACTOR_IMPL);
    }

    public void setAttribute(String attribute) {
        this.setProperty(ATTRIBUTE, attribute);
    }

    public String getAttribute() {
        return this.getPropertyAsString(ATTRIBUTE, DEFAULT_EXTRACTOR);
    }

    public void setExpression(String regex) {
        this.setProperty(EXPRESSION, regex);
    }

    public String getExpression() {
        return this.getPropertyAsString(EXPRESSION);
    }

    public void setRefName(String refName) {
        this.setProperty(REFNAME, refName);
    }

    public String getRefName() {
        return this.getPropertyAsString(REFNAME);
    }

    public void setMatchNumber(int matchNumber) {
        this.setProperty((JMeterProperty)new IntegerProperty(MATCH_NUMBER, matchNumber));
    }

    public void setMatchNumber(String matchNumber) {
        this.setProperty(MATCH_NUMBER, matchNumber);
    }

    public int getMatchNumber() {
        return this.getPropertyAsInt(MATCH_NUMBER);
    }

    public String getMatchNumberAsString() {
        return this.getPropertyAsString(MATCH_NUMBER);
    }

    public void setDefaultValue(String defaultValue) {
        this.setProperty(DEFAULT, defaultValue);
    }

    public void setDefaultEmptyValue(boolean defaultEmptyValue) {
        this.setProperty(DEFAULT_EMPTY_VALUE, defaultEmptyValue);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT);
    }

    public boolean isEmptyDefaultValue() {
        return this.getPropertyAsBoolean(DEFAULT_EMPTY_VALUE);
    }
}

