/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.apache.http.impl.cookie.NetscapeDraftSpecProvider;
import org.apache.http.impl.cookie.RFC2109SpecProvider;
import org.apache.http.impl.cookie.RFC2965SpecProvider;
import org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieHandler;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HC4CookieHandler
implements CookieHandler {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String DEFAULT_POLICY_NAME = "standard";
    public static final String[] AVAILABLE_POLICIES = new String[]{"standard", "standard-strict", "ignoreCookies", "netscape", "default", "rfc2109", "rfc2965", "best-match", "compatibility"};
    private final transient CookieSpec cookieSpec;
    private static PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
    private static Registry<CookieSpecProvider> registry = RegistryBuilder.create().register("best-match", (Object)new DefaultCookieSpecProvider(publicSuffixMatcher)).register("compatibility", (Object)new DefaultCookieSpecProvider(publicSuffixMatcher)).register("standard", (Object)new RFC6265CookieSpecProvider()).register("rfc2109", (Object)new RFC2109SpecProvider(publicSuffixMatcher, true)).register("rfc2965", (Object)new RFC2965SpecProvider(publicSuffixMatcher, true)).register("standard-strict", (Object)new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.STRICT, null)).register("default", (Object)new DefaultCookieSpecProvider(publicSuffixMatcher)).register("ignoreCookies", (Object)new IgnoreSpecProvider()).register("netscape", (Object)new NetscapeDraftSpecProvider()).build();

    public HC4CookieHandler(String policy) {
        if (policy.equals("default")) {
            policy = "default";
        }
        HttpClientContext context = HttpClientContext.create();
        this.cookieSpec = ((CookieSpecProvider)registry.lookup(policy)).create((HttpContext)context);
    }

    @Override
    public void addCookieFromHeader(CookieManager cookieManager, boolean checkCookies, String cookieHeader, URL url) {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug("Received Cookie: " + cookieHeader + " From: " + url.toExternalForm());
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = HTTPSamplerBase.getDefaultPort(protocol, url.getPort());
        String path = url.getPath();
        boolean isSecure = HTTPSamplerBase.isSecure(protocol);
        List cookies = null;
        CookieOrigin cookieOrigin = new CookieOrigin(host, port, path, isSecure);
        BasicHeader basicHeader = new BasicHeader("set-cookie", cookieHeader);
        try {
            cookies = this.cookieSpec.parse((Header)basicHeader, cookieOrigin);
        }
        catch (MalformedCookieException e) {
            log.error("Unable to add the cookie", (Throwable)e);
        }
        if (cookies == null) {
            return;
        }
        for (org.apache.http.cookie.Cookie cookie : cookies) {
            try {
                if (checkCookies) {
                    this.cookieSpec.validate(cookie, cookieOrigin);
                }
                Date expiryDate = cookie.getExpiryDate();
                long exp = 0L;
                if (expiryDate != null) {
                    exp = expiryDate.getTime();
                }
                Cookie newCookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.isSecure(), exp / 1000L, ((BasicClientCookie)cookie).containsAttribute("path"), ((BasicClientCookie)cookie).containsAttribute("domain"), cookie.getVersion());
                if (exp == 0L || exp >= System.currentTimeMillis()) {
                    cookieManager.add(newCookie);
                    continue;
                }
                cookieManager.removeMatchingCookies(newCookie);
                if (!debugEnabled) continue;
                log.info("Dropping expired Cookie: " + newCookie.toString());
            }
            catch (MalformedCookieException e) {
                log.warn("Not storing invalid cookie: <" + cookieHeader + "> for URL " + url + " (" + e.getLocalizedMessage() + ")");
            }
            catch (IllegalArgumentException e) {
                log.warn(cookieHeader + e.getLocalizedMessage());
            }
        }
    }

    @Override
    public String getCookieHeaderForURL(CollectionProperty cookiesCP, URL url, boolean allowVariableCookie) {
        List<org.apache.http.cookie.Cookie> c = this.getCookiesForUrl(cookiesCP, url, allowVariableCookie);
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug("Found " + c.size() + " cookies for " + url.toExternalForm());
        }
        if (c.size() <= 0) {
            return null;
        }
        List lstHdr = this.cookieSpec.formatCookies(c);
        StringBuilder sbHdr = new StringBuilder();
        for (Header header : lstHdr) {
            sbHdr.append(header.getValue());
        }
        return sbHdr.toString();
    }

    List<org.apache.http.cookie.Cookie> getCookiesForUrl(CollectionProperty cookiesCP, URL url, boolean allowVariableCookie) {
        ArrayList<org.apache.http.cookie.Cookie> cookies = new ArrayList<org.apache.http.cookie.Cookie>();
        for (JMeterProperty jMeterProperty : cookiesCP) {
            Cookie jmcookie = (Cookie)jMeterProperty.getObjectValue();
            if (allowVariableCookie) {
                jmcookie.setRunningVersion(true);
            }
            cookies.add(this.makeCookie(jmcookie));
            if (!allowVariableCookie) continue;
            jmcookie.setRunningVersion(false);
        }
        String host = url.getHost();
        String protocol = url.getProtocol();
        int port = HTTPSamplerBase.getDefaultPort(protocol, url.getPort());
        String path = url.getPath();
        boolean secure = HTTPSamplerBase.isSecure(protocol);
        CookieOrigin cookieOrigin = new CookieOrigin(host, port, path, secure);
        ArrayList<org.apache.http.cookie.Cookie> cookiesValid = new ArrayList<org.apache.http.cookie.Cookie>();
        for (org.apache.http.cookie.Cookie cookie : cookies) {
            if (!this.cookieSpec.match(cookie, cookieOrigin)) continue;
            cookiesValid.add(cookie);
        }
        return cookiesValid;
    }

    private org.apache.http.cookie.Cookie makeCookie(Cookie jmc) {
        long exp = jmc.getExpiresMillis();
        BasicClientCookie ret = new BasicClientCookie(jmc.getName(), jmc.getValue());
        ret.setDomain(jmc.getDomain());
        ret.setPath(jmc.getPath());
        ret.setExpiryDate(exp > 0L ? new Date(exp) : null);
        ret.setSecure(jmc.getSecure());
        ret.setVersion(jmc.getVersion());
        if (jmc.isDomainSpecified()) {
            ret.setAttribute("domain", jmc.getDomain());
        }
        if (jmc.isPathSpecified()) {
            ret.setAttribute("path", jmc.getPath());
        }
        return ret;
    }

    @Override
    public String getDefaultPolicy() {
        return DEFAULT_POLICY_NAME;
    }
}

