/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedList;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.util.EncoderCache;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HTTPArgument
extends Argument
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final String ALWAYS_ENCODE = "HTTPArgument.always_encode";
    private static final String USE_EQUALS = "HTTPArgument.use_equals";
    private static final EncoderCache cache = new EncoderCache(1000);

    public HTTPArgument(String name, String value, String metadata) {
        this(name, value, false);
        this.setMetaData(metadata);
    }

    public void setUseEquals(boolean ue) {
        if (ue) {
            this.setMetaData("=");
        } else {
            this.setMetaData("");
        }
        this.setProperty((JMeterProperty)new BooleanProperty(USE_EQUALS, ue));
    }

    public boolean isUseEquals() {
        boolean eq = this.getPropertyAsBoolean(USE_EQUALS);
        if (this.getMetaData().equals("=") || this.getValue() != null && this.getValue().length() > 0) {
            this.setUseEquals(true);
            return true;
        }
        return eq;
    }

    public void setAlwaysEncoded(boolean ae) {
        this.setProperty((JMeterProperty)new BooleanProperty(ALWAYS_ENCODE, ae));
    }

    public boolean isAlwaysEncoded() {
        return this.getPropertyAsBoolean(ALWAYS_ENCODE);
    }

    public HTTPArgument(String name, String value) {
        this(name, value, false);
    }

    public HTTPArgument(String name, String value, boolean alreadyEncoded) {
        this(name, value, alreadyEncoded, EncoderCache.URL_ARGUMENT_ENCODING);
    }

    public HTTPArgument(String name, String value, boolean alreadyEncoded, String contentEncoding) {
        this.setAlwaysEncoded(true);
        if (alreadyEncoded) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Decoding name, calling URLDecoder.decode with '" + name + "' and contentEncoding:" + EncoderCache.URL_ARGUMENT_ENCODING);
                }
                name = URLDecoder.decode(name, EncoderCache.URL_ARGUMENT_ENCODING);
                if (log.isDebugEnabled()) {
                    log.debug("Decoding value, calling URLDecoder.decode with '" + value + "' and contentEncoding:" + contentEncoding);
                }
                value = URLDecoder.decode(value, contentEncoding);
            }
            catch (UnsupportedEncodingException e) {
                log.error(contentEncoding + " encoding not supported!");
                throw new Error(e.toString(), e);
            }
        }
        this.setName(name);
        this.setValue(value);
        this.setMetaData("=");
    }

    public HTTPArgument(String name, String value, String metaData, boolean alreadyEncoded) {
        this(name, value, metaData, alreadyEncoded, EncoderCache.URL_ARGUMENT_ENCODING);
    }

    public HTTPArgument(String name, String value, String metaData, boolean alreadyEncoded, String contentEncoding) {
        this(name, value, alreadyEncoded, contentEncoding);
        this.setMetaData(metaData);
    }

    public HTTPArgument(Argument arg) {
        this(arg.getName(), arg.getValue(), arg.getMetaData());
    }

    public HTTPArgument() {
    }

    public void setName(String newName) {
        if (newName == null || !newName.equals(this.getName())) {
            super.setName(newName);
        }
    }

    public String getEncodedValue() {
        try {
            return this.getEncodedValue(EncoderCache.URL_ARGUMENT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Should not happen: " + e.toString());
        }
    }

    public String getEncodedValue(String contentEncoding) throws UnsupportedEncodingException {
        if (this.isAlwaysEncoded()) {
            return cache.getEncoded(this.getValue(), contentEncoding);
        }
        return this.getValue();
    }

    public String getEncodedName() {
        if (this.isAlwaysEncoded()) {
            return cache.getEncoded(this.getName());
        }
        return this.getName();
    }

    public static void convertArgumentsToHTTP(Arguments args) {
        LinkedList<Argument> newArguments = new LinkedList<Argument>();
        for (JMeterProperty jMeterProperty : args.getArguments()) {
            Argument arg = (Argument)jMeterProperty.getObjectValue();
            if (!(arg instanceof HTTPArgument)) {
                newArguments.add(new HTTPArgument(arg));
                continue;
            }
            newArguments.add(arg);
        }
        args.removeAllArguments();
        args.setArguments(newArguments);
    }
}

