/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.test;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.SampleResult;

public class JavaTest
extends AbstractJavaSamplerClient
implements Serializable {
    private static final long serialVersionUID = 240L;
    private long sleepTime;
    public static final long DEFAULT_SLEEP_TIME = 100L;
    private static final String SLEEP_NAME = "Sleep_Time";
    private long sleepMask;
    public static final long DEFAULT_SLEEP_MASK = 255L;
    private static final String DEFAULT_MASK_STRING = "0x" + Long.toHexString(255L).toUpperCase(Locale.ENGLISH);
    private static final String MASK_NAME = "Sleep_Mask";
    private String label;
    private static final String LABEL_NAME = "Label";
    private String responseMessage;
    private static final String RESPONSE_MESSAGE_DEFAULT = "";
    private static final String RESPONSE_MESSAGE_NAME = "ResponseMessage";
    private String responseCode;
    private static final String RESPONSE_CODE_DEFAULT = "";
    private static final String RESPONSE_CODE_NAME = "ResponseCode";
    private String samplerData;
    private static final String SAMPLER_DATA_DEFAULT = "";
    private static final String SAMPLER_DATA_NAME = "SamplerData";
    private String resultData;
    private static final String RESULT_DATA_DEFAULT = "";
    private static final String RESULT_DATA_NAME = "ResultData";
    private boolean success;
    private static final String SUCCESS_DEFAULT = "OK";
    private static final String SUCCESS_NAME = "Status";

    public JavaTest() {
        this.getLogger().debug(this.whoAmI() + "\tConstruct");
    }

    private void setupValues(JavaSamplerContext context) {
        this.sleepTime = context.getLongParameter(SLEEP_NAME, 100L);
        this.sleepMask = context.getLongParameter(MASK_NAME, 255L);
        this.responseMessage = context.getParameter(RESPONSE_MESSAGE_NAME, "");
        this.responseCode = context.getParameter(RESPONSE_CODE_NAME, "");
        this.success = context.getParameter(SUCCESS_NAME, SUCCESS_DEFAULT).equalsIgnoreCase(SUCCESS_DEFAULT);
        this.label = context.getParameter(LABEL_NAME, "");
        if (this.label.length() == 0) {
            this.label = context.getParameter("TestElement.name");
        }
        this.samplerData = context.getParameter(SAMPLER_DATA_NAME, "");
        this.resultData = context.getParameter(RESULT_DATA_NAME, "");
    }

    public void setupTest(JavaSamplerContext context) {
        this.getLogger().debug(this.whoAmI() + "\tsetupTest()");
        this.listParameters(context);
    }

    public Arguments getDefaultParameters() {
        Arguments params = new Arguments();
        params.addArgument(SLEEP_NAME, String.valueOf(100L));
        params.addArgument(MASK_NAME, DEFAULT_MASK_STRING);
        params.addArgument(LABEL_NAME, "");
        params.addArgument(RESPONSE_CODE_NAME, "");
        params.addArgument(RESPONSE_MESSAGE_NAME, "");
        params.addArgument(SUCCESS_NAME, SUCCESS_DEFAULT);
        params.addArgument(SAMPLER_DATA_NAME, "");
        params.addArgument(RESULT_DATA_NAME, "");
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult runTest(JavaSamplerContext context) {
        this.setupValues(context);
        SampleResult results = new SampleResult();
        results.setResponseCode(this.responseCode);
        results.setResponseMessage(this.responseMessage);
        results.setSampleLabel(this.label);
        if (this.samplerData != null && this.samplerData.length() > 0) {
            results.setSamplerData(this.samplerData);
        }
        if (this.resultData != null && this.resultData.length() > 0) {
            results.setResponseData(this.resultData, null);
            results.setDataType("text");
        }
        results.sampleStart();
        long sleep = this.sleepTime;
        if (this.sleepTime > 0L && this.sleepMask > 0L) {
            long start = System.currentTimeMillis();
            sleep = this.sleepTime + start % this.sleepMask;
        }
        try {
            if (sleep > 0L) {
                Thread.sleep(sleep);
            }
            results.setSuccessful(this.success);
        }
        catch (InterruptedException e) {
            this.getLogger().warn("JavaTest: interrupted.");
            results.setSuccessful(true);
        }
        catch (Exception e) {
            this.getLogger().error("JavaTest: error during sample", (Throwable)e);
            results.setSuccessful(false);
        }
        finally {
            results.sampleEnd();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.whoAmI() + "\trunTest()" + "\tTime:\t" + results.getTime());
            this.listParameters(context);
        }
        return results;
    }

    public void teardownTest(JavaSamplerContext context) {
        this.getLogger().debug(this.whoAmI() + "\tteardownTest()");
        this.listParameters(context);
    }

    private void listParameters(JavaSamplerContext context) {
        if (this.getLogger().isDebugEnabled()) {
            Iterator<String> argsIt = context.getParameterNamesIterator();
            while (argsIt.hasNext()) {
                String name = argsIt.next();
                this.getLogger().debug(name + "=" + context.getParameter(name));
            }
        }
    }

    private String whoAmI() {
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().toString());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }
}

