/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.Fetcher;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KafkaConsumerTest {
    private final String topic = "test";
    private final TopicPartition tp0 = new TopicPartition("test", 0);

    @Test
    public void testConstructorClose() throws Exception {
        Properties props = new Properties();
        props.setProperty("client.id", "testConstructorClose");
        props.setProperty("bootstrap.servers", "some.invalid.hostname.foo.bar:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        int oldInitCount = MockMetricsReporter.INIT_COUNT.get();
        int oldCloseCount = MockMetricsReporter.CLOSE_COUNT.get();
        try {
            KafkaConsumer kafkaConsumer = new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        }
        catch (KafkaException e) {
            Assert.assertEquals((long)(oldInitCount + 1), (long)MockMetricsReporter.INIT_COUNT.get());
            Assert.assertEquals((long)(oldCloseCount + 1), (long)MockMetricsReporter.CLOSE_COUNT.get());
            Assert.assertEquals((Object)"Failed to construct kafka consumer", (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"should have caught an exception and returned");
    }

    @Test
    public void testSubscription() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();
        consumer.subscribe(Collections.singletonList("test"));
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.subscribe(Collections.emptyList());
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.assign(Collections.singletonList(this.tp0));
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSeekNegative() {
        Properties props = new Properties();
        props.setProperty("client.id", "testSeekNegative");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.assign(Arrays.asList(new TopicPartition("nonExistTopic", 0)));
            consumer.seek(new TopicPartition("nonExistTopic", 0), -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterceptorConstructorClose() throws Exception {
        try {
            Properties props = new Properties();
            props.setProperty("bootstrap.servers", "localhost:9999");
            props.setProperty("interceptor.classes", MockConsumerInterceptor.class.getName());
            KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)0L, (long)MockConsumerInterceptor.CLOSE_COUNT.get());
            consumer.close();
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.CLOSE_COUNT.get());
        }
        finally {
            MockConsumerInterceptor.resetCounters();
        }
    }

    @Test
    public void testPause() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();
        consumer.assign(Collections.singletonList(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.pause(Collections.singleton(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.paused());
        consumer.resume(Collections.singleton(this.tp0));
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.close();
    }

    private KafkaConsumer<byte[], byte[]> newConsumer() {
        Properties props = new Properties();
        props.setProperty("client.id", "my.consumer");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        return new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test
    public void verifyHeartbeatSent() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 10000;
        MockTime time = new MockTime();
        MockClient client = new MockClient(time);
        Cluster cluster = TestUtils.singletonCluster(topic, 1);
        Node node = (Node)cluster.nodes().get(0);
        client.setNode(node);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        final KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, sessionTimeoutMs, heartbeatIntervalMs, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList(topic), new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                for (TopicPartition partition : partitions) {
                    consumer.seek(partition, 0L);
                }
            }
        });
        client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom(this.joinGroupFollowerResponse((PartitionAssignor)assignor, 1, "memberId", "leaderId", Errors.NONE.code()), coordinator);
        client.prepareResponseFrom(this.syncGroupResponse(Arrays.asList(partition), Errors.NONE.code()), coordinator);
        client.prepareResponseFrom(this.fetchResponse(partition, 0L, 0), node);
        consumer.poll(0L);
        Assert.assertEquals(Collections.singleton(partition), (Object)consumer.assignment());
        time.sleep(heartbeatIntervalMs);
        final AtomicBoolean heartbeatReceived = new AtomicBoolean(false);
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                heartbeatReceived.set(true);
                return true;
            }
        }, new HeartbeatResponse(Errors.NONE.code()).toStruct(), coordinator);
        consumer.poll(0L);
        Assert.assertTrue((boolean)heartbeatReceived.get());
    }

    @Test
    public void verifyHeartbeatSentWhenFetchedDataReady() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 10000;
        MockTime time = new MockTime();
        MockClient client = new MockClient(time);
        Cluster cluster = TestUtils.singletonCluster(topic, 1);
        Node node = (Node)cluster.nodes().get(0);
        client.setNode(node);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        final KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, sessionTimeoutMs, heartbeatIntervalMs, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList(topic), new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                for (TopicPartition partition : partitions) {
                    consumer.seek(partition, 0L);
                }
            }
        });
        client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom(this.joinGroupFollowerResponse((PartitionAssignor)assignor, 1, "memberId", "leaderId", Errors.NONE.code()), coordinator);
        client.prepareResponseFrom(this.syncGroupResponse(Arrays.asList(partition), Errors.NONE.code()), coordinator);
        consumer.poll(0L);
        client.respondFrom(this.fetchResponse(partition, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        time.sleep(heartbeatIntervalMs);
        client.prepareResponseFrom(this.fetchResponse(partition, 5L, 0), node);
        final AtomicBoolean heartbeatReceived = new AtomicBoolean(false);
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                heartbeatReceived.set(true);
                return true;
            }
        }, new HeartbeatResponse(Errors.NONE.code()).toStruct(), coordinator);
        consumer.poll(0L);
        Assert.assertTrue((boolean)heartbeatReceived.get());
    }

    @Test
    public void testCommitsFetchedDuringAssign() {
        String topic = "topic";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        long offset1 = 10000L;
        long offset2 = 20000L;
        int sessionTimeoutMs = 3000;
        int heartbeatIntervalMs = 2000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        MockClient client = new MockClient(time);
        Cluster cluster = TestUtils.singletonCluster(topic, 1);
        Node node = (Node)cluster.nodes().get(0);
        client.setNode(node);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, sessionTimeoutMs, heartbeatIntervalMs, autoCommitIntervalMs);
        consumer.assign(Arrays.asList(partition1));
        client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom(this.offsetResponse(Collections.singletonMap(partition1, offset1), Errors.NONE.code()), coordinator);
        Assert.assertEquals((long)offset1, (long)consumer.committed(partition1).offset());
        consumer.assign(Arrays.asList(partition1, partition2));
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(partition1, offset1);
        offsets.put(partition2, offset2);
        client.prepareResponseFrom(this.offsetResponse(offsets, Errors.NONE.code()), coordinator);
        Assert.assertEquals((long)offset1, (long)consumer.committed(partition1).offset());
        Assert.assertEquals((long)offset2, (long)consumer.committed(partition2).offset());
    }

    @Test
    public void testAutoCommitSentBeforePositionUpdate() {
        String topic = "topic";
        final TopicPartition partition = new TopicPartition(topic, 0);
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        MockClient client = new MockClient(time);
        Cluster cluster = TestUtils.singletonCluster(topic, 1);
        Node node = (Node)cluster.nodes().get(0);
        client.setNode(node);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        final KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, sessionTimeoutMs, heartbeatIntervalMs, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList(topic), new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                for (TopicPartition partition : partitions) {
                    consumer.seek(partition, 0L);
                }
            }
        });
        client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom(this.joinGroupFollowerResponse((PartitionAssignor)assignor, 1, "memberId", "leaderId", Errors.NONE.code()), coordinator);
        client.prepareResponseFrom(this.syncGroupResponse(Arrays.asList(partition), Errors.NONE.code()), coordinator);
        consumer.poll(0L);
        client.respondFrom(this.fetchResponse(partition, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        time.sleep(autoCommitIntervalMs);
        client.prepareResponseFrom(this.fetchResponse(partition, 5L, 0), node);
        final AtomicBoolean commitReceived = new AtomicBoolean(false);
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                OffsetCommitRequest commitRequest = new OffsetCommitRequest(request.request().body());
                OffsetCommitRequest.PartitionData partitionData = (OffsetCommitRequest.PartitionData)commitRequest.offsetData().get(partition);
                if (partitionData.offset == 0L) {
                    commitReceived.set(true);
                    return true;
                }
                return false;
            }
        }, new OffsetCommitResponse(Collections.singletonMap(partition, Errors.NONE.code())).toStruct(), coordinator);
        consumer.poll(0L);
        Assert.assertTrue((boolean)commitReceived.get());
    }

    @Test
    public void testWakeupWithFetchDataAvailable() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        MockClient client = new MockClient(time);
        Cluster cluster = TestUtils.singletonCluster(topic, 1);
        Node node = (Node)cluster.nodes().get(0);
        client.setNode(node);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        final KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, sessionTimeoutMs, heartbeatIntervalMs, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList(topic), new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                for (TopicPartition partition : partitions) {
                    consumer.seek(partition, 0L);
                }
            }
        });
        client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom(this.joinGroupFollowerResponse((PartitionAssignor)assignor, 1, "memberId", "leaderId", Errors.NONE.code()), coordinator);
        client.prepareResponseFrom(this.syncGroupResponse(Arrays.asList(partition), Errors.NONE.code()), coordinator);
        consumer.poll(0L);
        client.respondFrom(this.fetchResponse(partition, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        consumer.wakeup();
        try {
            consumer.poll(0L);
            Assert.fail();
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)consumer.position(partition));
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)5L, (long)records.count());
    }

    private Struct joinGroupFollowerResponse(PartitionAssignor assignor, int generationId, String memberId, String leaderId, short error) {
        return new JoinGroupResponse(error, generationId, assignor.name(), memberId, leaderId, Collections.emptyMap()).toStruct();
    }

    private Struct syncGroupResponse(List<TopicPartition> partitions, short error) {
        ByteBuffer buf = ConsumerProtocol.serializeAssignment((PartitionAssignor.Assignment)new PartitionAssignor.Assignment(partitions));
        return new SyncGroupResponse(error, buf).toStruct();
    }

    private Struct offsetResponse(Map<TopicPartition, Long> offsets, short error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> partitionData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, Long> entry : offsets.entrySet()) {
            partitionData.put(entry.getKey(), new OffsetFetchResponse.PartitionData(entry.getValue().longValue(), "", error));
        }
        return new OffsetFetchResponse(partitionData).toStruct();
    }

    private Struct fetchResponse(TopicPartition tp, long fetchOffset, int count) {
        MemoryRecords records = MemoryRecords.emptyRecords((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)CompressionType.NONE);
        for (int i = 0; i < count; ++i) {
            records.append(fetchOffset + (long)i, 0L, ("key-" + i).getBytes(), ("value-" + i).getBytes());
        }
        records.close();
        FetchResponse response = new FetchResponse(Collections.singletonMap(tp, new FetchResponse.PartitionData(Errors.NONE.code(), 5L, records.buffer())), 0);
        return response.toStruct();
    }

    private KafkaConsumer<String, String> newConsumer(Time time, KafkaClient client, Metadata metadata, PartitionAssignor assignor, int sessionTimeoutMs, int heartbeatIntervalMs, int autoCommitIntervalMs) {
        String clientId = "mock-consumer";
        String groupId = "mock-group";
        String metricGroupPrefix = "consumer";
        long retryBackoffMs = 100L;
        long requestTimeoutMs = 30000L;
        boolean autoCommitEnabled = true;
        boolean excludeInternalTopics = true;
        int minBytes = 1;
        int maxWaitMs = 500;
        int fetchSize = 0x100000;
        int maxPollRecords = Integer.MAX_VALUE;
        boolean checkCrcs = true;
        StringDeserializer keyDeserializer = new StringDeserializer();
        StringDeserializer valueDeserializer = new StringDeserializer();
        OffsetResetStrategy autoResetStrategy = OffsetResetStrategy.EARLIEST;
        ConsumerCoordinator.DefaultOffsetCommitCallback defaultCommitCallback = new ConsumerCoordinator.DefaultOffsetCommitCallback();
        List<PartitionAssignor> assignors = Arrays.asList(assignor);
        ConsumerInterceptors interceptors = null;
        Metrics metrics = new Metrics();
        SubscriptionState subscriptions = new SubscriptionState(autoResetStrategy);
        ConsumerNetworkClient consumerClient = new ConsumerNetworkClient(client, metadata, time, retryBackoffMs, requestTimeoutMs);
        ConsumerCoordinator consumerCoordinator = new ConsumerCoordinator(consumerClient, groupId, sessionTimeoutMs, heartbeatIntervalMs, assignors, metadata, subscriptions, metrics, metricGroupPrefix, time, retryBackoffMs, (OffsetCommitCallback)defaultCommitCallback, autoCommitEnabled, (long)autoCommitIntervalMs, interceptors, excludeInternalTopics);
        Fetcher fetcher = new Fetcher(consumerClient, minBytes, maxWaitMs, fetchSize, maxPollRecords, checkCrcs, (Deserializer)keyDeserializer, (Deserializer)valueDeserializer, metadata, subscriptions, metrics, metricGroupPrefix, time, retryBackoffMs);
        return new KafkaConsumer(clientId, consumerCoordinator, (Deserializer)keyDeserializer, (Deserializer)valueDeserializer, fetcher, interceptors, time, consumerClient, metrics, subscriptions, metadata, retryBackoffMs, requestTimeoutMs);
    }
}

