/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.AbstractIterator;
import org.junit.Assert;
import org.junit.Test;

public class AbstractIteratorTest {
    @Test
    public void testIterator() {
        int max = 10;
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < max; ++i) {
            l.add(i);
        }
        ListIterator iter = new ListIterator(l);
        for (int i = 0; i < max; ++i) {
            Integer value = i;
            Assert.assertEquals((Object)value, (Object)iter.peek());
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)value, (Object)iter.next());
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void testEmptyIterator() {
        ListIterator iter = new ListIterator(Collections.emptyList());
        iter.next();
    }

    class ListIterator<T>
    extends AbstractIterator<T> {
        private List<T> list;
        private int position = 0;

        public ListIterator(List<T> l) {
            this.list = l;
        }

        public T makeNext() {
            if (this.position < this.list.size()) {
                return this.list.get(this.position++);
            }
            return (T)this.allDone();
        }
    }
}

