/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAssignor<C, T extends Comparable<T>> {
    private static final Logger log = LoggerFactory.getLogger(TaskAssignor.class);
    private final Random rand;
    private final Map<C, ClientState<T>> states;
    private final Set<TaskPair<T>> taskPairs;
    private final int maxNumTaskPairs;
    private final ArrayList<T> tasks;
    private boolean prevAssignmentBalanced = true;
    private boolean prevClientsUnchanged = true;

    public static <C, T extends Comparable<T>> void assign(Map<C, ClientState<T>> states, Set<T> tasks, int numStandbyReplicas) {
        long seed = 0L;
        for (C client : states.keySet()) {
            seed += (long)client.hashCode();
        }
        TaskAssignor<C, T> assignor = new TaskAssignor<C, T>(states, tasks, seed);
        super.assignTasks();
        if (numStandbyReplicas > 0) {
            super.assignStandbyTasks(numStandbyReplicas);
        }
    }

    private TaskAssignor(Map<C, ClientState<T>> states, Set<T> tasks, long randomSeed) {
        this.rand = new Random(randomSeed);
        this.tasks = new ArrayList<T>(tasks);
        this.states = states;
        int avgNumTasks = tasks.size() / states.size();
        HashSet existingTasks = new HashSet();
        for (Map.Entry<C, ClientState<T>> entry : states.entrySet()) {
            Set oldTasks = entry.getValue().prevAssignedTasks;
            this.prevAssignmentBalanced = this.prevAssignmentBalanced && oldTasks.size() < 2 * avgNumTasks && oldTasks.size() > avgNumTasks / 2;
            for (Comparable task : oldTasks) {
                this.prevClientsUnchanged = this.prevClientsUnchanged && !existingTasks.contains(task);
            }
            existingTasks.addAll(oldTasks);
        }
        this.prevClientsUnchanged = this.prevClientsUnchanged && existingTasks.equals(tasks);
        int numTasks = tasks.size();
        this.maxNumTaskPairs = numTasks * (numTasks - 1) / 2;
        this.taskPairs = new HashSet<TaskPair<T>>(this.maxNumTaskPairs);
    }

    private void assignTasks() {
        this.assignTasks(true);
    }

    private void assignStandbyTasks(int numStandbyReplicas) {
        int numReplicas = Math.min(numStandbyReplicas, this.states.size() - 1);
        for (int i = 0; i < numReplicas; ++i) {
            this.assignTasks(false);
        }
    }

    private void assignTasks(boolean active) {
        Collections.shuffle(this.tasks, this.rand);
        for (Comparable task : this.tasks) {
            ClientState<Comparable> state = this.findClientFor(task);
            if (state != null) {
                state.assign(task, active);
                continue;
            }
            TaskAssignmentException ex = new TaskAssignmentException("failed to find an assignable client");
            log.error(ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    private ClientState<T> findClientFor(T task) {
        boolean checkTaskPairs = this.taskPairs.size() < this.maxNumTaskPairs;
        ClientState<T> state = this.findClientByAdditionCost(task, checkTaskPairs);
        if (state == null && checkTaskPairs) {
            state = this.findClientByAdditionCost(task, false);
        }
        if (state != null) {
            this.addTaskPairs(task, state);
        }
        return state;
    }

    private ClientState<T> findClientByAdditionCost(T task, boolean checkTaskPairs) {
        ClientState<T> candidate = null;
        double candidateAdditionCost = 0.0;
        for (ClientState<T> state : this.states.values()) {
            if (this.prevAssignmentBalanced && this.prevClientsUnchanged && state.prevAssignedTasks.contains(task)) {
                return state;
            }
            if (state.assignedTasks.contains(task) || checkTaskPairs && !state.assignedTasks.isEmpty() && !this.hasNewTaskPair(task, state)) continue;
            double additionCost = this.computeAdditionCost(task, state);
            if (candidate != null && !(additionCost < candidateAdditionCost) && (additionCost != candidateAdditionCost || !(state.cost < candidate.cost))) continue;
            candidate = state;
            candidateAdditionCost = additionCost;
        }
        return candidate;
    }

    private void addTaskPairs(T task, ClientState<T> state) {
        for (Comparable other : state.assignedTasks) {
            this.taskPairs.add(this.pair(task, other));
        }
    }

    private boolean hasNewTaskPair(T task, ClientState<T> state) {
        for (Comparable other : state.assignedTasks) {
            if (this.taskPairs.contains(this.pair(task, other))) continue;
            return true;
        }
        return false;
    }

    private double computeAdditionCost(T task, ClientState<T> state) {
        double cost = Math.floor((double)state.assignedTasks.size() / state.capacity);
        cost = state.prevAssignedTasks.contains(task) ? (state.prevActiveTasks.contains(task) ? (cost += 0.1) : (cost += 0.2)) : (cost += 0.5);
        return cost;
    }

    private TaskPair<T> pair(T task1, T task2) {
        if (task1.compareTo(task2) < 0) {
            return new TaskPair<T>(task1, task2);
        }
        return new TaskPair<T>(task2, task1);
    }

    private static class TaskPair<T> {
        final T task1;
        final T task2;

        TaskPair(T task1, T task2) {
            this.task1 = task1;
            this.task2 = task2;
        }

        public int hashCode() {
            return this.task1.hashCode() ^ this.task2.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof TaskPair) {
                TaskPair other = (TaskPair)o;
                return this.task1.equals(other.task1) && this.task2.equals(other.task2);
            }
            return false;
        }
    }
}

