/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;

class WindowStoreKeySchema
implements SegmentedBytesStore.KeySchema {
    private static final HasNextCondition ITERATOR_HAS_NEXT = new HasNextCondition(){

        @Override
        public boolean hasNext(KeyValueIterator<Bytes, ?> iterator) {
            return iterator.hasNext();
        }
    };
    private final StateSerdes<Bytes, byte[]> serdes = new StateSerdes("window-store-key-schema", Serdes.Bytes(), Serdes.ByteArray());

    WindowStoreKeySchema() {
    }

    @Override
    public Bytes upperRange(Bytes key, long to) {
        return Bytes.wrap((byte[])WindowStoreUtils.toBinaryKey(key, to, Integer.MAX_VALUE, this.serdes));
    }

    @Override
    public Bytes lowerRange(Bytes key, long from) {
        return Bytes.wrap((byte[])WindowStoreUtils.toBinaryKey(key, Math.max(0L, from), 0, this.serdes));
    }

    @Override
    public long segmentTimestamp(Bytes key) {
        return WindowStoreUtils.timestampFromBinaryKey(key.get());
    }

    @Override
    public HasNextCondition hasNextCondition(Bytes binaryKey, long from, long to) {
        return ITERATOR_HAS_NEXT;
    }

    @Override
    public List<Segment> segmentsToSearch(Segments segments, long from, long to) {
        return segments.segments(from, to);
    }
}

