/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowStore;

public abstract class AbstractStream<K> {
    protected final KStreamBuilder topology;
    protected final String name;
    protected final Set<String> sourceNodes;

    AbstractStream(KStreamBuilder topology, String name, Set<String> sourceNodes) {
        if (sourceNodes == null || sourceNodes.isEmpty()) {
            throw new IllegalArgumentException("parameter <sourceNodes> must not be null or empty");
        }
        this.topology = topology;
        this.name = name;
        this.sourceNodes = sourceNodes;
    }

    Set<String> ensureJoinableWith(AbstractStream<K> other) {
        HashSet<String> allSourceNodes = new HashSet<String>();
        allSourceNodes.addAll(this.sourceNodes);
        allSourceNodes.addAll(other.sourceNodes);
        this.topology.copartitionSources(allSourceNodes);
        return allSourceNodes;
    }

    String getOrCreateName(String queryableStoreName, String prefix) {
        String returnName = queryableStoreName != null ? queryableStoreName : this.topology.newStoreName(prefix);
        Topic.validate((String)returnName);
        return returnName;
    }

    static <T2, T1, R> ValueJoiner<T2, T1, R> reverseJoiner(final ValueJoiner<T1, T2, R> joiner) {
        return new ValueJoiner<T2, T1, R>(){

            @Override
            public R apply(T2 value2, T1 value1) {
                return joiner.apply(value1, value2);
            }
        };
    }

    static <T, K> StateStoreSupplier<KeyValueStore> keyValueStore(Serde<K> keySerde, Serde<T> aggValueSerde, String storeName) {
        Objects.requireNonNull(storeName, "storeName can't be null");
        Topic.validate((String)storeName);
        return AbstractStream.storeFactory(keySerde, aggValueSerde, storeName).build();
    }

    static <W extends Window, T, K> StateStoreSupplier<WindowStore> windowedStore(Serde<K> keySerde, Serde<T> aggValSerde, Windows<W> windows, String storeName) {
        Objects.requireNonNull(storeName, "storeName can't be null");
        Topic.validate((String)storeName);
        return AbstractStream.storeFactory(keySerde, aggValSerde, storeName).windowed(windows.size(), windows.maintainMs(), windows.segments, false).build();
    }

    static <T, K> Stores.PersistentKeyValueFactory<K, T> storeFactory(Serde<K> keySerde, Serde<T> aggValueSerde, String storeName) {
        return Stores.create(storeName).withKeys(keySerde).withValues(aggValueSerde).persistent().enableCaching();
    }
}

