/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.ProcessorContext;

class KStreamKTableJoinProcessor<K1, K2, V1, V2, R>
extends AbstractProcessor<K1, V1> {
    private final KTableValueGetter<K2, V2> valueGetter;
    private final KeyValueMapper<? super K1, ? super V1, ? extends K2> keyMapper;
    private final ValueJoiner<? super V1, ? super V2, ? extends R> joiner;
    private final boolean leftJoin;

    KStreamKTableJoinProcessor(KTableValueGetter<K2, V2> valueGetter, KeyValueMapper<? super K1, ? super V1, ? extends K2> keyMapper, ValueJoiner<? super V1, ? super V2, ? extends R> joiner, boolean leftJoin) {
        this.valueGetter = valueGetter;
        this.keyMapper = keyMapper;
        this.joiner = joiner;
        this.leftJoin = leftJoin;
    }

    @Override
    public void init(ProcessorContext context) {
        super.init(context);
        this.valueGetter.init(context);
    }

    @Override
    public void process(K1 key, V1 value) {
        if (key != null && value != null) {
            V2 value2 = this.valueGetter.get(this.keyMapper.apply(key, value));
            if (this.leftJoin || value2 != null) {
                this.context().forward(key, this.joiner.apply(value, value2));
            }
        }
    }
}

