/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.PrintForeachAction;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;

public class KStreamPrint<K, V>
implements ProcessorSupplier<K, V> {
    private final Serde<?> keySerde;
    private final Serde<?> valueSerde;
    private final ForeachAction<K, V> action;

    public KStreamPrint(ForeachAction<K, V> action, Serde<?> keySerde, Serde<?> valueSerde) {
        this.action = action;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamPrintProcessor(this.keySerde, this.valueSerde);
    }

    private class KStreamPrintProcessor
    extends AbstractProcessor<K, V> {
        private Serde<?> keySerde;
        private Serde<?> valueSerde;
        private ProcessorContext context;

        public KStreamPrintProcessor(Serde<?> keySerde, Serde<?> valueSerde) {
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
        }

        @Override
        public void init(ProcessorContext context) {
            this.context = context;
            if (this.keySerde == null) {
                this.keySerde = context.keySerde();
            }
            if (this.valueSerde == null) {
                this.valueSerde = context.valueSerde();
            }
        }

        @Override
        public void process(K key, V value) {
            Object deKey = this.maybeDeserialize(key, this.keySerde.deserializer());
            Object deValue = this.maybeDeserialize(value, this.valueSerde.deserializer());
            KStreamPrint.this.action.apply(deKey, deValue);
        }

        private Object maybeDeserialize(Object keyOrValue, Deserializer<?> deserializer) {
            if (keyOrValue instanceof byte[]) {
                return deserializer.deserialize(this.context.topic(), (byte[])keyOrValue);
            }
            return keyOrValue;
        }

        @Override
        public void close() {
            if (KStreamPrint.this.action instanceof PrintForeachAction) {
                ((PrintForeachAction)KStreamPrint.this.action).close();
            }
        }
    }
}

