/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.processor.StreamPartitioner;

public class WindowedStreamPartitioner<K, V>
implements StreamPartitioner<Windowed<K>, V> {
    private final String topic;
    private final WindowedSerializer<K> serializer;

    WindowedStreamPartitioner(String topic, WindowedSerializer<K> serializer) {
        this.topic = topic;
        this.serializer = serializer;
    }

    @Override
    public Integer partition(Windowed<K> windowedKey, V value, int numPartitions) {
        byte[] keyBytes = this.serializer.serializeBaseKey(this.topic, windowedKey);
        return Utils.toPositive((int)Utils.murmur2((byte[])keyBytes)) % numPartitions;
    }
}

