/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import kafka.api.ProducerRequest;
import kafka.network.Acceptor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.producer.SyncProducerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cU8dW\u0016$8+\u001a:wKJ$Vm\u001d;\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\b1\u0001\u0011\r\u0011\"\u0001\u001a\u0003\u0015\u0001(o\u001c9t+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011)H/\u001b7\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB\u0012\u0001A\u0003%!$\u0001\u0004qe>\u00048\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003\u0019\u0019wN\u001c4jOV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\t\u000511/\u001a:wKJL!\u0001L\u0015\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0007]\u0001\u0001\u000b\u0011B\u0014\u0002\u000f\r|gNZ5hA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014aB7fiJL7m]\u000b\u0002eA\u00111GO\u0007\u0002i)\u0011\u0001'\u000e\u0006\u0003m]\naaY8n[>t'BA\u00039\u0015\tId\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003wQ\u0012q!T3ue&\u001c7\u000f\u0003\u0004>\u0001\u0001\u0006IAM\u0001\t[\u0016$(/[2tA!9!\u0006\u0001b\u0001\n\u0003yT#\u0001!\u0011\u0005Y\t\u0015B\u0001\"\u0003\u00051\u0019vnY6fiN+'O^3s\u0011\u0019!\u0005\u0001)A\u0005\u0001\u000691/\u001a:wKJ\u0004\u0003\"\u0002$\u0001\t\u00039\u0015aC:f]\u0012\u0014V-];fgR$B\u0001\u0013(W7B\u0011\u0011\nT\u0007\u0002\u0015*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\u0015\n!QK\\5u\u0011\u0015yU\t1\u0001Q\u0003\u0019\u0019xnY6fiB\u0011\u0011\u000bV\u0007\u0002%*\u00111KH\u0001\u0004]\u0016$\u0018BA+S\u0005\u0019\u0019vnY6fi\")q+\u0012a\u00011\u0006\u0011\u0011\u000e\u001a\t\u0003\u0013fK!A\u0017&\u0003\u000bMCwN\u001d;\t\u000bq+\u0005\u0019A/\u0002\u000fI,\u0017/^3tiB\u0019\u0011J\u00181\n\u0005}S%!B!se\u0006L\bCA%b\u0013\t\u0011'J\u0001\u0003CsR,\u0007\"\u00023\u0001\t\u0003)\u0017a\u0004:fG\u0016Lg/\u001a*fgB|gn]3\u0015\u0005u3\u0007\"B(d\u0001\u0004\u0001\u0006\"\u00025\u0001\t\u0003I\u0017A\u00049s_\u000e,7o\u001d*fcV,7\u000f\u001e\u000b\u0003\u0011*DQa[4A\u00021\fqa\u00195b]:,G\u000e\u0005\u0002\u0017[&\u0011aN\u0001\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0011\u0015\u0001\b\u0001\"\u0001r\u0003\u001d\u0019wN\u001c8fGR$2\u0001\u0015:u\u0011\u001d\u0019x\u000e%AA\u0002\u0001\u000b\u0011a\u001d\u0005\bk>\u0004\n\u00111\u0001w\u0003!\u0001(o\u001c;pG>d\u0007CA<z\u001b\u0005A(BA;6\u0013\tQ\bP\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\")A\u0010\u0001C\u0001{\u000691\r\\3b]V\u0004H#\u0001%)\u0005m|\b\u0003BA\u0001\u0003\u000bi!!a\u0001\u000b\u0005-q\u0011\u0002BA\u0004\u0003\u0007\u0011Q!\u00114uKJDq!a\u0003\u0001\t\u0013\ti!\u0001\u000bqe>$WoY3s%\u0016\fX/Z:u\u0005f$Xm]\u000b\u0002;\"1\u0011\u0011\u0003\u0001\u0005\u0002u\fQb]5na2,'+Z9vKN$\b\u0006BA\b\u0003+\u0001B!!\u0001\u0002\u0018%!\u0011\u0011DA\u0002\u0005\u0011!Vm\u001d;\t\r\u0005u\u0001\u0001\"\u0001~\u0003]!xn\u001c\"jOJ+\u0017/^3ti&\u001b(+\u001a6fGR,G\r\u000b\u0003\u0002\u001c\u0005U\u0001BBA\u0012\u0001\u0011\u0005Q0\u0001\u000euKN$8k\\2lKR\u001c8\t\\8tK>s7\u000b[;uI><h\u000e\u000b\u0003\u0002\"\u0005U\u0001BBA\u0015\u0001\u0011\u0005Q0A\fuKN$X*\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja\"\"\u0011qEA\u000b\u0011\u0019\ty\u0003\u0001C\u0001{\u0006\u0001C/Z:u\u001b\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\nU(wKJ\u0014\u0018\u000eZ3tQ\u0011\ti#!\u0006\t\r\u0005U\u0002\u0001\"\u0001~\u0003M!Xm\u001d;Tg2\u001cvnY6fiN+'O^3sQ\u0011\t\u0019$!\u0006\t\r\u0005m\u0002\u0001\"\u0001~\u0003Q!Xm\u001d;TKN\u001c\u0018n\u001c8Qe&t7-\u001b9bY\"\"\u0011\u0011HA\u000b\u0011%\t\t\u0005AI\u0001\n\u0003\t\u0019%A\td_:tWm\u0019;%I\u00164\u0017-\u001e7uIE*\"!!\u0012+\u0007\u0001\u000b9e\u000b\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!C;oG\",7m[3e\u0015\r\t\u0019FS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA,\u0003\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tY\u0006AI\u0001\n\u0003\ti&A\td_:tWm\u0019;%I\u00164\u0017-\u001e7uII*\"!a\u0018+\u0007Y\f9\u0005")
public class SocketServerTest
extends JUnitSuite {
    private final Properties props;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final SocketServer server;

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SocketServer server() {
        return this.server;
    }

    public void sendRequest(Socket socket, short id, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length + 2);
        outgoing.writeShort(id);
        outgoing.write(request);
        outgoing.flush();
    }

    public byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public void processRequest(RequestChannel channel) {
        RequestChannel.Request request = channel.receiveRequest();
        ByteBuffer byteBuffer = ByteBuffer.allocate(request.requestObj().sizeInBytes());
        request.requestObj().writeTo(byteBuffer);
        byteBuffer.rewind();
        NetworkSend send = new NetworkSend(request.connectionId(), new ByteBuffer[]{byteBuffer});
        channel.sendResponse(new RequestChannel.Response(request.processor(), request, (Send)send));
    }

    public Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", this.server().boundPort(protocol));
    }

    public SocketServer connect$default$1() {
        return this.server();
    }

    public SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    @After
    public void cleanup() {
        this.metrics().close();
        this.server().shutdown();
    }

    private byte[] producerRequestBytes() {
        int correlationId = -1;
        String clientId = SyncProducerConfig$.MODULE$.DefaultClientId();
        int ackTimeoutMs = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        short ack = SyncProducerConfig$.MODULE$.DefaultRequiredAcks();
        ProducerRequest emptyRequest = new ProducerRequest(correlationId, clientId, ack, ackTimeoutMs, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        ByteBuffer byteBuffer = ByteBuffer.allocate(emptyRequest.sizeInBytes());
        emptyRequest.writeTo(byteBuffer);
        byteBuffer.rewind();
        byte[] serializedBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(serializedBytes);
        return serializedBytes;
    }

    @Test
    public void simpleRequest() {
        SecurityProtocol x$18 = SecurityProtocol.PLAINTEXT;
        SocketServer x$19 = this.connect$default$1();
        Socket plainSocket = this.connect(x$19, x$18);
        SecurityProtocol x$20 = SecurityProtocol.TRACE;
        SocketServer x$21 = this.connect$default$1();
        Socket traceSocket = this.connect(x$21, x$20);
        byte[] serializedBytes = this.producerRequestBytes();
        this.sendRequest(plainSocket, (short)0, serializedBytes);
        this.processRequest(this.server().requestChannel());
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(plainSocket)).toSeq());
        this.sendRequest(traceSocket, (short)0, serializedBytes);
        this.processRequest(this.server().requestChannel());
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(traceSocket)).toSeq());
    }

    @Test
    public void tooBigRequestIsRejected() {
        byte[] tooManyBytes = new byte[Predef$.MODULE$.Integer2int(this.server().config().socketRequestMaxBytes()) + 1];
        new Random().nextBytes(tooManyBytes);
        Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());
        this.sendRequest(socket, (short)0, tooManyBytes);
        try {
            this.receiveResponse(socket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSocketsCloseOnShutdown() {
        SecurityProtocol x$22 = SecurityProtocol.PLAINTEXT;
        SocketServer x$23 = this.connect$default$1();
        Socket plainSocket = this.connect(x$23, x$22);
        SecurityProtocol x$24 = SecurityProtocol.TRACE;
        SocketServer x$25 = this.connect$default$1();
        Socket traceSocket = this.connect(x$25, x$24);
        byte[] bytes = new byte[40];
        this.sendRequest(plainSocket, (short)0, bytes);
        this.sendRequest(traceSocket, (short)0, bytes);
        this.processRequest(this.server().requestChannel());
        this.server().acceptors().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Acceptor acceptor) {
                Assert.assertFalse((boolean)acceptor.serverChannel().socket().isClosed());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        this.server().shutdown();
        byte[] largeChunkOfBytes = new byte[1000000];
        try {
            this.sendRequest(plainSocket, (short)0, largeChunkOfBytes);
            throw this.fail("expected exception when writing to closed plain socket");
        }
        catch (IOException iOException) {
            try {
                this.sendRequest(traceSocket, (short)0, largeChunkOfBytes);
                throw this.fail("expected exception when writing to closed trace socket");
            }
            catch (IOException iOException2) {
                return;
            }
        }
    }

    @Test
    public void testMaxConnectionsPerIp() {
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(this.server().config().maxConnectionsPerIp())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;

            public final Socket apply(int x$1) {
                return this.$outer.connect(this.$outer.connect$default$1(), this.$outer.connect$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Socket conn = this.connect(this.connect$default$1(), this.connect$default$2());
        conn.setSoTimeout(3000);
        Assert.assertEquals((long)-1L, (long)conn.getInputStream().read());
        conn.close();
        InetAddress address = ((Socket)conns.head()).getInetAddress();
        ((Socket)conns.head()).close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, conns, address){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final IndexedSeq conns$1;
            private final InetAddress address$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server().connectionCount(this.address$1) < this.conns$1.length();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.conns$1 = conns$1;
                this.address$1 = address$1;
            }
        }, "Failed to decrement connection count after close", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Socket conn2 = this.connect(this.connect$default$1(), this.connect$default$2());
        byte[] serializedBytes = this.producerRequestBytes();
        this.sendRequest(conn2, (short)0, serializedBytes);
        RequestChannel.Request request = this.server().requestChannel().receiveRequest(2000L);
        Assert.assertNotNull((Object)request);
        conn2.close();
        ((IterableLike)conns.tail()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$2) {
                x$2.close();
            }
        });
    }

    @Test
    public void testMaxConnectionsPerIPOverrides() {
        int overrideNum = 6;
        Map overrides = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"localhost"), (Object)BoxesRunTime.boxToInteger((int)overrideNum))}));
        int x$26 = 0;
        String x$27 = TestUtils$.MODULE$.MockZkConnect();
        int x$28 = 0;
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$31 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$32 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        boolean x$33 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$34 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        int x$35 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        boolean x$36 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        int x$37 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        boolean x$38 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        int x$39 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        Properties overrideProps = TestUtils$.MODULE$.createBrokerConfig(x$26, x$27, x$29, x$30, x$28, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39);
        Metrics serverMetrics = new Metrics();
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(overrideProps), serverMetrics, (Time)new SystemTime());
        try {
            overrideServer.startup();
            IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), overrideNum).map((Function1)new Serializable(this, overrideServer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final SocketServer overrideServer$1;

                public final Socket apply(int i) {
                    return this.$outer.connect(this.overrideServer$1, this.$outer.connect$default$2());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.overrideServer$1 = overrideServer$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            Socket conn = this.connect(overrideServer, this.connect$default$2());
            conn.setSoTimeout(3000);
            Assert.assertEquals((long)-1L, (long)conn.getInputStream().read());
            conn.close();
            conns.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Socket x$3) {
                    x$3.close();
                }
            });
            return;
        }
        finally {
            overrideServer.shutdown();
            serverMetrics.close();
        }
    }

    @Test
    public void testSslSocketServer() {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        int x$40 = 0;
        String x$41 = TestUtils$.MODULE$.MockZkConnect();
        Some x$42 = new Some((Object)SecurityProtocol.SSL);
        Some x$43 = new Some((Object)trustStoreFile);
        boolean x$44 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$45 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$46 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        boolean x$47 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$48 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        int x$49 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        boolean x$50 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        int x$51 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        boolean x$52 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        int x$53 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        Properties overrideProps = TestUtils$.MODULE$.createBrokerConfig(x$40, x$41, x$44, x$45, x$46, (Option<SecurityProtocol>)x$42, (Option<File>)x$43, x$47, x$48, x$49, x$50, x$51, x$52, x$53);
        overrideProps.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:0");
        Metrics serverMetrics = new Metrics();
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(overrideProps), serverMetrics, (Time)new SystemTime());
        overrideServer.startup();
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, (TrustManager[])((Object[])new TrustManager[]{TestUtils$.MODULE$.trustAllCerts()}), new SecureRandom());
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket("localhost", overrideServer.boundPort(SecurityProtocol.SSL));
            sslSocket.setNeedClientAuth(false);
            int correlationId = -1;
            String clientId = SyncProducerConfig$.MODULE$.DefaultClientId();
            int ackTimeoutMs = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
            short ack = SyncProducerConfig$.MODULE$.DefaultRequiredAcks();
            ProducerRequest emptyRequest = new ProducerRequest(correlationId, clientId, ack, ackTimeoutMs, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
            ByteBuffer byteBuffer = ByteBuffer.allocate(emptyRequest.sizeInBytes());
            emptyRequest.writeTo(byteBuffer);
            byteBuffer.rewind();
            byte[] serializedBytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(serializedBytes);
            this.sendRequest(sslSocket, (short)0, serializedBytes);
            this.processRequest(overrideServer.requestChannel());
            Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(sslSocket)).toSeq());
            sslSocket.close();
            return;
        }
        finally {
            overrideServer.shutdown();
            serverMetrics.close();
        }
    }

    @Test
    public void testSessionPrincipal() {
        Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());
        byte[] bytes = new byte[40];
        this.sendRequest(socket, (short)0, bytes);
        Assert.assertEquals((Object)KafkaPrincipal.ANONYMOUS, (Object)this.server().requestChannel().receiveRequest().session().principal());
        socket.close();
    }

    public SocketServerTest() {
        int x$4 = 0;
        String x$5 = TestUtils$.MODULE$.MockZkConnect();
        int x$6 = 0;
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        this.props = TestUtils$.MODULE$.createBrokerConfig(x$4, x$5, x$7, x$8, x$6, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        this.props().put("listeners", "PLAINTEXT://localhost:0,TRACE://localhost:0");
        this.props().put("num.network.threads", "1");
        this.props().put("socket.send.buffer.bytes", "300000");
        this.props().put("socket.receive.buffer.bytes", "300000");
        this.props().put("queued.max.requests", "50");
        this.props().put("socket.request.max.bytes", "50");
        this.props().put("max.connections.per.ip", "5");
        this.props().put("connections.max.idle.ms", "60000");
        this.config = KafkaConfig$.MODULE$.fromProps(this.props());
        this.metrics = new Metrics();
        this.server = new SocketServer(this.config(), this.metrics(), (Time)new SystemTime());
        this.server().startup();
    }
}

