/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u000f\t)\u0003+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\!mO>\u0014\u0018\u000e\u001e5ngR+7\u000f\u001e\u0006\u0003\u0007\u0011\t!bY8oiJ|G\u000e\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u001dA\u0002\u00011A\u0005\ne\t\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u+\u0005Q\u0002C\u0001\f\u001c\u0013\ta\"AA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqRDqA\b\u0001A\u0002\u0013%q$A\u000bd_:$(o\u001c7mKJ\u001cuN\u001c;fqR|F%Z9\u0015\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSRDqaJ\u000f\u0002\u0002\u0003\u0007!$A\u0002yIEBa!\u000b\u0001!B\u0013Q\u0012AE2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\u0002BQa\u000b\u0001\u0005\u00021\nQa]3u+B$\u0012\u0001\t\u0015\u0003U9\u0002\"aL\u0019\u000e\u0003AR!a\u0003\b\n\u0005I\u0002$A\u0002\"fM>\u0014X\rC\u00035\u0001\u0011\u0005A&\u0001\u0012uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003gY\u0002\"aL\u001c\n\u0005a\u0002$\u0001\u0002+fgRDQA\u000f\u0001\u0005\u00021\nQ\n^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>tG*Y:u\u0013N\u0014xJ\u001a4mS:,WK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tG)[:bE2,G\r\u000b\u0002:m!)Q\b\u0001C\u0001Y\u0005aE/Z:u\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:d\u0015m\u001d;JgJ|eM\u001a7j]\u0016,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012D#\u0001\u0010\u001c\t\u000b\u0001\u0003A\u0011\u0001\u0017\u0002GQ,7\u000f\u001e*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u0012qH\u000e\u0005\u0006\u0007\u0002!\t\u0001L\u00011i\u0016\u001cHOU3bgNLwM\u001c)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o/&$\bNT8MSZ,\u0017j\u001d:)\u0005\t3\u0004\"\u0002$\u0001\t\u0003a\u0013a\f;fgR\u0014V-Y:tS\u001et\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\,ji\",U\u000e\u001d;z\u0013N\u0014\bFA#7\u0011\u0015I\u0005\u0001\"\u0001-\u0003-\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007F\u0001%7\u0011\u0015a\u0005\u0001\"\u0001-\u0003\u001d#Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007K]3gKJ\u0014X\r\u001a*fa2L7-Y%o\u0013N\u0014hj\u001c;MSZ,\u0007FA&7\u0011\u0015y\u0005\u0001\"\u0001-\u0003\u001d#Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007K]3gKJ\u0014X\r\u001a*fa2L7-\u0019(pi&s\u0017j\u001d:MSZ,\u0007F\u0001(7\u0011\u0015\u0011\u0006\u0001\"\u0001-\u0003)#Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007K]3gKJ\u0014X\r\u001a*fa2L7-\u0019(pi&s\u0017j\u001d:O_Rd\u0015N^3)\u0005E3\u0004\"B+\u0001\t\u0003a\u0013!\f;fgR\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u0012AK\u000e\u0005\u00061\u0002!\t\u0001L\u0001Ai\u0016\u001cHoQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]B\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>tG*Y:u\u0013N\u00148\u000b[;ui&tw\rR8x]\"\u0012qK\u000e\u0005\u00067\u0002!\t\u0001L\u0001Ji\u0016\u001cHoQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]B\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0017\t\u001c7JgJ\u001c\u0016.\\;mi\u0006tWm\\;tYf\u001c\u0006.\u001e;e_^t\u0007F\u0001.7\u0001")
public class PartitionLeaderElectionAlgorithmsTest
extends JUnitSuite {
    private ControllerContext controllerContext = null;

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        ControllerStats qual$1 = this.controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    @Test
    public void testOfflinePartitionLeaderElection() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment2, isr, liveReplicas, false, this.controllerContext());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionDisabled() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment2, isr, liveReplicas, false, this.controllerContext());
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
        Assert.assertEquals((long)0L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionEnabled() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment2, isr, liveReplicas, true, this.controllerContext());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
        Assert.assertEquals((long)1L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testReassignPartitionLeaderElection() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithNoLiveIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithEmptyIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElection() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment2, isr, liveReplicas);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaInIsrNotLive() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment2, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrLive() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment2, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrNotLive() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment2, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElection() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment2, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionLastIsrShuttingDown() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment2, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionAllIsrSimultaneouslyShutdown() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment2, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }
}

