/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtDC\u0001\u000f\u001e!\t1\u0002\u0001C\u0003\u00043\u0001\u0007Q\u0003C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001\"!\t1\"%\u0003\u0002$\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r\u0015\u0002\u0001\u0015!\u0003\"\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0006\u0005\u0002\nU%\u00111F\u0003\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%\u0011&A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003\u001dQ8.\u0016;jYN,\u0012!\r\t\u0003\u001fIJ!a\r\t\u0003\u000fi[W\u000b^5mg\"1Q\u0007\u0001Q\u0001\nE\n\u0001B_6Vi&d7\u000f\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016,\u0012!\u000f\t\u0005u}\nu)D\u0001<\u0015\taT(A\u0004nkR\f'\r\\3\u000b\u0005yR\u0011AC2pY2,7\r^5p]&\u0011\u0001i\u000f\u0002\u0004\u001b\u0006\u0004\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\u0005\u0003\u0019\u0019w.\\7p]&\u0011ai\u0011\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\fI\u0013\tI%A\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\r-\u0003\u0001\u0015!\u0003:\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0003bB'\u0001\u0005\u0004%IAT\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001P!\t1\u0002+\u0003\u0002R\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007BB*\u0001A\u0003%q*A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u000279|w\n\u001d)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8s+\u00059\u0006C\u0001\fY\u0013\tI&A\u0001\nO_>\u0003H*Z1eKJ\u001cV\r\\3di>\u0014\bBB.\u0001A\u0003%q+\u0001\u000fo_>\u0003\b+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0011\t\u000fu\u0003!\u0019!C\u0005=\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0003}\u0003\"\u0001Y2\u000f\u0005Y\t\u0017B\u00012\u0003\u0003=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018B\u00013f\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0006\u0003E\nAaa\u001a\u0001!\u0002\u0013y\u0016AE:uCR,7\t[1oO\u0016dunZ4fe\u0002BQ!\u001b\u0001\u0005\u0002)\fqa\u001d;beR,\b\u000fF\u0001l!\tIA.\u0003\u0002n\u0015\t!QK\\5u\u0011\u0015y\u0007\u0001\"\u0001k\u0003!\u0019\b.\u001e;e_^t\u0007\"B9\u0001\t\u0003Q\u0017!\t;sS\u001e<WM](oY&tW\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u00115b]\u001e,\u0007\"B:\u0001\t\u0003!\u0018!\u00059beRLG/[8og&s7\u000b^1uKR\u0011Q/\u001f\t\u0004m^\fU\"A\u001f\n\u0005al$aA*fi\")!P\u001da\u0001\u000f\u0006)1\u000f^1uK\")A\u0010\u0001C\u0001{\u0006\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)!Yg0!\u0001\u0002\u0006\u0005=\u0001\"B@|\u0001\u0004)\u0018A\u00039beRLG/[8og\"1\u00111A>A\u0002\u001d\u000b1\u0002^1sO\u0016$8\u000b^1uK\"I\u0011qA>\u0011\u0002\u0003\u0007\u0011\u0011B\u0001\u000fY\u0016\fG-\u001a:TK2,7\r^8s!\r1\u00121B\u0005\u0004\u0003\u001b\u0011!a\u0006)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8s\u0011%\t\tb\u001fI\u0001\u0002\u0004\t\u0019\"A\u0005dC2d'-Y2lgB\u0019a#!\u0006\n\u0007\u0005]!AA\u0005DC2d'-Y2lg\"9\u00111\u0004\u0001\u0005\n\u0005u\u0011!\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKRY1.a\b\u0002:\u0005u\u0012qHA!\u0011!\t\t#!\u0007A\u0002\u0005\r\u0012!\u0002;pa&\u001c\u0007\u0003BA\u0013\u0003gqA!a\n\u00020A\u0019\u0011\u0011\u0006\u0006\u000e\u0005\u0005-\"bAA\u0017\r\u00051AH]8pizJ1!!\r\u000b\u0003\u0019\u0001&/\u001a3fM&!\u0011QGA\u001c\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0007\u0006\t\u000f\u0005m\u0012\u0011\u0004a\u0001S\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0003\u0007\tI\u00021\u0001H\u0011!\t9!!\u0007A\u0002\u0005%\u0001\u0002CA\t\u00033\u0001\r!a\u0005\t\r\u0005\u0015\u0003\u0001\"\u0003k\u0003aIg.\u001b;jC2L'0\u001a)beRLG/[8o'R\fG/\u001a\u0005\b\u0003\u0013\u0002A\u0011BA&\u0003U\t7o]3siZ\u000bG.\u001b3Ue\u0006t7/\u001b;j_:$Ra[A'\u0003#Bq!a\u0014\u0002H\u0001\u0007\u0011)A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:Dq!a\u0001\u0002H\u0001\u0007q\tC\u0004\u0002V\u0001!I!a\u0016\u0002E%t\u0017\u000e^5bY&TX\rT3bI\u0016\u0014\u0018I\u001c3JgJ4uN\u001d)beRLG/[8o)\rY\u0017\u0011\f\u0005\b\u0003\u001f\n\u0019\u00061\u0001B\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\nq#\u001a7fGRdU-\u00193fe\u001a{'\u000fU1si&$\u0018n\u001c8\u0015\u000f-\f\t'a\u0019\u0002f!A\u0011\u0011EA.\u0001\u0004\t\u0019\u0003C\u0004\u0002<\u0005m\u0003\u0019A\u0015\t\u0011\u0005\u001d\u00111\fa\u0001\u0003\u0013Aq!!\u001b\u0001\t\u0013\tY'\u0001\u0013hKRdU-\u00193fe&\u001b(/\u00118e\u000bB|7\r[(s)\"\u0014xn^#yG\u0016\u0004H/[8o)\u0019\ti'a\u001d\u0002vA\u0019a#a\u001c\n\u0007\u0005E$AA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\t\u0003C\t9\u00071\u0001\u0002$!9\u00111HA4\u0001\u0004I\u0003\"CA=\u0001E\u0005I\u0011AA>\u0003qA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:%I\u00164\u0017-\u001e7uIM*\"!! +\t\u0005%\u0011qP\u0016\u0003\u0003\u0003\u0003B!a!\u0002\u000e6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0012\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0010\u0006\u0015%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u00111\u0013\u0001\u0012\u0002\u0013\u0005\u0011QS\u0001\u001dQ\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t9J\u000b\u0003\u0002\u0014\u0005}\u0004")
public class PartitionStateMachine
implements Logging {
    private final KafkaController controller;
    private final ControllerContext controllerContext;
    private final int controllerId;
    private final ZkUtils zkUtils;
    private final Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started partition state machine with initial state -> " + this.partitionState().toString());
    }

    public void shutdown() {
        this.partitionState().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped partition state machine");
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.partitionState().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$2(this, x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$3(this, x$2);
                return BoxedUnit.UNIT;
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.controller.epoch());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while moving some partitions to the online state", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.partitionState().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$partitionsInState$1(state, p)))).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState, partitions.mkString(",")})));
        try {
            this.brokerRequestBatch().newBatch();
            partitions.foreach((Function1 & Serializable & scala.Serializable)topicAndPartition -> {
                this.handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), targetState, leaderSelector, callbacks);
                return BoxedUnit.UNIT;
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.controller.epoch());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private void handleStateChange(String topic, int partition, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        block12: {
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            PartitionState currState = (PartitionState)this.partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> NonExistentPartition$.MODULE$);
            try {
                this.assertValidTransition(topicAndPartition, targetState);
                PartitionState partitionState = targetState;
                if (NewPartition$.MODULE$.equals(partitionState)) {
                    this.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                    String assignedReplicas = ((TraversableOnce)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s with assigned replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState, assignedReplicas})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (OnlinePartition$.MODULE$.equals(partitionState)) {
                    PartitionState partitionState2 = (PartitionState)this.partitionState().apply((Object)topicAndPartition);
                    if (NewPartition$.MODULE$.equals(partitionState2)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OfflinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OnlinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int leader = ((LeaderIsrAndControllerEpoch)this.controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to %s with leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState, BoxesRunTime.boxToInteger((int)leader)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (OfflinePartition$.MODULE$.equals(partitionState)) {
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState})));
                    this.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (NonExistentPartition$.MODULE$.equals(partitionState)) {
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState})));
                    this.partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                throw new MatchError((Object)partitionState);
            }
            catch (Throwable t) {
                this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition, currState, targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    private void initializePartitionState() {
        this.controllerContext().partitionReplicaAssignment().keys().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            Option option;
            Option option2 = this.controllerContext().partitionLeadershipInfo().get(topicPartition);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
                option = this.controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderIsrAndEpoch.leaderAndIsr().leader())) ? this.partitionState().put(topicPartition, (Object)OnlinePartition$.MODULE$) : this.partitionState().put(topicPartition, (Object)OfflinePartition$.MODULE$);
            } else if (None$.MODULE$.equals(option2)) {
                option = this.partitionState().put(topicPartition, (Object)NewPartition$.MODULE$);
            } else {
                throw new MatchError((Object)option2);
            }
            return option;
        });
    }

    private void assertValidTransition(TopicAndPartition topicAndPartition, PartitionState targetState) {
        if (!targetState.validPreviousStates().contains(this.partitionState().apply((Object)topicAndPartition))) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, targetState.validPreviousStates().mkString(","), targetState})) + new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState().apply((Object)topicAndPartition)})));
        }
    }

    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        BoxedUnit boxedUnit;
        Set<Object> set;
        List replicaAssignment = ((TraversableOnce)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).toList();
        List liveAssignedReplicas = (List)replicaAssignment.filter((Function1)((JFunction1.mcZI.sp & Serializable & scala.Serializable)arg_0 -> PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartition$1(set = this.controllerContext().liveBrokerIds(), arg_0)));
        Option option = liveAssignedReplicas.headOption();
        if (None$.MODULE$.equals(option)) {
            String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " encountered error during state change of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.controller.epoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " from New to Online, assigned replicas are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "], live brokers are [", "]. No assigned "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaAssignment.mkString(","), this.controllerContext().liveBrokerIds()})) + "replica is alive.";
            this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> failMsg);
            throw new StateChangeFailedException(failMsg);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int leader = BoxesRunTime.unboxToInt((Object)some.value());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Live assigned replicas for partition ", " are: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, liveAssignedReplicas})));
            LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leader, (List<Object>)liveAssignedReplicas);
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controller.epoch());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing leader and isr for partition ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndControllerEpoch})));
            try {
                this.zkUtils().createPersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), this.zkUtils().leaderAndIsrZkData(leaderAndIsr, this.controller.epoch()), this.zkUtils().createPersistentPath$default$3());
                this.controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topicAndPartition.topic(), topicAndPartition.partition()).get();
                String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " encountered error while changing "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.controller.epoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", "'s state from New to Online since LeaderAndIsr path already exists with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", " and controller epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leaderIsrAndEpoch.leaderAndIsr(), BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}));
                this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> failMsg);
                throw new StateChangeFailedException(failMsg);
            }
        } else {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), topicAndPartition})));
        try {
            boolean zookeeperPathUpdateSucceeded = false;
            ObjectRef newLeaderAndIsr = ObjectRef.create(null);
            Seq replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
            while (!zookeeperPathUpdateSucceeded) {
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                if (controllerEpoch > this.controller.epoch()) {
                    String failMsg = new StringOps(Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                    this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch())})) + failMsg);
                    throw new StateChangeFailedException(failMsg);
                }
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._1();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)leaderAndIsr, (Object)replicas);
                Tuple2 tuple23 = tuple22;
                LeaderAndIsr leaderAndIsr2 = (LeaderAndIsr)tuple23._1();
                Seq replicas2 = (Seq)tuple23._2();
                Tuple2<Object, Object> tuple24 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), topic, partition, leaderAndIsr2, this.controller.epoch(), currentLeaderAndIsr.zkVersion());
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                boolean updateSucceeded = tuple24._1$mcZ$sp();
                int newVersion = tuple24._2$mcI$sp();
                Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
                Tuple2.mcZI.sp sp3 = sp2;
                boolean updateSucceeded2 = sp3._1$mcZ$sp();
                int newVersion2 = sp3._2$mcI$sp();
                newLeaderAndIsr.elem = leaderAndIsr2.withZkVersion(newVersion2);
                zookeeperPathUpdateSucceeded = updateSucceeded2;
                replicasForThisPartition = replicas2;
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr.elem, this.controller.epoch());
            this.controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)((LeaderAndIsr)newLeaderAndIsr$1.elem).leader()), topicAndPartition})));
            Seq replicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
        }
        catch (NoReplicaOnlineException nroe) {
            throw nroe;
        }
        catch (Throwable sce) {
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, sce.getMessage()}));
            this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch())})) + failMsg);
            throw new StateChangeFailedException(failMsg, sce);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("After leader election, leader cache is updated to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.controllerContext().partitionLeadershipInfo().map((Function1 & Serializable & scala.Serializable)l -> new Tuple2(l._1(), l._2()), Map$.MODULE$.canBuildFrom())})));
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topic, partition);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                String failMsg = new StringOps(Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.partitionState().apply((Object)topicAndPartition)}));
                throw new StateChangeFailedException(failMsg);
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
        return leaderIsrAndControllerEpoch;
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$2(PartitionStateMachine $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
        boolean bl = !$this.controller.topicDeletionManager().isTopicQueuedUpForDeletion(topicAndPartition.topic());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$triggerOnlinePartitionStateChange$3(PartitionStateMachine $this, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
            PartitionState partitionState = (PartitionState)tuple2._2();
            if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                $this.handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, $this.controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsInState$1(PartitionState state$1, Tuple2 p) {
        Object object = p._2();
        PartitionState partitionState = state$1;
        return !(object != null ? !object.equals(partitionState) : partitionState != null);
    }

    public static final /* synthetic */ boolean $anonfun$initializeLeaderAndIsrForPartition$1(Set eta$0$1$1, int elem) {
        return eta$0$1$1.contains((Object)BoxesRunTime.boxToInteger((int)elem));
    }

    public PartitionStateMachine(KafkaController controller) {
        this.controller = controller;
        Logging.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.zkUtils = this.controllerContext().zkUtils();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.controllerContext());
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq("[Partition state machine on Controller " + this.controllerId() + "]: ");
    }
}

